/* Restricted bivariate smooth transition dynamic model */

new;

cls;

format /mb1 /ros 16,8;

library cml, pgraph;
#include cml.ext;

cmlset;
_cml_MaxIters = 200;
_cml_Algorithm = 3;
_cml_LineSearch = 2;
_cml_GradMethod = 1;
__output = 0;

load path = c:\;		/* enter data directory here */
load y1[] = nhann.txt;
load y2[] = shann.txt;

n = rows(y1);
c = ones(n,1);
t = cumsumc(c);

st = {-0.025,-1.097,-3.424,0.019,0.017,0.157,0.000,-0.241,0.589,-0.168,
	-0.295,-0.488,-0.101,0.007,0.385,-0.257,0.145};

rndseed 100;
_cml_A = zeros(1,3)~1~-1~zeros(1,12); _cml_B = 0;
{vm,ll,g,cov,retcode} = cml(y1~y2,0,&logl,st);
if retcode > 0; print "problem" retcode; endif;

var = diag(cov);
trat = vm./sqrt(var);

print"Restricted bivariate smooth transition dynamic model";
print;
print"Parameter estimates with t-ratios in parentheses:";
print;
print"North:";
print;
format /rdn 1,3;
print"alpha10:  " vm[1] "  (" trat[1] ")";
print"alpha11:  " vm[2] "  (" trat[2] ")";
print"alpha12:  " vm[3] "  (" trat[3] ")";
print"beta11 = beta12:  " vm[4] "  (" trat[4] ")";
print;
print"phi11:  " vm[6] "  (" trat[6] ")";
print"phi12:  " vm[7] "  (" trat[7] ")";
print"phi13:  " vm[8] "  (" trat[8] ")";
print"theta11:  " vm[9] "  (" trat[9] ")";
print"theta13:  " vm[10] "  (" trat[10] ")";
print;
print"South:";
print;
print"alpha20:  " vm[11] "  (" trat[11] ")";
print"alpha21:  " vm[12] "  (" trat[12] ")";
print"alpha22:  " vm[13] "  (" trat[13] ")";
print"beta21:  " vm[14] "  (" trat[14] ")";
print;
print"theta21:  " vm[15] "  (" trat[15] ")";
print"theta22:  " vm[16] "  (" trat[16] ")";
print"theta23:  " vm[17] "  (" trat[17] ")";
print;

proc logl(v,y);

	local y1,y2,str1,str2,str3,str4,x1,x2,e1,e2,sigsq1,sigsq2;
	y1 = y[.,1]; y2 = y[.,2];

	str1 = 1/(1+exp(-28.978*(t-(c*n*0.360))));
	str2 = 1/(1+exp(-0.087*(t-(c*n*0.783))));
	x1 = c~str1~str2~(str1.*t)~(str2.*t)~lagn(y1,1)~lagn(y1,2)~lagn(y1,3)~y2~lagn(y2,2);
	x1 = trimr(x1,3,0);
	e1 = trimr(y1,3,0) - x1*v[1:10];
	sigsq1 = e1'e1/(n-3);

	str3 = 1/(1+exp(-1.790*(t-(c*n*0.330))));
	str4 = 1/(1+exp(-36.481*(t-(c*n*0.632))));
	x2 = c~str3~str4~(str3.*t)~lagn(y2,1)~lagn(y2,2)~lagn(y2,3);
	x2 = trimr(x2,3,0);
	e2 = trimr(y2,3,0) - x2*v[11:17];
	sigsq2 = e2'e2/(n-3);

	retp((-(n-3)*ln(2*pi)) - ((n-3)/2)*ln(sigsq1*sigsq2) - 0.5*sumc(((e1.^2)/sigsq1)+((e2.^2)/sigsq2)));

endp;

end;
