/* Southern hemisphere restricted double smooth transition model */

new;

cls;

format /mb1 /ros 16,8;

library coint, pgraph, maxlik;

#include maxlik.ext;
maxset;

__output = 0;
__miss = 1;
__con = 0;

_max_MaxIters = 500;
_max_GradTol = 0.0001;
_max_CovPar = 1;
_max_Algorithm = 4;

load path = c:\;		/* enter data directory here */
load y[] = shann.txt;

n = rows(y);
c = ones(n,1);
t = cumsumc(c);

rndseed 300;
st = {1.734,0.332,21.402,0.635,-0.441,-0.671,-0.080,0.004,0.008,0.376,-0.190};
{vm,ll,g,cov,retcode} = maxlik(y,0,&logl,st);
if retcode > 0; print "problem"; endif;

var = diag(cov);
var[1:4] = ones(4,1);
trat = vm ./ sqrt(var);

print"Southern hemisphere restricted double smooth transition model";
print;
print"Parameter estimates with t-ratios in parentheses:";
print;
format /rdn 1,3;
print"alpha0:  " vm[5] "  (" trat[5] ")";
print"alpha1:  " vm[6] "  (" trat[6] ")";
print"alpha2:  " vm[7] "  (" trat[7] ")";
print"beta0:  " vm[8] "  (" trat[8] ")";
print"beta1:  " vm[9] "  (" trat[9] ")";
print;
print"gamma1:  " vm[1];
print"tau1:  " vm[2];
print"gamma2:  " vm[3];
print"tau2:  " vm[4];
print;
print"phi1:  " vm[10] "  (" trat[10] ")";
print"phi2:  " vm[11] "  (" trat[11] ")";
print;

str1 = 1/(1+exp(-vm[1]*(t-(c*n*vm[2]))));
str2 = 1/(1+exp(-vm[3]*(t-(c*n*vm[4]))));
x = c~str1~str2~t~(str1.*t); yfit = x*vm[5:9];
_pdate = 0;
_plegctl = 1;
_plegstr = "Southern hemisphere annual temperture\000Fitted double smooth transition";
_pmcolor = {0,0,0,0,0,0,0,0,15};
_pcolor = {0,0};
xy(t,y~yfit);

proc logl(v,y);
	local strr1, strr2, xx, rr, lrr, jj, ee, sigsq, lrr3, lrr6;
	strr1 = 1/(1+exp(-v[1]*(t-(c*n*v[2]))));
	strr2 = 1/(1+exp(-v[3]*(t-(c*n*v[4]))));
	xx = c~strr1~strr2~t~(strr1.*t); rr = y - xx*v[5:9];
	lrr = lag1(rr); lrr[1] = 0;
	lrr = lrr~lagn(rr,2); lrr[1:2,2] = zeros(2,1);
	ee = rr - lrr*v[10:11];
	sigsq = ee'*ee/n;
	retp(-0.5*(ln(2*pi*sigsq)+(ee.*ee/sigsq)));
endp;

end;
