/* Unit root tests */

new;

cls;

library optmum, coint, pgraph;

#include optmum.ext;
optset;

__output = 0;
__miss = 1;
__con = 0;

_opmiter = 500;
_opstep = 1;
_opgtol = 0.0001;
_opshess = 0;
_opalgr = 2;

load path = c:\;		/* enter data directory here */
load y[] = nhann.txt;		/* enter filename here */

print"Treatment of trend (0 = no trends, 1 = fixed trend, 2 = transition in trends)";; l = con(1,1); print; print;

n = rows(y);
c = ones(n,1);
t = cumsumc(c);


/* ADF with trend */

print"Downward testing:";

k = 8;
do while k > 1;

	{g1,g2,g3,g4} = adftr(y,k,1);

	print"diff lag" k-1 "      t-rat" g3[k+2] "      df" n-k-2 "      continue (1 = yes, 0 = no)";;
	labans0: ans = con(1,1);
	if ans == 0; k1 = k; goto label0;
	elseif ans == 1; goto lablp0;
	else; goto labans0;
	endif;

lablp0:
k = k - 1;
endo;

k1 = 1;
label0:

{g1,g2,g3,g4} = adftr(y,k1,1);
ts0 = (g1[3]-1)/g2[3];
print;
print"ADF              " ts0;
print; print;


/* 1 STR */

taust = {0.2,0.4,0.6,0.8};

pv = zeros(2,4);
fminv = zeros(4,1);

m = 1;
do while m <= 4;

	st1 = 1|taust[m];
	{p,fmin,g,retcode} = optmum(&lf1,st1);
	if retcode > 0; print"problem on" m; endif;

	pv[.,m] = p;
	fminv[m] = fmin;

m = m + 1;
endo;

popt = pv[.,minindc(fminv)];

str = 1/(1+exp(-popt[1]*(t-(c*n*popt[2]))));
if     l == 0; x = c~str;
elseif l == 1; x = c~str~t;
elseif l == 2; x = c~str~t~(str.*t); endif;
b = invswp(x'*x)*x'*y;
r = y - x*b;
fit1 = x*b;

print"Downward testing:";

k = 8;
do while k > 1;

	{g1,g2,g3,g4} = adftr(r,k,-1);

	print"diff lag" k-1 "      t-rat" g3[k] "      df" n-k "      continue (1 = yes, 0 = no)";;
	labans1: ans = con(1,1);
	if ans == 0; k1 = k; goto label1;
	elseif ans == 1; goto lablp1;
	else; goto labans1;
	endif;

lablp1:
k = k - 1;
endo;

k1 = 1;
label1:

{g1,g2,g3,g4} = adftr(r,k1,-1);
ts1 = (g1[1]-1)/g2[1];
print;
if     l == 0; print"s.alpha          " ts1; 
elseif l == 1; print"s.alpha.(beta)   " ts1; 
elseif l == 2; print"s.alpha.beta     " ts1; endif;
print; print;


/* 2 STRs */

pv = zeros(4,6);
fminv = zeros(6,1);
ctr = 1;
taust = {0.2,0.4,0.6,0.8};

j = 1;
do while j <= 3;

i = j+1;
do while i <= 4;

	start = 1|taust[j]|1|taust[i];
	
	{p,fmin,g,retcode} = optmum(&lf2,start);
	if retcode > 0; print"problem on" taust[j] taust[i] ctr; endif;
		
	pv[.,ctr] = p;
	fminv[ctr] = fmin;
	ctr = ctr+1;

i = i + 1;
endo;

j = j + 1;
endo;

popt = pv[.,minindc(fminv)];
	
str1 = 1/(1+exp(-popt[1]*(t-(c*n*popt[2]))));
str2 = 1/(1+exp(-popt[3]*(t-(c*n*popt[4]))));
if     l == 0; x = c~str1~str2;
elseif l == 1; x = c~str1~str2~t;
elseif l == 2; x = c~str1~str2~t~(str1.*t)~(str2.*t); endif;
b = invswp(x'*x)*x'*y;
r = y - x*b;
fit2 = x*b;
dif = x*b-lag1(x*b);

print"Downward testing:";

k = 8;
do while k > 1;

	{g1,g2,g3,g4} = adftr(r,k,-1);

	print"diff lag" k-1 "      t-rat" g3[k] "      df" n-k "      continue (1 = yes, 0 = no)";;
	labans2: ans = con(1,1);
	if ans == 0; k1 = k; goto label2;
	elseif ans == 1; goto lablp2;
	else; goto labans2;
	endif;

lablp2:
k = k - 1;
endo;

k1 = 1;
label2:

{g1,g2,g3,g4} = adftr(r,k1,-1);
ts2 = (g1[1]-1)/g2[1];
print;
if     l == 0; print"s.2.alpha        " ts2;
elseif l == 1; print"s.2.alpha.(beta) " ts2;
elseif l == 2; print"s.2.alpha.beta   " ts2; endif;
print;

/* Graphs */

_pdate = 0;
if     l == 0; title("No trend included; smooth transition in level");
elseif l == 1; title("Trend included; smooth transition in level only");
elseif l == 2; title("Smooth transition in level and trend"); endif;
xy(t,y~fit1);
if     l == 0; title("No trend included; 2 smooth transitions in level");
elseif l == 1; title("Trend included; 2 smooth transitions in level only");
elseif l == 2; title("2 Smooth transitions in level and trend"); endif;
xy(t,y~fit2);


/* Procedures */

proc lf1(p);
	local strr, xx, bb, rr;
	strr = 1/(1+exp(-p[1]*(t-(c*n*p[2]))));
	if     l == 0; xx = c~strr;
	elseif l == 1; xx = c~strr~t;
	elseif l == 2; xx = c~strr~t~(strr.*t); endif;
	bb = invswp(xx'*xx)*xx'*y;
	rr = y - xx*bb;
	retp(rr'*rr);
endp;

proc lf2(p);
	local strr1, strr2, xx, bb, rr;
	strr1 = 1/(1+exp(-p[1]*(t-(c*n*p[2]))));
	strr2 = 1/(1+exp(-p[3]*(t-(c*n*p[4]))));
	if l == 0; xx = c~strr1~strr2;
	elseif l == 1; xx = c~strr1~strr2~t;
	elseif l == 2; xx = c~strr1~strr2~t~(strr1.*t)~(strr2.*t); endif;
	bb = invswp(xx'*xx)*xx'*y;
	rr = y - xx*bb;
	retp(rr'*rr);
endp;

end;
