plot.deldir_function(object, add = F, wlines = c("both", "triang", "tess", "none"), wpoints
	 = c("both", "real", "dummy", "none"), number = F, cex = 0.5, nex = 
	0.75, col = NULL, lty = NULL, pch = NULL, xlim = NULL, ylim = NULL,
	plot.colours = T, density = -1, plot.axis = F, plot.square = F, xText
	 = "", colTable = NULL)
{
#######
# modified by ivind Skare
# for use in vorSim2D, Version 1.0, Feb 15, 2001
#
#######
# Function plot.deldir to produce a plot of the Delaunay triangulation
# and Dirichlet tesselation of a point set, as produced by the
# function deldir().
# Function deldir
#
#   Copyright (C) 1996 by T. Rolf Turner
#
#   Permission to use, copy, modify, and distribute this software and
#   its documentation for any purpose and without fee is hereby
#   granted, provided that the above copyright notice appear in all
#   copies and that both that copyright notice and this permission
#   notice appear in supporting documentation.
#
# ORIGINALLY PROGRAMMED BY: Rolf Turner in 1987/88, while with the
# Division of Mathematics and Statistics, CSIRO, Sydney, Australia.
# Re-programmed by Rolf Turner to adapt the implementation from a
# stand-alone Fortran program to an S function, while visiting the
# University of Western Australia, May 1995.  Further revised
# December 1996.
#
	wlines <- match.arg(wlines)
	wpoints <- match.arg(wpoints)
	if(is.null(class(object)) || class(object) != "deldir") {
		cat("Argument is not of class deldir.\n")
		return(invisible())
	}
	if(is.null(col))
		col <- c(1, 1, 1, 1, 1)
	else col <- rep(col, length.out = 5)
	if(is.null(lty))
		lty <- 1:2
	else lty <- rep(lty, length.out = 2)
	if(is.null(pch))
		pch <- 1:2
	else pch <- rep(pch, length.out = 2)
	plot.del <- switch(wlines,
		both = T,
		triang = T,
		tess = F,
		none = F)
	plot.dir <- switch(wlines,
		both = T,
		triang = F,
		tess = T,
		none = T)
	plot.rl <- switch(wpoints,
		both = T,
		real = T,
		dummy = F,
		none = F)
	plot.dum <- switch(wpoints,
		both = T,
		real = F,
		dummy = T,
		none = F)
	delsgs <- object$delsgs
	dirsgs <- object$dirsgs
	n <- object$n.data
	rw <- object$rw
	if(plot.del) {
		x1 <- delsgs[, 1]
		y1 <- delsgs[, 2]
		x2 <- delsgs[, 3]
		y2 <- delsgs[, 4]
	}
	if(plot.dir) {
		cell <- dirsgs[, 1]
		u1 <- dirsgs[, 2]
		v1 <- dirsgs[, 3]
		u2 <- dirsgs[, 4]
		v2 <- dirsgs[, 5]
		colour <- dirsgs[, 6]
		if(is.null(colTable)) {
			colTable <- c(0:max(colour))
			#			cat(colTable, "\n")
			colTable[1] <- 4
			if(max(colour) > 3)
				colTable[5] <- 0
		}
	}
	x <- object$summary[, 1]
	y <- object$summary[, 2]
	if(!add) {
		#		pty.save <- par()$pty
		#		on.exit(par(pty = pty.save))
		if(plot.square) par(pty = "s")
		if(is.null(xlim))
			xlim <- rw[1:2]
		if(is.null(ylim))
			ylim <- rw[3:4]
		plot(0, 0, type = "n", xlim = xlim, ylim = ylim, xlab = "",
			ylab = "", axes = F)
		title(xText, cex = 1)
		if(plot.axis) {
			axis(side = 1)
			axis(side = 2)
			axes(xlab = "x", ylab = "y", axes = F)
		}
	}
	if(plot.del)
		segments(x1, y1, x2, y2, col = col[1], lty = lty[1])
	if(plot.dir) {
		if(!plot.del)
			lty[2] <- lty[1]
		if(plot.colours) {
			nDir <- length(u1)
			x <- rep(0, nDir)
			y <- rep(0, nDir)
			x[1] <- u1[1]
			y[1] <- v1[1]
			ind <- 2
			for(i in 2:nDir) {
				if(cell[i] != cell[i - 1]) {
					x[ind] <- u2[i - 1]
					y[ind] <- v2[i - 1]
					#cat("x:", x[1:ind], "y:", y[1:ind], "\n")
					polygon(x[1:ind], y[1:ind], col = 
						colTable[colour[i - 1] + 1],
						density = density, border = F)
					ind <- 1
				}
				x[ind] <- u1[i]
				y[ind] <- v1[i]
				ind <- ind + 1
			}
			x[ind] <- u2[nDir]
			y[ind] <- v2[nDir]
			#cat("x:", x[1:ind], "y:", y[1:ind], "\n")
			polygon(x[1:ind], y[1:ind], col = colTable[colour[
				nDir] + 1], density = density, border = F)
		}
		if(wlines != "none")
			segments(u1, v1, u2, v2, col = col[2], lty = lty[2])
	}
	if(plot.rl) {
		x.real <- x[1:n]
		y.real <- y[1:n]
		points(x.real, y.real, pch = pch[1], col = col[3], cex = cex)
	}
	if(plot.dum) {
		x.dumm <- x[ - (1:n)]
		y.dumm <- y[ - (1:n)]
		points(x.dumm, y.dumm, pch = pch[2], col = col[4], cex = cex)
	}
	if(number) {
		xoff <- 0.02 * diff(range(x))
		yoff <- 0.02 * diff(range(y))
		text(x + xoff, y + yoff, 1:length(x), cex = nex, col = col[
			5])
	}
	invisible()
}
