/*
The source code is modified by ivind Skare
for use in vorSim2D, Version 1.0, Feb 15, 2001.
*/
#ifndef HULLOWN_
#define HULLOWN_ 1

#define REMOVED_MARK -1.0


typedef struct Edge {  
  int p1, p2; /* p1 < p2 */
  point pt1, pt2;
  struct Edge * prev;
  struct Edge * next;
} Edge;

typedef struct Vertex Vertex;

struct Data {
  point x;
  double w;
  short trueCol;
  int * sumProp;
 // True colour
  //  Data * next;
};

struct DataList {
  short removed;
  Data * d;
  DataList * next;
};


extern int counter;
extern int gIt;
extern int gAccept;
extern int gInteger;
extern int gDebugPrint;
extern int gDebugCheck;
extern int gLocalSimplexStructure;
extern point gPoints;
extern Vertex ** gVertex;
extern int gMaxPos;
extern point * gDelNeigh;
extern int gnDelNeigh;
extern int gnMaxNeigh;
extern int gnDirEdges; /* May be different from gnEdges due to boundary box */
extern int gnEdges;

extern Edge * gFirstEdge;

extern Vertex * gFirstVertex;


extern int n40[1600];
extern int n20[400];
extern int n10[100];

extern simplex * gSimplex40[1600][10];
extern simplex * gSimplex20[400][40];
extern simplex * gSimplex10[100][160];




// void findDirichletEdges();
// void addDirichletEdge(Vertex *v, int i1, int i2);
// void truncateDirichletEdges();
void writeToSFile(simplex * root, char * fileName);
void setNumDel(int n);
void addTriangle(simplex * s);
void removeTriangle(simplex * s);

void printTriangle(simplex * s);
int checkAll(simplex * s);
void printAll(simplex * s);
void printEdge(Edge * e);
void printEdges(Vertex * v);
void printNeigh(Vertex * v);
void printAllNeigh();
void printVertices();
void addEdge(Edge ** first, int * nEdges, point p1, point p2);
void removePointFromConvexHull(simplex ** root, site pDel,
			       gsitef * get_next_neigh,
			       site_n * site_numm_neigh);
int addPointToConvexHull(simplex *root);
//int Areasign(point a, point b, point c);
int Areasign(longPoint a, longPoint b, longPoint c);
void updateColDiff(Vertex *v);
void copyVertex(Vertex * from, Vertex * to);
Vertex * findVertex(point pt);
void addVertex(Vertex ** vList, point vert, short colour);
void deleteVertex(Vertex ** vList, point pt);
void freeVertex(Vertex *v);
void deleteVertices();
void resetVertices();
void removeNeigh(Vertex * v, Vertex * vDel);
void addNeigh(Vertex * v, Vertex *vNew);
simplex * findFirst(simplex * s);
void shareEdge(simplex * s1, simplex * s2, point * a, int * indexI, int * indexJ);
int seesOwn(site p, simplex *s);
void freeSimp(simplex * s);
void freeRootNew(simplex * start);
void freeEdges(Edge ** first);
#endif
