/*
vorSim2D: C++-routines for simulation from a coloured Voronoi
tessellation model.

Version 1.0

Copyright (C)  2001 ivind Skare

  This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU
  General Public License as published by the Free Software Foundation; either ve
rsion 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT AN
Y WARRANTY; without
  even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPO
SE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along with t
his program; if not,
  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Bost
on, MA 02111-1307,
  USA.


  The author's contact information:

 ivind Skare                Office tel.: (+47) 22 85 26 56
 Norwegian Computing Center         Fax:         (+47) 22 69 76 60 
 P.O.Box 114 Blindern               E-mail:      Oivind.Skare@nr.no 
 NO-0314 Oslo, Norway
*/
/* $Id: model_scan.c,v 2.1 1995/06/22 06:10:53 skorstad Exp $ */
#define bhalloc(p,u) (p == 0 ? malloc(u) : realloc(p,u))

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "model_scan.h"

#define MAX_LENGTH_COMM 50


int iReadCommand(FILE *, char *[], int, struct COMMAND *);

/************************************************************************
  This procedure return a struct with all the commands and their
  arguments. The syntax is checked for formal errors.
************************************************************************/
struct COMMAND *spReadModelFile(char *cpFile, 
				char *cpaCommands[], int nCommands){

  struct COMMAND *spComms;
  FILE *epFile;
  int i, nRead;
  int bOK = 1;

  epFile = fopen(cpFile, "r");
  if (epFile == NULL){
    printf("ERROR: Could not open file: %s in spReadModelFile \n", cpFile);
    return(NULL);
  }

  spComms = (struct COMMAND *) malloc(nCommands*sizeof(struct COMMAND));
  if (spComms == NULL){
    printf("ERROR: Could not allocate %d struct COMMAND in spReadModelFile\n", 
	   nCommands);
    exit(-1);
  }
  for (i=0; i<nCommands; i++){
    spComms[i].bRead = 0;
    spComms[i].nArgs = 0;
    spComms[i].cppArgs = NULL;
  }

  do {
    nRead = iReadCommand(epFile, cpaCommands, nCommands, spComms);
    if (nRead < 0)
      bOK = 0;
  } while (nRead != 0);


  if (bOK == 0){
    printf("***Correct the errors in the file: %s  \n", cpFile);
    exit(1);
  }

  return(spComms);
}


/**************************************************************************
  This procedure reads from the input file until a slash indicating
  end of command is read
***************************************************************************/

int iReadCommand(FILE *epFile, char *cpaCommands[], int nCommands,
		 struct COMMAND *spComms){

  int nRead;
  int iComm = -1;
  char cChar;
  int i;
  char cpRead[500];
  char cpCommComp[100];

  nRead = fscanf(epFile, "%s", cpRead);
  if (nRead == EOF)
    return(0);

  if (cpRead[0] == '!'){
    do 
      cChar = fgetc(epFile);
    while (!((cChar == '\n') || (cChar == EOF))); 
    if (cChar == '\n'){
      nRead = iReadCommand(epFile, cpaCommands, nCommands, spComms);
      return(nRead);
    }
    return(0);
  }

  for (i=0; i<strlen(cpRead); i++)
    cpRead[i] = toupper(cpRead[i]);

  for (i=0; i<nCommands; i++){
    strcpy(cpCommComp, cpaCommands[i]);
    nRead = strncmp(cpaCommands[i], cpRead, MAX_LENGTH_COMM);
    if (nRead == 0)
      iComm = i;
  }
  
  if (iComm == -1){
    printf("ERROR: %s is not a command \n", cpRead);
    do {
      int nMore;
      nMore = fscanf(epFile, "%s", cpRead);
      if (nMore == EOF)
	return(-1);
    } while ((cpRead[0] != '/') || (strlen(cpRead) > 1));
    return(-1);
  }

  if (spComms[iComm].bRead == 1){
    printf("ERROR: Command %s is read twice \n", cpaCommands[iComm]);
    do {
      int nMore;
      nMore = fscanf(epFile, "%s", cpRead);
      if (nMore == EOF)
	return(-1);
    } while ((cpRead[0] != '/') || (strlen(cpRead) > 1));
  }
   
  spComms[iComm].bRead = 1;

  do {
    nRead = fscanf(epFile, "%s", cpRead);

    /* Start a comment */
    if (cpRead[0] == '<'){
      do {
	nRead = fscanf(epFile, "%s", cpRead);
      } while ((nRead != EOF) && (cpRead[strlen(cpRead)-1] != '>'));
      if (nRead == EOF){
	printf("ERROR: Command %s was followed by a comment that %s\n",
	       cpaCommands[iComm], "was never ended");
	return(-1);
      }
    }

    /* Start a comment */
    else if (cpRead[0] == '!'){
      do 
	cChar = fgetc(epFile);
      while (!((cChar == '\n') || (cChar == EOF))); 
      if (cChar == EOF){
	printf("ERROR: Command %s was not terminated with a / \n",
	       cpaCommands[iComm]);
	return(-1);
      }

    }
    /* Reading end of command */
    else if ((cpRead[0] == '/') && (strlen(cpRead) == 1))
      return(1);
    
    /* Reading a regular argument */
    else {
      spComms[iComm].cppArgs = (char **) 
	bhalloc(spComms[iComm].cppArgs, 
		(spComms[iComm].nArgs+1)*sizeof(char *));
      if (spComms[iComm].cppArgs == NULL){
	printf("ERROR: Could not allocate for %d arguments in iReadCommand \n",
	       spComms[iComm].nArgs+1);
	exit(1);
      }
      spComms[iComm].cppArgs[spComms[iComm].nArgs] = 
	(char *) malloc((strlen(cpRead)+1)*sizeof(char));
      if (spComms[iComm].cppArgs[spComms[iComm].nArgs] == NULL){
	printf("ERROR: Could not allocate for %d chars in iReadCommands \n",
	       strlen(cpRead));
	exit(1);
      }
      strcpy(spComms[iComm].cppArgs[spComms[iComm].nArgs], cpRead);
      spComms[iComm].nArgs++;
    }
  } while (nRead != EOF);

  printf("ERROR: Command %s was not terminated with / \n", cpaCommands[iComm]);
  return(-1);
    
}


/*************************************************************************
  This procedure verifies that a text-string really is a number
**************************************************************************/
int bIsDouble(char *cpString){


  int iLength;
  double dValue;


  iLength = sscanf(cpString, "%lf", &dValue);
  return(iLength);

}

