/*
vorSim2D: C++-routines for simulation from a coloured Voronoi
tessellation model.

Version 1.0

Copyright (C)  2001 ivind Skare

  This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU
  General Public License as published by the Free Software Foundation; either ve
rsion 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT AN
Y WARRANTY; without
  even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPO
SE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along with t
his program; if not,
  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Bost
on, MA 02111-1307,
  USA.


  The author's contact information:

 ivind Skare                Office tel.: (+47) 22 85 26 56
 Norwegian Computing Center         Fax:         (+47) 22 69 76 60 
 P.O.Box 114 Blindern               E-mail:      Oivind.Skare@nr.no 
 NO-0314 Oslo, Norway
*/
#ifndef _RANDOM
#define _RANDOM
class RandomSeed
{
public:
  RandomSeed(void);
  ~RandomSeed(void); 

  void setSeed(unsigned  int iseed);
  int setSeed(const char * seedfile);

  unsigned  int getSeed(void) const; 
 
protected:
  static unsigned int seed;
private:
  char errorMsg[1024];
};

class RandomGenerator : public RandomSeed 
{
public:
  RandomGenerator(char *filename);  
  RandomGenerator(unsigned  int iseed);
  ~RandomGenerator() {}
  void normal01(double &, double &);
  double unif01(void);
  double unif(double min,double max);       
  double normal(double expectation, double stdev){
    double x1,x2;
    normal01(x1,x2);
    return (expectation + x1*stdev);
  }
  int iUnif(int min,int max);            

};

#endif
