/*
vorSim2D: C++-routines for simulation from a coloured Voronoi
tessellation model.

Version 1.0

Copyright (C)  2001 ivind Skare

  This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU
  General Public License as published by the Free Software Foundation; either ve
rsion 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT AN
Y WARRANTY; without
  even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPO
SE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along with t
his program; if not,
  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Bost
on, MA 02111-1307,
  USA.


  The author's contact information:

 ivind Skare                Office tel.: (+47) 22 85 26 56
 Norwegian Computing Center         Fax:         (+47) 22 69 76 60 
 P.O.Box 114 Blindern               E-mail:      Oivind.Skare@nr.no 
 NO-0314 Oslo, Norway
*/
#ifndef SIMULATION__
#define SIMULATION__ 1

#define DELAUNAY 1
#define ADD 0
#define REMOVE 1
#define MOVE 2
#define MOVE_ADD 3
#define MOVE_REMOVE 4

#define XMIN 0
#define XMAX 1
#define YMIN 2
#define YMAX 3

#define NCLIQUES 4
#define SINGLE 0
#define HOMOG 1
#define CONT 2
#define DISCONT 3


#define G_PI 3.14159

//typedef double * Point;

#ifdef SKARE
class Point {
public:
  double * x;
  Point(int n) { x = new double[n];}
  Point operator 
  Point(Point pt, int n) {
    x = new double[n];
    for (int i=0;i<n;i++)
      x[i] = pt.x[i];
  }
};
#endif

struct mPoint {
  point pt;
  short col;
};

class Simulation {
  RandomGenerator * random;
  const Model * model;
  //  gsitef *get_s;
  //  site_n *site_numm;
  char * fileName;
  short dim; // == gDim
  int nPoints;
  int nIter;
  int action;

  short init;
  short initRandom;
  int initNPoints;

  int restart;

  short logBinaer;
  int logInterval;

  int accept;
  
  int nClique[NCLIQUES];

  int pixelDiff;
  int sumPixelDiff;

  int sumColDiff;

  double sumAlpha;

  double mult_up;
  double region[4];
  double volRegion;

  int nDataX;
  int nDataY;

  short estimateMarginalPosterior;
  int simulateFromPosterior;

  Data ** data;
  Data ** trueImage;

  double sigmaMove;

  double prob[3]; // Probabilities for suggesting different moves

  double movePot;
  double potLikelihood;
  double sumPotLikelihood;
  
  simplex * root;

  short readMarkedPoints;
  char * markedPointsFileName;

public:
  Simulation(const Model * mod, Input * input);
  ~Simulation();

  void initMH();
  void readMarkedPointsFile();


  unsigned int getSeed() { return random->getSeed();}
  void setSeed(unsigned int seed) {random->setSeed(seed); return;}
  void multUpRegion(double mult);

  void simulation();
  void addProposal();
  void removeProposal();
  void moveProposal();

  void writeMarginalPosterior(FILE * file);
  void updateMarginalPosterior(int weight);

  void updateColDiff(Vertex * v);
  void updateLogInfo();
  int acceptance(double alpha);
  void drawAction();
  mPoint * drawPoint();
  mPoint * movePoint(point pt);
  Vertex * addVoronoi(mPoint * x);
  void addVoronoi(point pt);
  void removeVoronoi(point pt);
  void moveVoronoi(mPoint * x);
  point selectPoint();
  void findDirichletEdges();
  void addDirichletEdge(Vertex *v, int i1, int i2);
  void truncateDirichletEdges();

  double acceptProb(Vertex * v, int * resSum);
  double acceptProbPrior(Vertex * v, int * resSum);
  double updateFirstOrder(Vertex *v, int * resSum);
  double updateSecondOrder(Vertex *v);
  double findAreaCell(Vertex * v);
  double findAreaComponent(Vertex * v);
  double updateAreaInteraction(Vertex *v);
  double potentialLikelihood(Vertex * v);
  double potentialLikelihoodAdd(Vertex * v);
  double potentialLikelihoodRemove(Vertex * v);
  double updatePotentialLikelihood(Vertex * v, Vertex * w,
				   DataList * dl);
  void checkCliques();
  void initializeDataInVertexStructure();
  void checkDataInVertexStructure();
  void removeDataFromVertices(Vertex * v, int first);

  void buildConvexHull();
  void writeToFile();
  //  void writeToSFile(simplex * root);

  int inside(point pt) {
    int i;
    int outside = 0;

    for (i=0;i<pdim;i++) {
      if (pt[i] < region[2*i] || pt[i] > region[2*i+1]) {
	outside = 1;
	break;
      }
    }

    return !outside;
  }
};

struct Deldir {
  int nPoints;
  int nEdges;
  struct Delsgs {
    double * x1; // End point 1
    double * y1;
    double * x2; // End point 2
    double * y2;
  } delsgs;
  struct Dirsgs {
    short * cell; // NB: Extra information for plotting of coloured V. cells
    double * x1; // End point 1
    double * y1;
    double * x2; // End point 2
    double * y2;
    short * colour; // NB: Extra information for plotting of coloured V. cells
  } dirsgs;
  double * x; // The points
  double * y;

  double rw[4]; // The box

  Deldir(int nE, int nP, double xmin, double ymin, double xmax,
	 double ymax) {
    nEdges = nE;
    nPoints = nP;
    delsgs.x1 = new double[nEdges];
    delsgs.y1 = new double[nEdges];
    delsgs.x2 = new double[nEdges];
    delsgs.y2 = new double[nEdges];
    dirsgs.cell = (short *) malloc(2*nEdges * sizeof(short));
    dirsgs.colour = (short *) malloc(2*nEdges * sizeof(short));
    dirsgs.x1 = (double *) malloc(2*nEdges * sizeof(double));
    dirsgs.y1 = (double *) malloc(2*nEdges * sizeof(double));
    dirsgs.x2 = (double *) malloc(2*nEdges * sizeof(double));
    dirsgs.y2 = (double *) malloc(2*nEdges * sizeof(double));
    x = new double[nPoints];
    y = new double[nPoints];
    rw[0] = xmin;
    rw[1] = ymin;
    rw[2] = xmax;
    rw[3] = ymax;
  }
  ~Deldir() {
    delete [] delsgs.x1;
    delete [] delsgs.x2;
    delete [] delsgs.y1;
    delete [] delsgs.y2;

    delete [] x;
    delete [] y;
    
    free(dirsgs.cell);
    free(dirsgs.x1);
    free(dirsgs.x2);
    free(dirsgs.y1);
    free(dirsgs.y2);
    free(dirsgs.colour);
  }
};
#endif
