/*
vorSim2D: C++-routines for simulation from a coloured Voronoi
tessellation model.

Version 1.0

Copyright (C)  2001 ivind Skare

  This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU
  General Public License as published by the Free Software Foundation; either ve
rsion 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT AN
Y WARRANTY; without
  even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPO
SE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along with t
his program; if not,
  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Bost
on, MA 02111-1307,
  USA.


  The author's contact information:

 ivind Skare                Office tel.: (+47) 22 85 26 56
 Norwegian Computing Center         Fax:         (+47) 22 69 76 60 
 P.O.Box 114 Blindern               E-mail:      Oivind.Skare@nr.no 
 NO-0314 Oslo, Norway
*/
#ifndef VERTEX_
#define VERTEX_ 1
struct Vertex {
  short * mark;
  point pt;
  int nSimp;
  int nDirEdges;
  int nNeigh;
  int it;
  int clique;
  int newClique;
  int visit; // Used in Simulation::moveProposal when updating colDiff
  int nData;
  int nDataLastAdded;
  int pixelDiff;

  double areaCell;
  double newAreaCell;
  double areaComponent;
  double newAreaComponent;

  DataList * dataList;
  Edge * delEdges;
  Edge * dirEdges;
  short colour;
  short colDiff;
  short colDiffNew;
  Vertex ** neigh;
  Vertex * prev;
  Vertex * next;
  simplex ** simp;

  int findPixelDiff() {
    int n = 0;
    DataList * dl = dataList;

    while (dl) {
      n += (dl->d->trueCol != colour);
      dl = dl->next;
    }
    if (n != pixelDiff)
      printf("Error(findPixelDiff): n!= pixelDiff\n");
    
    return n;
  }

  void updateProp(int weight) {    
    DataList * dl = dataList;

    while (dl) {
      dl->d->sumProp[colour] += weight;
      dl = dl->next;
    }
  }

  void print() {
    printf("(%6.2f %6.2f) col %d clDiff %d clDNew %d nData %d pixDiff %d cliq %d area %4.1f newArea %4.1f it %d \n",
	   pt[0], pt[1], colour, colDiff, colDiffNew, nData, pixelDiff,
	   clique, areaCell, newAreaCell, it);
    return;
  }

  void printNeigh() {
    int i;

    for (i=0;i<nNeigh;i++)
      neigh[i]->print();

    return;
  }
    

  Vertex() {
    nSimp = nDirEdges = 0;
    simp = (simplex **) malloc(10*sizeof(simplex *));
    nNeigh = 0;
    nData = 0;
    nDataLastAdded = 0;
    dataList = NULL;
    neigh = (Vertex **) malloc(10*sizeof(Vertex *));
    mark = (short *) malloc(10*sizeof(short));
    pt = NULL;
    this->colour = -1; // NOT DEFINED
    pixelDiff = 0;
    delEdges = NULL;
    dirEdges = NULL;
    visit = -1; // NOT DEFINED
    it = -1; // NOT DEFINED
    colDiff = 0;
    colDiffNew = 0;
  }

  Vertex(point vert, short col) {
    nSimp = nDirEdges = 0;
    simp = (simplex **) malloc(10*sizeof(simplex *));
    nNeigh = 0;
    nData = 0;
    nDataLastAdded = 0;
    dataList = NULL;
    neigh = (Vertex **) malloc(10*sizeof(Vertex *));
    mark = (short *) malloc(10*sizeof(short));
    pt = vert;
    this->colour = col;
    pixelDiff = 0;
    delEdges = NULL;
    dirEdges = NULL;
    it = gIt;
    visit = -1;
    colDiff = 0;
    colDiffNew = 0;
  }    

  ~Vertex() {
    nullify();
  }

  void nullify() {
    removeAllData();
    if (neigh) {
      free(neigh);
      neigh = NULL;
    }
    if (mark) {
      free(mark);
      mark = NULL;
    }
    if (simp) {
      free(simp);
      simp = NULL;
    }

    if (delEdges)
      freeEdges(&delEdges);
    if (dirEdges)
      freeEdges(&dirEdges);

    return;
  }    

  void reset() {
    int i;

    nNeigh = 0;
    for (i=0;i<nNeigh;i++) {
      neigh[i] = NULL;
      mark[i] = 0;
    }

    nSimp = 0;
    for (i=0;i<nSimp;i++)
      simp[i] = NULL;

    return;
  }

  void insertData(Data * d) {
    DataList * newDL = (DataList *) malloc(sizeof(DataList));
    newDL->d = d;
    newDL->removed = 1;
    newDL->next = dataList;
    dataList = newDL;
    nData++;
    nDataLastAdded++;

    if (d->trueCol != colour)
      pixelDiff++;

    return;
  }

  void removeAllData() {
    DataList * dl;
    DataList * dlnext;

    dl = dataList;

    while (dl) {
      dlnext = dl->next;
      free(dl);
      dl = dlnext;
    }

    pixelDiff = 0;
    nData = 0;

    return;
  }

  void removeFirstData() {
    int ind;
    DataList * dl = dataList;
    DataList * dlnext;

    ind = 0;
    while (ind<nDataLastAdded) {
      dlnext = dl->next;
//       if (!dl->removed)
// 	break;
//       else {
      nData--;
      pixelDiff -= (dl->d->trueCol != colour);
      free(dl);
      dl = dlnext;
      ind++;
    }
    dataList = dl;

    return;
  }

  void printData() {
    DataList * dl = dataList;
    printf("# data: %d\n", nData);
    while (dl) {
      printf("%6.4f %6.4f %6.4f %d %d\n", dl->d->x[0], dl->d->x[1],
	     dl->d->w, dl->d->trueCol, dl->removed);
      dl = dl->next;
    }
  }

  void removeData() {
    int first = 1;
    DataList * dl = dataList;
    DataList * dlnext;

    while (dl) {
      dlnext = dl->next;      
      if (first) {
	if (dl->removed) {	 
	  dataList = dlnext;
	  nData--;
	  pixelDiff -= (dl->d->trueCol != colour);
	  free(dl);
	  dl = dlnext;
	}
	else
	  first = 0;
      }
      else if (dlnext) {
	if (dlnext->removed) {
	  dl->next = dlnext->next;
	  nData--;
	  pixelDiff -= (dlnext->d->trueCol != colour);
	  free(dlnext);
	  dlnext = dl;//->next;
	}
	dl = dlnext;
      }
      else {
	dl = dlnext;
      }
    }
  }
};
#endif
