/*Include Files:*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <errno.h>
#include <assert.h>

#include "random.h"
#include "basic.h"
#include "point.h"
#include "vertex.h"
#include "simplex.h"
#include "edge.h"

Edge::Edge(Vertex * v1, Vertex *v2, int keyIn, int idIn, int boundaryIn)
{
  key = keyIn;
  id = idIn;
  v[0] = v1;
  v[1] = v2;
  nSimp = 0;
  boundary = boundaryIn;
}

Edge::~Edge()
{
  // Empty destructor..
}

void Edge::printAll()
{
  int i;

  printf("V: ");
  for (i=0; i<2;i++)
    v[i]->print();
  printf("\n");

  //  printf("neighV: ");
  //  for (int i=0; i<nNeighV;i++)
  //    neighV[i]->print();
  //  printf("\n");

  printf("nSimp: %d\n", nSimp);

  for (i=0; i<nSimp;i++)
    neigh[i]->print();

}

void Edge::print()
{
  printf("V: ");
  for (int i=0; i<2;i++)
    v[i]->print();
}

void Edge::print(VertexList * vList)
{
  printf("V: ");
  for (int i=0; i<2;i++)
    printf("%d ", vList->pos(v[i]));

  printf("\n");

}

void Edge::insert(Simplex * s)
{
  assert(nSimp<100);
  neigh[nSimp++] = s;
}

void Edge::remove(Simplex * s)
{
  int i;
  for (i=0;i<nSimp;i++) {
    if (neigh[i] == s)
      break;
  }
  if (i == nSimp) {
    printf("Error(Edge::remove): Simplex not found\n");
    s->print();
    assert(i < nSimp);
  }

  for (int j=i+1; j<nSimp;j++)
    neigh[j-1] = neigh[j];

  nSimp--;
  
}

#define  G_MULTIPLIER  69069 
#define  G_SHIFT           1 
#define  G_MODULUS  256*256*256*128 
#define  G_INVMOD  ( (double) 1 / ((double) G_MODULUS )) / ( (double) 2 ) 

int EdgeList::getIndex(int keyIndex)
{
   unsigned int index = (G_MULTIPLIER * keyIndex + G_SHIFT);
  index = (G_MULTIPLIER * index + G_SHIFT);

  index = (unsigned int) (index * G_INVMOD * nAlloc);

  return (int) index;
}


Edge * EdgeList::insert(Vertex * v1, Vertex * v2)
{
  int keyIndex = getKeyIndex(v1, v2);

  int index = getIndex(keyIndex);

  int subPos = 0;
  int subIndex = -1;
  while (subPos < maxSubPos[index]) {    
    if (!list[index][subPos] && (subIndex<0))
      subIndex = subPos;
    else if (list[index][subPos] && list[index][subPos]->key == keyIndex) {
      subIndex = subPos;
      break;
    }
    subPos++;
  }

  if ((subIndex<0) && (subPos >= maxSubPos[index])) {
    int n = maxSubPos[index];
    maxSubPos[index] += nMaxDelta;
    list[index] = (Edge **) realloc(list[index], maxSubPos[index]*sizeof(Edge *));
    for (int j=n;j<maxSubPos[index];j++)
      list[index][j] = NULL;

    subIndex = n;
  }

  assert((subIndex>=0) && (subIndex < maxSubPos[index]));

  if (!list[index][subIndex]) {
    int boundary = 0;
    if (vList->pos(v1) < FIRSTVERTICES && vList->pos(v2)<FIRSTVERTICES)
      boundary = 1;
    list[index][subIndex] = new Edge(v1, v2, keyIndex, id, boundary);
    id++;
    nEdges++;
  }

  return list[index][subIndex];
}

void EdgeList::remove(Edge * e)
{
  nEdges--;

  int keyIndex = e->key;

  int index = getIndex(keyIndex);

  int subPos = 0;
  while (subPos < maxSubPos[index]) {    
    if (list[index][subPos] && list[index][subPos]->key == keyIndex)
      break;
    subPos++;
  }
  assert(subPos < maxSubPos[index]);

  assert(list[index][subPos]);

  assert(list[index][subPos]->nSimp == 0);
  
  delete list[index][subPos];
  list[index][subPos] = NULL;
}

EdgeList::EdgeList(const VertexList * vL, int nMeanVertices)
{
  nEdges = 0;
  id = 0;

  vList = vL;

  nMaxVertices = 10 * nMeanVertices;
  nMaxEdges = 30 * nMaxVertices;
  
  keyFactor = nMaxEdges/(nMaxVertices*nMaxVertices);

  nAlloc = nMaxEdges;

  list = (Edge ***) malloc(nAlloc*sizeof(Edge **));
  maxSubPos = (int *) malloc(nAlloc*sizeof(int));

  nMaxDelta = 3;

  for (int i=0;i<nMaxEdges;i++) {
    maxSubPos[i] = nMaxDelta;
    list[i] = (Edge **) malloc(maxSubPos[i]*sizeof(Edge *));
    for (int j=0;j<maxSubPos[i];j++)
      list[i][j] = NULL;
  }

}

EdgeList::~EdgeList()
{
  for (int i=0;i<nMaxEdges;i++) {
    for (int j=0;j<maxSubPos[i];j++) {
      if (list[i][j]) {	
	delete list[i][j];
      }
    }

    free(list[i]);
  }
  free(list);
  
  free(maxSubPos);
}


void EdgeList::checkConsistency(short * nSimpInEdges)
{
  for (int i=0;i<nMaxEdges;i++) {
    for (int j=0;j<maxSubPos[i];j++) {
      Edge * e = list[i][j];
      if (e) {
	assert(nSimpInEdges[e->key] == e->nSimp);
      }
    }
  }
}
