#ifndef EDGE__
#define EDGE__ 1

#define FIRSTVERTICES 4
class Simplex;

class Edge
{
  friend class Delaunay;
  friend class EdgeList;
private:
  int id;

  int key;
  int boundary;

  int nSimp;
  Simplex * neigh[100]; // NBNB May have to change this limit

  Vertex * v[2];

public:
  Edge(Vertex * v1, Vertex *v2, int keyIn, int idIn, int boundaryIn);
  ~Edge();

  void insert(Simplex *s);
  void remove(Simplex *s);

  void print();
  void print(VertexList * vList);
  void printAll();
};


class EdgeList
{
public:
  EdgeList(const VertexList * vList, int nMeanVertices);
  ~EdgeList();

  Edge * insert(Vertex * v1, Vertex * v2);
  void remove(Edge * e);

  int getIndex(int keyIndex);
  int getKeyIndex(Edge * e);
  int getKeyIndex(Vertex * v1, Vertex * v2);

  int getNAlloc();
  int getNMaxVertices();

  int getNumberOfEdges();
  int getId();

  void insertSimp(Simplex * s);
  void removeSimp(Simplex * s);

  void checkConsistency(short * nSimpInEdges);

private:
  Edge *** list;
  int * maxSubPos;
  int EdgeSize;
  int nAlloc;
  int nEdges;

  int nMaxDelta;

  int id;

  const VertexList * vList;
  double keyFactor;
  int nMaxEdges;
  int nMaxVertices;
};

inline int EdgeList::getNAlloc()
{
  return nAlloc;
}

inline int EdgeList::getNMaxVertices()
{
  return nMaxVertices;
}

inline int EdgeList::getId()
{
  return id;
}

inline int EdgeList::getNumberOfEdges()
{
  return nEdges;
}

inline int EdgeList::getKeyIndex(Edge * e)
{
  return getKeyIndex(e->v[0], e->v[1]);
}

inline int EdgeList::getKeyIndex(Vertex * v1, Vertex * v2)
{
  int pos1 = vList->pos(v1);
  int pos2 = vList->pos(v2);

  if (pos1>pos2) {
    int tmp = pos2;
    pos2 = pos1;
    pos1 = tmp;
  }

  int keyIndex = pos1 * nMaxVertices + pos2;

  return keyIndex;
}


#endif
