/*Include Files:*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <errno.h>
#include <assert.h>

#include "model_scan.h"
#include "basic.h"
#include "input.h"

#define NCOMMANDS 28
#define FILES 0
#define NCOLOUR 1
#define THETA 2
#define BETA 3
#define NITER 4
#define ACTIONPROBS 5
#define DEBUGPRINT 6
#define DEBUGCHECK 7
#define LOGINTERVAL 8
#define LOGBINAER 9
#define WELLS 10
#define WELLPATH 11
#define REGION 12
#define ZANISOTROPY 13
#define LIKELIHOOD 14
#define ALGPARAMETERS 15
#define BURNIN 16
#define MARGINALGRID 17
#define STARTFROMPRIOR 18
#define PRINTTESSINTERVAL 19
#define RESTART 20
#define SEED 21

#define VOLUMEGRID 22
#define VOLUMEFRACTION 23
#define VOLUMETOLERANCE 24

#define TRUEIMAGE 25
#define IMAGEDATA 26

#define INITIALISE 27


#define ADD 0
#define REMOVE 1
#define MOVE 2

void readInput(char * modelFileName, Input * input) {
  int i, iComm, j;
  int imageRead=0;
  int trueImageRead=0;
  int nBetaDelta;
  double sum;
  char ** endPtr = new char *;
  char **commands;
  struct COMMAND *sComm, *sCommands;
   
  commands = (char **) calloc(NCOMMANDS, sizeof(char *));
  for (i=0;i<NCOMMANDS;i++)
    commands[i] =  (char *) calloc(50, sizeof(char));
  strcpy(commands[NITER], "NITER");
  strcpy(commands[FILES], "FILES");
  strcpy(commands[SEED], "SEED");
  strcpy(commands[BETA], "BETA");
  strcpy(commands[THETA], "THETA");
  strcpy(commands[ALGPARAMETERS], "ALGPARAMETERS");
  strcpy(commands[NCOLOUR], "NCOLOUR");
  strcpy(commands[ACTIONPROBS], "ACTIONPROBS");
  strcpy(commands[DEBUGPRINT], "DEBUGPRINT");
  strcpy(commands[DEBUGCHECK], "DEBUGCHECK");
  strcpy(commands[LOGINTERVAL], "LOGINTERVAL");
  strcpy(commands[LOGBINAER], "LOGBINAER");
  strcpy(commands[WELLS], "WELLS");
  strcpy(commands[WELLPATH], "WELLPATH");
  strcpy(commands[REGION], "REGION");
  strcpy(commands[ZANISOTROPY], "Z-ANISOTROPY");
  strcpy(commands[LIKELIHOOD], "LIKELIHOOD");
  strcpy(commands[BURNIN], "BURNIN");
  strcpy(commands[MARGINALGRID], "MARGINALGRID");
  strcpy(commands[STARTFROMPRIOR], "STARTFROMPRIOR");
  strcpy(commands[PRINTTESSINTERVAL], "PRINTTESSINTERVAL");
  strcpy(commands[RESTART], "RESTART");
  strcpy(commands[VOLUMEGRID], "VOLUMEGRID");
  strcpy(commands[VOLUMEFRACTION], "VOLUMEFRACTION");
  strcpy(commands[VOLUMETOLERANCE], "VOLUMETOLERANCE");
  strcpy(commands[TRUEIMAGE], "TRUEIMAGE");
  strcpy(commands[IMAGEDATA], "IMAGEDATA");
  strcpy(commands[INITIALISE], "INITIALISE");
   
  sCommands = spReadModelFile(modelFileName, commands, NCOMMANDS);
   
  for (iComm=0;iComm<NCOMMANDS;iComm++) {
    sComm = &sCommands[iComm];

    switch (iComm) {
    case FILES:
      if (!sComm->bRead) {
        printf("Command FILES not specified\n");
	exit(-1);
      }
      if (sComm->nArgs != 1) {
        printf("Number of arguments for the FILES command != 1\n");
	exit(-1);
      }
      input->fileName = (char *) calloc(strlen(sComm->cppArgs[0])+1, sizeof(char));
      strcpy(input->fileName, sComm->cppArgs[0]);
       
      break;
    case SEED:
      if (!sComm->bRead) {
        printf("Command SEED not specified\n");
	exit(-1);
      }
      if (sComm->nArgs != 1) {
        printf("Number of arguments for the SEED command != 2\n");
 	exit(-1);
      }
      input->seed = new unsigned int;
      *(input->seed) = strtoul(sComm->cppArgs[0], endPtr, 10);
      if (strcmp(sComm->cppArgs[0], *endPtr) != 0) {
	input->seedFileName = NULL;
      }
      else {
	input->seedFileName = (char *) calloc(strlen(sComm->cppArgs[0])+1, sizeof(char));
	strcpy(input->seedFileName, sComm->cppArgs[0]);
      }
      break;
    case BETA:
      if (!sComm->bRead) {
        printf("Command BETA not specified\n");
	exit(-1);
      }      
      if (sComm->nArgs != 1 && sComm->nArgs != input->nColour+1) { 
	printf("Number of arguments for the BETA command != 1 or nColour\n");
	exit(-1);
      }
      
      nBetaDelta = sComm->nArgs - 1;
      input->beta = atof(sComm->cppArgs[0]);
      
      if (nBetaDelta > 0) {
	input->betaDelta = new double[nBetaDelta];
	for (i=0;i<nBetaDelta;i++)
	  input->betaDelta[i] = atof(sComm->cppArgs[i+1]);
      }
      else {
	input->betaDelta = NULL;
      }

      break;

    case THETA:
      if (!sComm->bRead) {
        printf("Command THETA not specified\n");
	exit(-1);
      }      
      if (sComm->nArgs != 1) { 
	printf("Number of arguments for the THETA command != 1\n");
	exit(-1);
      }
      input->nTheta = 1;
      input->theta = (double *) malloc(input->nTheta*sizeof(double));
      for (i=0;i<input->nTheta;i++)
	input->theta[i] = atof(sComm->cppArgs[i]);

      break;

    case ALGPARAMETERS:
      if (!sComm->bRead) {
	printf("Command ALGPARAMETERS not specified\n");
	exit(-1);
      }      
      if (sComm->nArgs != 1) {
	printf("Number of arguments for the ALGPARAMETERS command != 1\n");
	exit(-1);
      }
      input->sigmaMove = atof(sComm->cppArgs[0]);

      break;
     case ACTIONPROBS:
      if (!sComm->bRead) {
        printf("Command ACTIONPROBS not specified\n");
	exit(-1);
      }
      if (sComm->nArgs != 3) {
	printf("Number of arguments for the ACTIONPROBS command != 3\n");
	exit(-1);
      }
      sum = input->probs[ADD] = atof(sComm->cppArgs[0]);
      sum += input->probs[MOVE] = atof(sComm->cppArgs[1]);
      sum += input->probs[REMOVE] = atof(sComm->cppArgs[2]);
      if (fabs(sum-1.0)>0.00000000001) {
	printf("Error: Probabilities do not sum to one.\n");
	exit(-1);
      }
      break;
     case VOLUMEGRID:
      if (sComm->bRead) {
	if (sComm->nArgs != DIM) {
	  printf("Number of arguments for the VOLUMEGRID command != %d\n",
		 DIM);
	  exit(-1);
	}
	for (i=0;i<DIM;i++) {
	  input->volDim[i] = atoi(sComm->cppArgs[i]);
	}
      }
      else {
	for (i=0;i<DIM;i++) {
	  input->volDim[i] = 0;
	}
      }
      break;
     case VOLUMEFRACTION:
      if (sComm->bRead) {
	if (sComm->nArgs != input->nColour) {
	  printf("Number of arguments for the VOLUMEFRACTION command != # colours\n");
	  exit(-1);
	}
	input->volFraction = new double[input->nColour];
	sum = 0.0;
	for (i=0;i<input->nColour;i++) {
	  input->volFraction[i] = atof(sComm->cppArgs[i]);
	  sum += input->volFraction[i];
	}
	if (fabs(sum-1.0)>0.00000000001) {
	  printf("Error: Volume fractions do not sum to one.\n");
	  exit(-1);
	}
      }
      break;
     case VOLUMETOLERANCE:
      if (sComm->bRead) {
	if (sComm->nArgs != input->nColour) {
	  printf("Number of arguments for the VOLUMETOLERANCE command != # colours\n");
	  exit(-1);
	}
	input->volFractionTolerance = new double[input->nColour];
	for (i=0;i<input->nColour;i++) {
	  input->volFractionTolerance[i] =
	    atof(sComm->cppArgs[i]);
	  if (input->volFractionTolerance[i] < 0.0) {
	    printf("Error: Volume fraction tolerance < 0.\n");
	    exit(-1);
	  }
	}
      }
      break;
    case NITER:
      if (!sComm->bRead) {
        printf("Command NITER not specified\n");
	exit(-1);
      }
      if (sComm->nArgs != 1) {
	printf("Number of arguments for the NITER command != 1\n");
	exit(-1);
      }
      input->nIter = atoi(sComm->cppArgs[0]);
      break;

    case LOGBINAER:
      if (!sComm->bRead) {
        input->logBinaer = 0;
      }
      else
        input->logBinaer = 1;

      if (sComm->nArgs != 0) {
	printf("Number of arguments for the LOGBINAER command != 0\n");
	exit(-1);
      }
      break;


    case DEBUGPRINT:
      if (!sComm->bRead) {
	input->debugPrint = 0;
      }
      else {
	if (sComm->nArgs != 1) {
	  printf("Number of arguments for the DEBUGPRINT command != 1\n");
	  exit(-1);
	}
	input->debugPrint = atoi(sComm->cppArgs[0]);
      }
      break;


    case DEBUGCHECK:
      if (!sComm->bRead) {
	input->debugCheck = 0;
      }
      else {
	if (sComm->nArgs != 1) {
	  printf("Number of arguments for the DEBUGCHECK command != 1\n");
	  exit(-1);
	}
	input->debugCheck = atoi(sComm->cppArgs[0]);
      }
      break;

    case NCOLOUR:
      if (!sComm->bRead) {
        printf("Command NCOLOUR not specified\n");
	exit(-1);
      }
      if (sComm->nArgs != 1) {
	printf("Number of arguments for the NCOLOUR command != 1\n");
	exit(-1);
      }
      input->nColour = atoi(sComm->cppArgs[0]);
      break;

    case LOGINTERVAL:
      if (!sComm->bRead) {
        input->logInterval = 0;
      }
      else if (sComm->nArgs != 1) {
	printf("Number of arguments for the NCOLOUR command != 1\n");
	exit(-1);
      }
      else
	input->logInterval = atoi(sComm->cppArgs[0]);

      break;

    case WELLS:
      if (sComm->bRead) {
	if (sComm->nArgs < 1) {
	  printf("Number of arguments for the WELLS command >= 1\n");
	  exit(-1);
	}
	input->nWell = sComm->nArgs;
	
	input->wellNames = new char *[input->nWell];
	for (i=0;i<input->nWell;i++) {
	  input->wellNames[i] = new char[strlen(sComm->cppArgs[i])+1];
	  strcpy(input->wellNames[i], sComm->cppArgs[i]);
	}
      }
      else {
	input->wellNames = NULL;
	input->nWell = 0;
      }
      break;
    case WELLPATH:
      if (sComm->bRead) {
	if (sComm->nArgs != 1) {
	  printf("Number of arguments for the WELLPATH command != 1\n");
	  exit(-1);
	}
	input->wellPath = new char[strlen(sComm->cppArgs[0])+1];
	strcpy(input->wellPath, sComm->cppArgs[0]);
      }
      else {
	input->wellPath = NULL;
      }
      break;
    case REGION:
      if (sComm->bRead) {
	if (sComm->nArgs != 2*DIM) {
	  printf("Number of arguments for the REGION command != %d\n", 2*DIM);
	  exit(-1);
	}
	for (i=0;i<2*DIM;i++)
	  input->region[i] = atof(sComm->cppArgs[i]);
      }
      else {
	for (i=0;i<DIM;i++) {
	  input->region[2*i] = 0;
	  input->region[2*i+1] = 1;
	}
      }
      break;
    case ZANISOTROPY:
      if (sComm->bRead) {
	if (DIM == 2) {
	  printf("Command Z-ANISOTROPY only used for dimension 3\n");
	  exit(-1);
	}
	else if (sComm->nArgs != 1) {
	  printf("Number of arguments for the Z-ANISOTROPY command != 1\n");
	  exit(-1);
	}
	input->zAnisotropy = atof(sComm->cppArgs[0]);
      }
      else {
	input->zAnisotropy = 1.0;
      }
      break;
    case LIKELIHOOD:
      if (sComm->bRead) {
	if (sComm->nArgs != 2) {
	  printf("Number of arguments for the LIKELIHOOD command != 2\n");
	  exit(-1);
	}
	input->mu[0] = atof(sComm->cppArgs[0]);
	input->mu[1] = atof(sComm->cppArgs[1]);
      }
      else {
	input->mu[0] = 0.0;
	input->mu[1] = 0.0;
      }
      break;
    case BURNIN:
      if (sComm->bRead) {
	if (sComm->nArgs != 1) {
	  printf("Number of arguments for the BURNIN command != 1\n");
	  exit(-1);
	}
	input->burnIn = atoi(sComm->cppArgs[0]);
      }
      else {
	input->burnIn = 0;
      }
      break;
    case MARGINALGRID:
      if (sComm->bRead) {
	if (sComm->nArgs != DIM) {
	  printf("Number of arguments for the MARGINALGRID command != %dn",
		 DIM);
	  exit(-1);
	}
	for (i=0;i<DIM;i++)
	  input->margGridDim[i] = atoi(sComm->cppArgs[i]);

	input->estimateMarginalPosterior = 1;
      }
      else {
	input->estimateMarginalPosterior = 0;
      }
      break;
    case STARTFROMPRIOR:
      if (sComm->bRead) {
	if (sComm->nArgs != 1) {
	  printf("Number of arguments for the STARTFROMPRIOR command != 1n");
	  exit(-1);
	}
	input->startFromPrior = atoi(sComm->cppArgs[0]);
      }
      else {
	input->startFromPrior = 0;
      }
      break;
    case IMAGEDATA:
      if (!sComm->bRead) {
	for (i=0;i<DIM;i++)
	  input->imageDim[i] = 0;
	input->imageFileName = NULL;
	input->imageSigma = 0.0;
	imageRead = 0;
      }
      else {
	imageRead = 1;
	if (sComm->nArgs != DIM+2) {
	  printf("Number of arguments for the IMAGEDATA command != %d\n",
		 DIM+2);
	  exit(-1);
	}
	for (i=0;i<DIM;i++)
	  input->imageDim[i] = atoi(sComm->cppArgs[i]);
	input->imageFileName = new char[strlen(sComm->cppArgs[DIM])+1];
	strcpy(input->imageFileName, sComm->cppArgs[DIM]);
	input->imageSigma = atof(sComm->cppArgs[DIM+1]);
      }
      break;

    case TRUEIMAGE:
      if (!sComm->bRead) {
	trueImageRead = 0;
	input->trueImageFileName = NULL;
      }
      else {
	trueImageRead = 1;
	if (sComm->nArgs != 3) {
	  printf("Number of arguments for the TRUEIMAGE command != 3\n");
	  exit(-1);
	}
	input->trueImageFileName = new char[strlen(sComm->cppArgs[2])+1];
	strcpy(input->trueImageFileName, sComm->cppArgs[2]);
      }
      break;

    case INITIALISE:
      if (!sComm->bRead) {
	input->init = 0;
      }
      else {
	input->init = 1;
	if (sComm->nArgs != 2) {
	  printf("Number of arguments for the INITIALISE command != 2\n");
	  exit(-1);
	}
       input->initNPoints = atoi(sComm->cppArgs[0]);
       if (strcmp(sComm->cppArgs[1], "random") == 0)
	 input->initRandom = 1;
       else
	 input->initRandom = 0;
      }
      break;

    case PRINTTESSINTERVAL:
      if (!sComm->bRead) {
        input->printTessInterval = input->nIter;
      }
      else if (sComm->nArgs != 1) {
	printf("Number of arguments for the PRINTTESSINTERVAL command != 1\n");
	exit(-1);
      }
      else {
	input->printTessInterval = atoi(sComm->cppArgs[0]);
	if (input->printTessInterval <= 1) {
	  printf("The print tessellation interval (%d) should be positive\n", input->printTessInterval);
	  exit(-1);
	}
      }
      break;

    case RESTART:
      if (!sComm->bRead) {
	input->restartFileName = NULL;
      }
      else {
	if (sComm->nArgs != 1) {
	  printf("Number of arguments for the RESTART command != 1\n");
	  exit(-1);
	}
	input->restartFileName = (char *) calloc(strlen(sComm->cppArgs[0])+1, sizeof(char));
	strcpy(input->restartFileName, sComm->cppArgs[0]);
      }
      break;

    }
  }

  if (sCommands[WELLS].bRead !=	sCommands[LIKELIHOOD].bRead) {
    printf("Either both or none of the commands WELLS and ");
    printf("LIKELIHOOD must be specified\n");
    exit(-1);
  }

  if (!(sCommands[VOLUMEGRID].bRead == sCommands[VOLUMEFRACTION].bRead) ||
      !(sCommands[VOLUMETOLERANCE].bRead == sCommands[VOLUMEFRACTION].bRead)) {
    printf("Either all or none of the commands VOLUMEGRID, ");
    printf("VOLUMEFRACTION and VOLUMETOLERANCE must be specified\n");
    exit(-1);
  }

  if (input->nIter <= input->burnIn) {
    printf("Error(readInput): nIter %d <= burnIn %d\n",
	   input->nIter, input->burnIn);
    exit(-1);
  }
  
  if (trueImageRead != imageRead) {
    printf("Both true image and data image should be read!\n");
    exit(-1);
  }

  for (i=0;i<NCOMMANDS;i++)
    free(commands[i]);
  free(commands);

  

  for (iComm=0;iComm<NCOMMANDS;iComm++) {
    for (j=0;j<sCommands[iComm].nArgs;j++)
      free(sCommands[iComm].cppArgs[j]);
    free(sCommands[iComm].cppArgs);
  }
	
  free(sCommands);

  delete endPtr;

  return;
}
