#ifndef INPUT_H
#define INPUT_H 1

struct Input {
  int logInterval;
  short logBinaer;
  short estimateMarginalPosterior;

  short debugPrint;
  short debugCheck;
  int nTheta;
  char * fileName;
  char * seedFileName;
  char * imageFileName;
  char * trueImageFileName;
  int imageDim[DIM];
  double imageSigma;

  short nColour;
  int nIter;
  unsigned int * seed;
  double beta;
  double * betaDelta;
  double * theta;

  double sigmaMove;

  short init;
  int initNPoints;
  short initRandom;

  int burnIn;
  int margGridDim[DIM];

  int startFromPrior;

  int printTessInterval;
  
  char * restartFileName;
  
  double probs[3];

  int nWell;
  char ** wellNames;
  char * path;
  char * wellPath;

  double region[2*DIM];

  double zAnisotropy;

  double mu[2];

  int volDim[DIM];
  double * volFraction;
  double * volFractionTolerance;

  Input() {
    fileName = NULL;
    seedFileName = NULL;
    seed = NULL;
    theta = NULL;
    volFraction = NULL;
    volFractionTolerance = NULL;
  }

  ~Input(){
    if (fileName)
      free(fileName);
    if (seedFileName)
      free(seedFileName);
    if (restartFileName)
      free(restartFileName);
    if (imageFileName)
      delete [] imageFileName;
    if (trueImageFileName)
      delete [] trueImageFileName;

    if (seed)
      delete seed;
    if (theta)
      free(theta);
    if (path)
      delete [] path;
    if (wellPath)
      delete [] wellPath;
    for (int i=0;i<nWell;i++) {
      delete [] wellNames[i];
    }
    delete [] wellNames;
    if (volFraction)
      delete [] volFraction;
    if (volFractionTolerance)
      delete [] volFractionTolerance;
  }
};

void readInput(char * modelFileName, Input * input);


#endif
