/*Include Files:*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <errno.h>
#include <assert.h>

#include "basic.h"
#include "input.h"
#include "random.h"
#include "point.h"
#include "vertex.h"
#include "edge.h"
#include "simplex.h"
#include "delaunay.h"
#include "model.h"
#include "simulation.h"


FILE * DFILE = stderr;
int main(int argc, char **argv)
{
  char * modelFileName;

  Input * input = new Input;
  Model * model;
  //  Simulation * sim;
  if (argc<=1 || argc >=4) {
    printf("Usage: %s <model-file> [<path>]\n", argv[0]);
    exit(-1);
  }
  
  if (argc == 3) {
    input->path = new char[strlen(argv[2])+1];
    strcpy(input->path, argv[2]);

    modelFileName = new char[strlen(input->path) + strlen(argv[1]) + 2];
    strcpy(modelFileName, input->path);
    strcat(modelFileName, "/");
    strcat(modelFileName, argv[1]);
  }
  else {
    input->path = new char[2];
    input->path[0] = '\0';
    modelFileName = new char[strlen(argv[1]) + 1];
    strcpy(modelFileName, argv[1]);
  }
  
  readInput(modelFileName, input);

  delete [] modelFileName;

  model = new Model(input);

  Simulation * sim = new Simulation(model, input);

  sim->simulation();

  delete model;
  delete sim;
  delete input;
}
