/*Include Files:*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <errno.h>
#include <assert.h>

#include "basic.h"
#include "input.h"
#include "model.h"

Model::Model(Input * input) {
  int i;
  
  beta = input->beta;
  nColour = input->nColour;

  if (input->betaDelta) {
    betaDelta = new double[nColour];
    for (i=0;i<nColour;i++)
      betaDelta[i] = input->betaDelta[i];
  }

  nTheta = input->nTheta;
  theta = new double[nTheta];
  for (i=0;i<nTheta;i++)
    theta[i] = input->theta[i];

  if (input->mu[0] > 0) {
    mu = new double[2];
    logMu = new double[2];
    for (i=0;i<2;i++) {
      mu[i] = input->mu[i];
      logMu[i] = log(input->mu[i]);
    }
  }
  else {
    mu = NULL;
    logMu = NULL;
  }
  imageSigma = input->imageSigma;
}

Model::~Model() {
  delete [] theta;
  if (mu) {
    delete [] mu;
    delete [] logMu;
  }
}
