#ifndef MODEL__
#define MODEL__ 1

struct Input;

class Model {
private:
  int nColour;
  int nTheta;
  double beta;
  double * betaDelta;
  double * theta;

  double * mu;
  double * logMu;
  double imageSigma;

public:
  Model(Input * input);
  ~Model();

  void setBeta(double b) {beta = b;};
  
  int NColour() const {return nColour;};
  int NTheta() const {return nTheta;};
  double Beta() const {return beta;};
  const double * BetaDelta() const {return betaDelta;};
  double Theta() const {return theta[0];};
  const double * Mu() const {return mu;};
  const double * LogMu() const {return logMu;};
  double ImageSigma() const {return imageSigma;};
};

#endif
