#ifndef POINT__
#define POINT__ 1

typedef double* Point;

struct mPoint {
  Point pt;
  short colour;
};

inline double normPoint(Point p)
{
  double norm = 0.0;

  for (int i=0;i<DIM;i++)
  {
    norm += p[i]*p[i];
  }

  return norm;
}

inline double distPoint(Point p1, Point p2)
{
  double dist = 0.0;

  for (int i=DIM;i;i--)
  {
    double h = *(p1++) - *(p2++);
    dist += h*h;
  }

  return dist;
}

inline double vecProd(Point p1, Point p2)
{
  double prod=0.0;
 
 for (int i=0;i<DIM;i++) {
   prod += p1[i]*p2[i];
 }

 return prod;
}


#endif
