#ifndef _RANDOM
#define _RANDOM
class RandomSeed
{
public:
  RandomSeed(void);
  ~RandomSeed(void); 

  void setSeed(unsigned  int iseed);
  int setSeed(const char * seedfile);

  unsigned  int getSeed(void) const; 
 
protected:
  static unsigned int seed;
private:
  char errorMsg[1024];
};

class RandomGenerator : public RandomSeed 
{
public:
  RandomGenerator(char *filename);  
  RandomGenerator(unsigned  int iseed);
  ~RandomGenerator() {}
  void normal01(double &, double &);
  double unif01(void);
  double unif(double min,double max);       
  double normal(double expectation, double stdev){
    double x1,x2;
    normal01(x1,x2);
    return (expectation + x1*stdev);
  }
  int iUnif(int min,int max);            

};

#endif
