#ifndef SAMPLEGRID__H
#define SAMPLEGRID__H 1

class SampleGrid
{
public:
  SampleGrid(char * modelFileName);
  ~SampleGrid();
  
  void sample();
  void read();
  void write();

  void transformWellCoord();

private:
  char * inputFileName;
  char * gridFileName;

  int nVertexPts;
  int nMaxId;
  int * vertexIdInv;
  Point * vertexPts;
  short * colour;
  short * nNeigh;
  int ** neigh;

  int gridDim[DIM];  
  short * grid;

  int sampleXYZ[DIM];
  double ptFixed[DIM];

  int objects;

  double zAnisotropy;
  double region[2*DIM];
  double regionOrig[2*DIM];

  int nWells;
  char ** wellName;
  double ** wellPt;

  void findNearestVertex(Point pt, int & vIndex);
  void findNearestVertexSlow(Point pt, int & vIndex);

  void readInput(char * modelFileName);
  void sampleAlongWells();
  void sampleNormal();
};
#endif
