#ifndef SIMULATION__
#define SIMULATION__ 1

struct Input;
class Vertex;
class Delaunay;
class Model;
class Wells;

class Simulation {
public:

  Simulation(Model * mod, Input * input);
  ~Simulation();

  void simulation();

protected:
  Delaunay * delaunay;
  RandomGenerator * random;
  Model * model;
  char * path;
  char * fileName;

  int nIter;
  int action;

  short init;
  short initRandom;
  int initNPoints;

  int burnIn;

  int startFromPrior;

  mPoint * startPoints;
  mPoint * newMPt;

  int pointSize;

  int accept;
  int noMove; // Is 0 if point is moved outside volume region
  int errorInDelaunay;

  double * betaDeltaCum;

  double region[2*DIM];
  double regionOrig[2*DIM];
  double volRegion;

  double zAnisotropy;

  double sigmaMove;

  double prob[3]; // Probabilities for suggesting different moves

  double movePot;
  double potWell;
  double potImage;
  double potVol;
  
  int imageData;

  int wellData;
  Wells * wells;

  int simulateFromPosterior;

  int estimateMarginalPosterior;

  int printTessInterval;

  // ******* Volume fractions obtained by annealing
  int volumeAnnealing;
  double * volFraction;
  double * volFractionTolerance;
  double Tstart;
  double Trate;

  // ******* Log variables
  char * restartFileName;
  char * simFileName;
  FILE * logFile;
  FILE * simFile;
  FILE * resFile;
  FILE * margFile;
  short logBinaer;
  int logInterval;
  int logIntervalIter;
  int debugPrint;
  int debugCheck;

  int pixelDiff;
  int sumPixelDiff;

  int colDiff;
  int sumColDiff;  

  // **************** Protected functions

  double sumAlpha;

  void initMH();

  unsigned int getSeed() { return random->getSeed();}
  void setSeed(unsigned int seed) {random->setSeed(seed); return;}
  void multUpRegion(double mult);


  void addProposal();
  void removeProposal();
  void moveProposal();

  void updateColDiff(Vertex * v);
  void updateLogInfo(int it);

  void drawAction();
  void drawPoint();

  void movePoint(Vertex * v);
  Point selectPoint();

  int acceptance(double pot);

  double acceptPotential(int it);
  double potentialFromPrior();
  double potentialFromVolFraction(int it);
  double potentialFromLikelihood();
  double potentialFromImageData();
  double potentialFromWellData();
  double updateFirstOrder();

  int inside(Point pt);

  void restart(int & startIt);

  // ****** Log functions
  void printTessellation(int it);
  void printIteration(int it);
  void printSimInfo(int it);
  void printAction();
  void printRes();
};


inline int Simulation::inside(Point pt)
{
  int i;
  int outside = 0;
  
  for (i=0;i<DIM;i++) {
    if (pt[i] < region[2*i] || pt[i] > region[2*i+1]) {
      outside = 1;
      break;
    }
  }

  return !outside;
}

inline void Simulation::printAction()
{

  if (debugPrint >= 2) {
    if (action == ADD)
      printf("Action: ADD\n");
    else if (action == REMOVE)
      printf("Action: REMOVE\n");
    else
      printf("Action: MOVE\n");
  }

}

inline void Simulation::printIteration(int it)
{
  if (debugPrint >= 1)
    printf("Iteration %d\n", it);
  else if (debugPrint == 0)
    if (((it % logIntervalIter ) == 0) && it>0)
      printf("Iteration %d\n", it);
  fflush(stdout);
}

#endif
