/*
vorSim3D: C++-routines for simulation from a coloured Voronoi
tessellation model.

Version 1.0

Copyright (C)  2001 ivind Skare

  This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU
  General Public License as published by the Free Software Foundation; either ve
rsion 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT AN
Y WARRANTY; without
  even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPO
SE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along with t
his program; if not,
  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Bost
on, MA 02111-1307,
  USA.


  The author's contact information:

 ivind Skare                Office tel.: (+47) 22 85 26 56
 Norwegian Computing Center         Fax:         (+47) 22 69 76 60 
 P.O.Box 114 Blindern               E-mail:      Oivind.Skare@nr.no 
 NO-0314 Oslo, Norway
*/
#ifndef WELLS
#define WELLS_ 1

#define INSERT 0
#define REMOVE 1

struct Surface {
  int nx;
  int ny;
  double dx;
  double dy;
  double xMin;
  double xMax;
  double yMin;
  double yMax;

  float * grid;
};

struct Input;

class Wells {
public:
  Wells(Input * input, double regionOrig[]);
  ~Wells();

  void getAllSegments(int ** segment, int & nSeg);
  void initialiseSegments(Vertex * v);
  double segmentLength(int I, int J, int K);
  void changeSegment(int segment[], Vertex * from, Vertex * to);
  void updateSegment(int segment[], Vertex * vOld,
		     Vertex ** neigh, int nNeigh);
  void intersect(Vertex * vNew, Vertex * vOld, int segment[]);

  int findIndex(int segment[], Vertex * v);
  void getStatistics(int & n0, int & n1, double & l0);
  double getZAnisotropy();
  double getTotalWellLength();

  Vertex * prevVertexInSegment(Vertex * v, int segment[]);
  Vertex * nextVertexInSegment(Vertex * v, int segment[]);

  void checkConsistency(VertexList * vList);

  void printLogInfo(FILE * file);

  void writeTransformedWells();

private:
  int nWell;
  //  int * nWellSegment;
  int * nSegmentInWell;
  int ** nSegment;
  Point *** wellSegment;
  int ** facies;

  //  int ** nVertInWellSegment;
  Vertex **** vertInSegment;

  int zoneNumber;
  double topZone;
  double bottomZone;

  char ** wellNames;
  char * path;

  Surface * topSurf;
  Surface * botSurf;

  double zRegion; // Original zRegion times zAnisotropy
  double zAnisotropy;

  int totalNumberOfSegments;

  double ** wellLength;
  double totalWellLength;

  int startIndex;
  int endIndex;
  int updateFlag;

  int nAlloc;

  int N0; // # {j: D_j^k = 0,J_j^k = 1} D_j^k = 0 : colours disagree
  int N1; // # {j: D_j^k = 1,J_j^k = 1} D_j^k = 0 : colours agree
  double L0; // total length of disagreements

  int nFacies;

  void readWells(char ** names, double regionOrig[]);
  void readWell(int index);
  void findNumberOfSegments(FILE * ff, int nRecords, int & nLines);
  void transformWells(double regionOrig[]);

  void findMidPoint(int segment[], Vertex * v1, Vertex * v2,
		    double & t, int & increasing, int & outside,
		    int & nearest);
  void splitSegment(int segment[], double t, Vertex * v1, Vertex * v2);
  void mergeSegment(Vertex * vNew, int I, int J, int K);
  void merge(Vertex * vNew, int segment[]);
  void finalMerge(int segment[], int N);

  Point getPt(int segment[], double t);
  Point getSegment(int I, int J, int K);
  int sameColour(Vertex * v, int I, int J);

  void printSegments();
};

inline void Wells::getStatistics(int & n0, int & n1, double & l0)
{
  n0 = N0;
  n1 = N1;
  l0 = L0;
}

inline double Wells::getZAnisotropy() {
  return zAnisotropy;
}
 
inline double Wells::getTotalWellLength()
{
  return totalWellLength;
}

#endif
