function pig2pork_winbugs_results(filepath)
% pig2pork_winbugs_results(filepath)
% To collect WinBUGS output and to draw figures.
% filepath: 'C:\write_your_path_here\out\'
% You need to have the following files to run this:
% bugs2mat.m /loads WinBUGS coda files into matlab.
% credint.m  /computes x% credible intervels from a MCMC sample.
% histog.m   /draws a histogram from a MCMC sample. 

% indexing of the farm types:
     risk=[1,0,1,1,0,0,1,0,1,0,1,0,0,1,0];
  organic=[1,0,0,1,0,0,1,0,0,1,0,0,1,0,0];
    small=[0,1,0,0,1,0,0,1,0,0,1,0,0,1,0];
    large=[0,0,1,0,0,1,0,0,1,0,0,1,0,0,1];
    
a=bugs2mat('aIndex.txt','a1.txt',filepath);
b=bugs2mat('bIndex.txt','b1.txt',filepath);
f1=bugs2mat('f1Index.txt','f11.txt',filepath);
f2=bugs2mat('f2Index.txt','f21.txt',filepath);
pfaecal=bugs2mat('pfaecalIndex.txt','pfaecal1.txt',filepath);
ptonsils=bugs2mat('ptonsilsIndex.txt','ptonsils1.txt',filepath);
pcarcass=bugs2mat('pcarcassIndex.txt','pcarcass1.txt',filepath);
ppluck=bugs2mat('ppluckIndex.txt','ppluck1.txt',filepath);
pintestinal=bugs2mat('pintestinalIndex.txt','pintestinal1.txt',filepath);
penviro=bugs2mat('penviroIndex.txt','penviro1.txt',filepath);
farm_tm=bugs2mat('farm_tmIndex.txt','farm_tm1.txt',filepath);
slaughter_tm=bugs2mat('slaughter_tmIndex.txt','slaughter_tm1.txt',filepath);
gam=bugs2mat('gamIndex.txt','gam1.txt',filepath);
exm=bugs2mat('exmIndex.txt','exm1.txt',filepath);
rrm=bugs2mat('rrmIndex.txt','rrm1.txt',filepath);
mrep=bugs2mat('mrepIndex.txt','mrep1.txt',filepath);
mp=bugs2mat('mpIndex.txt','mp1.txt',filepath);
mp_base=bugs2mat('mp.baseIndex.txt','mp.base1.txt',filepath);
mp_causal_h=bugs2mat('mp.causal.hIndex.txt','mp.causal.h1.txt',filepath);
mp_causal_r=bugs2mat('mp.causal.rIndex.txt','mp.causal.r1.txt',filepath);
mp_causal_hr=bugs2mat('mp.causal.hrIndex.txt','mp.causal.hr1.txt',filepath);
chi2=bugs2mat('chi2Index.txt','chi21.txt',filepath);
pcheck=bugs2mat('pcheckIndex.txt','pcheck1.txt',filepath);
Lposterior=bugs2mat('LposteriorIndex.txt','Lposterior1.txt',filepath);
xpfm=bugs2mat('xpfmIndex.txt','xpfm1.txt',filepath);
ypim=bugs2mat('ypimIndex.txt','ypim1.txt',filepath);
ypcm=bugs2mat('ypcmIndex.txt','ypcm1.txt',filepath);
yppm=bugs2mat('yppmIndex.txt','yppm1.txt',filepath);
yptm=bugs2mat('yptmIndex.txt','yptm1.txt',filepath);
zone2zero=bugs2mat('zone2zeroIndex.txt','zone2zero1.txt',filepath);
zone2one=bugs2mat('zone2oneIndex.txt','zone2one1.txt',filepath);
zzero2one=bugs2mat('zzero2oneIndex.txt','zzero2one1.txt',filepath);
zzero2zero=bugs2mat('zzero2zeroIndex.txt','zzero2zero1.txt',filepath);

hcolor=[0.9 0.7 0.2];
figure(1);
for i=1:4
[lo(i),up(i)]=credint(a.a(:,i),0.95);
subplot(2,2,i); histog(a.a(:,i),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo(i)),',',num2str(up(i)),']'));
title(strcat('a(',num2str(i),')'));
end
figure(2);
for i=1:4
[lo(i),up(i)]=credint(b.b(:,i),0.95);
subplot(2,2,i); histog(b.b(:,i),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo(i)),',',num2str(up(i)),']'));
title(strcat('b(',num2str(i),')'));
end
figure(3);
[lo,up]=credint(b.b(:,5),0.95);
subplot(1,2,1); histog(b.b(:,5),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('b(',num2str(5),')')); 
[lo,up]=credint(gam.gam(:,1),0.95);
subplot(1,2,2); histog(gam.gam(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('gamma'); 
figure(4);
[lo,up]=credint(pfaecal.pfaecal(:,1),0.95);
subplot(2,3,1); histog(pfaecal.pfaecal(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('pfaecal');  
[lo,up]=credint(pintestinal.pintestinal(:,1),0.95);
subplot(2,3,2); histog(pintestinal.pintestinal(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('pintestinal');
[lo,up]=credint(ppluck.ppluck(:,1),0.95);
subplot(2,3,3); histog(ppluck.ppluck(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('ppluck');
[lo,up]=credint(ptonsils.ptonsils(:,1),0.95);
subplot(2,3,4); histog(ptonsils.ptonsils(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('ptonsils');
[lo,up]=credint(pcarcass.pcarcass(:,1),0.95);
subplot(2,3,5); histog(pcarcass.pcarcass(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('pcarcass');
[lo,up]=credint(penviro.penviro(:,1),0.95);
subplot(2,3,6); histog(penviro.penviro(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('penviro');
figure(5);
[lo,up]=credint(exm.exm(:,1),0.95);
subplot(1,2,1); histog(exm.exm(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('exm');
[lo,up]=credint(rrm.rrm(:,1),0.95);
subplot(1,2,2); histog(rrm.rrm(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('rrm');
figure(6);
[lo,up]=credint(mp_base.mp_base(:,1),0.95);
subplot(2,2,1); histog(mp_base.mp_base(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('mp.base (1)');
[lo,up]=credint(mp_causal_h.mp_causal_h(:,1),0.95);
subplot(2,2,2); histog(mp_causal_h.mp_causal_h(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('mp.causal.h (1)');
[lo,up]=credint(mp_causal_r.mp_causal_r(:,1),0.95);
subplot(2,2,3); histog(mp_causal_r.mp_causal_r(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('mp.causal.r (1)');
[lo,up]=credint(mp_causal_hr.mp_causal_hr(:,1),0.95);
subplot(2,2,4); histog(mp_causal_hr.mp_causal_hr(:,1),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title('mp.causal.hr (1)');

figure(7);
for i=1:6
[lo(i),up(i)]=credint(xpfm.xpfm(:,i),0.95);
subplot(2,3,i); histog(xpfm.xpfm(:,i),100,hcolor);
xlabel(strcat('95% CI: [',num2str(lo(i)),',',num2str(up(i)),']'));
title(strcat('predicted xpfm(',num2str(i),')'));
end
figure(8);
for i=1:6    
[lo(i),up(i)]=credint(ypim.ypim(:,i),0.95);
subplot(2,3,i); histog(ypim.ypim(:,i),100,hcolor);
xlabel(strcat('95% CI: [',num2str(lo(i)),',',num2str(up(i)),']'));
title(strcat('predicted ypim(',num2str(i),')'));
end
figure(9);
for i=1:6    
[lo(i),up(i)]=credint(yppm.yppm(:,i),0.95);
subplot(2,3,i); histog(yppm.yppm(:,i),100,hcolor);
xlabel(strcat('95% CI: [',num2str(lo(i)),',',num2str(up(i)),']'));
title(strcat('predicted yppm(',num2str(i),')'));
end
figure(10);
for i=1:6    
[lo(i),up(i)]=credint(yptm.yptm(:,i),0.95);
subplot(2,3,i); histog(yptm.yptm(:,i),100,hcolor);
xlabel(strcat('95% CI: [',num2str(lo(i)),',',num2str(up(i)),']'));
title(strcat('predicted yptm(',num2str(i),')'));
end
figure(11);
for i=1:6    
[lo(i),up(i)]=credint(ypcm.ypcm(:,i),0.95);
subplot(2,3,i); histog(ypcm.ypcm(:,i),100,hcolor);
xlabel(strcat('95% CI: [',num2str(lo(i)),',',num2str(up(i)),']'));
title(strcat('predicted ypcm(',num2str(i),')'));
end
figure(12);
[lo,up]=credint(chi2.chi2(:,1),0.95);
subplot(1,2,1); histog(chi2.chi2(:,1),100,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('chi2 (\chi^2_{df10})'));
[lo,up]=credint(pcheck.pcheck(:,1),0.95);
subplot(1,2,2); histog(pcheck.pcheck(:,1),100,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('pcheck'));
figure(13)
for i=1:6
[lo(i),up(i)]=credint(mrep.mrep(:,i),0.95);
subplot(2,3,i); histog(mrep.mrep(:,i),20,hcolor);axis([0 25 0 0.8]);
xlabel(strcat('95% CI: [',num2str(lo(i)),',',num2str(up(i)),']'));
title(strcat('predicted mrep(',num2str(i),')'));
end
figure(14);
for i=1:15
[lo(i),up(i)]=credint(f1.f1(:,i),0.95);
subplot(3,5,i); histog(f1.f1(:,i),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo(i)),',',num2str(up(i)),']'),'fontsize',6);
if organic(i)==1
title(strcat('F_{',num2str(i),'} (organic)'),'color','g');
end
if small(i)==1
title(strcat('F_{',num2str(i),'} (small)'),'color','b');
end
if large(i)==1
title(strcat('F_{',num2str(i),'} (large)'),'color','r');
end
end
figure(15);
for i=1:15
[lo(i),up(i)]=credint(f2.f2(:,i),0.95);
subplot(3,5,i); histog(f2.f2(:,i),20,hcolor);
xlabel(strcat('95% CI: [',num2str(lo(i)),',',num2str(up(i)),']'),'fontsize',6);
if organic(i)==1
title(strcat('F_{',num2str(i),'} (organic)'),'color','g');
end
if small(i)==1
title(strcat('F_{',num2str(i),'} (small)'),'color','b');
end
if large(i)==1
title(strcat('F_{',num2str(i),'} (large)'),'color','r');
end
end
figure(16);
for i=1:15
    plot(mean(f1.f1(:,i)),mean(f2.f2(:,i)),'.'); hold on;
end
xlabel('posterior mean F1');
ylabel('posterior mean F2');

figure(17);
ind=min(find(organic.*(1-risk)));
[lo,up]=credint(zzero2one.zzero2one(:,ind),0.95);
subplot(3,2,1); histog(zzero2one.zzero2one(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('zzero2oneORGR1'));
axis([0 1 0 15]);
ind=min(find(organic.*risk));
[lo,up]=credint(zzero2one.zzero2one(:,ind),0.95);
subplot(3,2,2); histog(zzero2one.zzero2one(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('zzero2oneORGR2'));
axis([0 1 0 15]);
ind=min(find(small.*(1-risk)));
[lo,up]=credint(zzero2one.zzero2one(:,ind),0.95);
subplot(3,2,3); histog(zzero2one.zzero2one(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('Pzero2oneSMAR1'));
axis([0 1 0 15]);
ind=min(find(small.*risk));
[lo,up]=credint(zzero2one.zzero2one(:,ind),0.95);
subplot(3,2,4); histog(zzero2one.zzero2one(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('zzero2oneSMAR2'));
axis([0 1 0 15]);
ind=min(find(large.*(1-risk)));
[lo,up]=credint(zzero2one.zzero2one(:,ind),0.95);
subplot(3,2,5); histog(zzero2one.zzero2one(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('zzero2oneBIGR1'));
axis([0 1 0 15]);
ind=min(find(large.*risk));
[lo,up]=credint(zzero2one.zzero2one(:,ind),0.95);
subplot(3,2,6); histog(zzero2one.zzero2one(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('zzero2oneBIGR2'));
axis([0 1 0 15]);


figure(18);
ind=min(find(organic.*(1-risk)));
[lo,up]=credint(zone2zero.zone2zero(:,ind),0.95);
subplot(3,2,1); histog(zone2zero.zone2zero(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('zone2zeroORGR1'));
axis([0 1 0 15]);
ind=min(find(organic.*risk));
[lo,up]=credint(zone2zero.zone2zero(:,ind),0.95);
subplot(3,2,2); histog(zone2zero.zone2zero(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('zone2zeroORGR2'));
axis([0 1 0 15]);
ind=min(find(small.*(1-risk)));
[lo,up]=credint(zone2zero.zone2zero(:,ind),0.95);
subplot(3,2,3); histog(zone2zero.zone2zero(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('Pone2zeroSMAR1'));
axis([0 1 0 15]);
ind=min(find(small.*risk));
[lo,up]=credint(zone2zero.zone2zero(:,ind),0.95);
subplot(3,2,4); histog(zone2zero.zone2zero(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('zone2zeroSMAR2'));
axis([0 1 0 15]);
ind=min(find(large.*(1-risk)));
[lo,up]=credint(zone2zero.zone2zero(:,ind),0.95);
subplot(3,2,5); histog(zone2zero.zone2zero(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('zone2zeroBIGR1'));
axis([0 1 0 15]);
ind=min(find(organic.*risk));
[lo,up]=credint(zone2zero.zone2zero(:,ind),0.95);
subplot(3,2,6); histog(zone2zero.zone2zero(:,ind),25,hcolor);
xlabel(strcat('95% CI: [',num2str(lo),',',num2str(up),']'));
title(strcat('zone2zeroBIGR2'));
axis([0 1 0 15]);


 %faecal_combined=
 X=[1,1,1,0,1,1,0,0,0,1,0,0,0,1,1,0,1,1,1,1,1,0,1,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  1,0,0,0,0,1,1,0,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,1,1,NaN;
  0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,1,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,NaN,NaN,NaN,NaN,NaN;
  0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,NaN,NaN,NaN,NaN;
  0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,0,0,NaN;
  1,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,1,0,0,1,0,0,1,NaN,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN,NaN,NaN,NaN,NaN];
  %slaughter_combined_intestinal=
  Y1=[0,0,0,1,1,1,1,0,0,0,0,1,NaN,0,1,1,0,1,0,0,0,0,0,0,1,NaN;
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  NaN,1,NaN,0,NaN,1,NaN,1,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,1,NaN;
  0,1,0,0,NaN,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,NaN;
  0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,NaN,NaN,NaN,NaN,NaN;
  0,0,1,1,0,0,1,0,1,0,0,1,0,0,0,0,0,1,0,0,0,1,NaN,NaN,NaN,NaN;
  0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,1,1,1,0,0,1,NaN;
  0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,NaN,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,NaN,NaN,NaN,NaN,NaN];
  %slaughter_combined_pluck=
  Y2=[0,0,1,0,0,0,0,1,0,0,0,0,NaN,0,1,0,0,0,1,1,0,0,0,0,0,NaN;
  0,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,NaN;
  NaN,0,NaN,NaN,NaN,0,NaN,NaN,0,1,1,0,1,0,1,0,1,0,0,1,0,1,0,0,1,NaN;
  1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,NaN,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,1,1,0,0,1,1,1;
  0,0,0,0,NaN,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,NaN;
  0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,NaN,NaN,NaN,NaN,NaN;
  0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,NaN,NaN,NaN,NaN;
  0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,NaN,0,0,0,1,0,1,1,0,0,NaN;
  0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,NaN,NaN;
  NaN,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,1,0,NaN,NaN,NaN,NaN,NaN];
  %slaughter_combined_tonsils=
  Y3=[1,1,0,0,1,1,0,0,0,0,1,1,NaN,1,1,0,1,0,1,1,1,1,0,0,1,NaN;
  0,1,1,1,0,1,0,1,0,1,1,0,1,1,1,0,1,1,1,0,1,1,1,1,1,NaN;
  NaN,1,NaN,NaN,NaN,1,NaN,NaN,NaN,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,NaN;
  1,1,1,1,1,1,1,0,1,1,0,1,1,1,1,1,1,0,0,1,NaN,1,1,1,1,NaN;
  0,0,0,NaN,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN,0,NaN;
  1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,1,1,1,0, NaN;
  1,1,1,0,1,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,1,0,1;
  0,0,0,0,NaN,0,0,0,1,1,1,0,1,0,1,0,0,0,1,1,1,1,1,1,1,NaN;
  1,1,1,0,1,1,1,1,NaN,1,1,1,0,1,1,1,1,0,1,1,1,1,1,0,1,NaN;
  1,1,1,0,1,1,1,0,1,1,0,1,1,0,1,1,1,0,0,0,1,NaN,NaN,NaN,NaN,NaN;
  1,1,1,1,0,0,1,1,0,1,0,1,0,0,1,1,1,0,0,0,0,1,NaN,NaN,NaN,NaN;
  1,0,1,0,1,1,1,1,1,1,1,1,0,1,1,1,0,1,0,1,1,1,1,1,1,NaN;
  1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,NaN,NaN;
  0,0,0,0,1,0,0,1,0,0,0,0,1,1,0,1,1,1,0,1,0,1,0,0,0,NaN;
  0,1,0,0,1,1,0,0,1,1,0,0,1,NaN,0,1,1,0,0,1,0,NaN,NaN,NaN,NaN,NaN];
  %slaughter_combined_carcass=
  Y4=[1,1,1,1,0,0,0,0,0,0,0,0,NaN,1,1,0,1,0,0,1,0,0,0,0,1,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  NaN,1,NaN,0,NaN,0,NaN,0,1,1,1,1,0,0,1,1,1,1,0,1,0,1,1,0,1,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,NaN,NaN,NaN,NaN,NaN;
  1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,NaN,NaN,NaN,NaN;
  0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN;
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,NaN,NaN,NaN,NaN,NaN];

 for i=1:15
    figure(19); 
    Xm(i)=mean(X(i,find(~isnan(X(i,:)))));
    Y1m(i)=mean(Y1(i,find(~isnan(Y1(i,:)))));
    Y2m(i)=mean(Y2(i,find(~isnan(Y2(i,:)))));
    Y3m(i)=mean(Y3(i,find(~isnan(Y3(i,:)))));
    Y4m(i)=mean(Y4(i,find(~isnan(Y4(i,:)))));
    if risk(i)==1
        subplot(2,2,1);
        plot(Xm(i),Y1m(i),'o');
        hold on;
        plot(Xm(i),Y2m(i),'*');
        plot(Xm(i),Y3m(i),'+');
        plot(Xm(i),Y4m(i),'r^');
        plot([0 1],[0 1],'k');
        axis([-0.1 1 -0.1 1]);
        title('high H-score');
        xlabel('farm sample');
        ylabel('abattoir sample');
    end
    if small(i)==1
        subplot(2,2,2);
        plot(Xm(i),Y1m(i),'o');
        hold on;
        plot(Xm(i),Y2m(i),'*');
        plot(Xm(i),Y3m(i),'+');
        plot(Xm(i),Y4m(i),'r^');
        plot([0 1],[0 1],'k');
        axis([-0.1 1 -0.1 1]);
        title('small');
        xlabel('farm sample');
        ylabel('abattoir sample');
    end
    if organic(i)==1
        subplot(2,2,3);
        plot(Xm(i),Y1m(i),'o');
        hold on;
        plot(Xm(i),Y2m(i),'*');
        plot(Xm(i),Y3m(i),'+');
        plot(Xm(i),Y4m(i),'r^');
        plot([0 1],[0 1],'k');
        axis([-0.1 1 -0.1 1]);
        title('organic');
        xlabel('farm sample');
        ylabel('abattoir sample');
    end
    if large(i)==1
        subplot(2,2,4);
        plot(Xm(i),Y1m(i),'o');
        hold on;
        plot(Xm(i),Y2m(i),'*');
        plot(Xm(i),Y3m(i),'+');
        plot(Xm(i),Y4m(i),'r^');
        plot([0 1],[0 1],'k');
        axis([-0.1 1 -0.1 1]);
        title('large');
        xlabel('farm sample');
        ylabel('abattoir sample');
    end
    figure(20);
    if risk(i)==1
    subplot(2,2,1);
    title('high H-score');
    xlabel('farm sample');
    ylabel('abattoir sample average');
    plot(Xm(i),(Y1m(i)+Y2m(i)+Y3m(i)+Y4m(i))/4,'o');
    axis([-0.1 1 -0.1 1]);
    plot([0 1],[0 1],'k');
    hold on;
    end
    if small(i)==1
    subplot(2,2,2);
    title('small');
    xlabel('farm sample');
    ylabel('abattoir sample average');
    plot(Xm(i),(Y1m(i)+Y2m(i)+Y3m(i)+Y4m(i))/4,'o');
    axis([-0.1 1 -0.1 1]);
    plot([0 1],[0 1],'k');
    hold on;
    end
    if organic(i)==1
    subplot(2,2,3);
    title('organic');
    xlabel('farm sample');
    ylabel('abattoir sample average');
    plot(Xm(i),(Y1m(i)+Y2m(i)+Y3m(i)+Y4m(i))/4,'o');
    axis([-0.1 1 -0.1 1]);
    plot([0 1],[0 1],'k');
    hold on;
    end
    if large(i)==1
    subplot(2,2,4);
    title('large');
    xlabel('farm sample');
    ylabel('abattoir sample average');
    plot(Xm(i),(Y1m(i)+Y2m(i)+Y3m(i)+Y4m(i))/4,'o');
    axis([-0.1 1 -0.1 1]);
    plot([0 1],[0 1],'k');
    hold on;
    end
 end
 
 figure(21);
for i=1:15
if risk(i)==1
    subplot(2,2,1);
    plot(mean(farm_tm.farm_tm(:,i)),mean(slaughter_tm.slaughter_tm(:,i)),'o');
    hold on;
    [lof(i),upf(i)]=credint(farm_tm.farm_tm(:,i),0.95);
    [los(i),ups(i)]=credint(slaughter_tm.slaughter_tm(:,i),0.95);
    plot([lof(i) upf(i)],[mean(slaughter_tm.slaughter_tm(:,i)) mean(slaughter_tm.slaughter_tm(:,i))],'k');
    plot([mean(farm_tm.farm_tm(:,i)) mean(farm_tm.farm_tm(:,i))],[los(i) ups(i)],'k'); 
    title('high H-score');
    axis([-0.1 1.1 -0.1 1.1]);plot([0 1],[0 1],'k');
    xlabel('hidden farm prevalence');
    ylabel('hidden abattoir prevalence');
end
if organic(i)==1
    subplot(2,2,3);
    plot(mean(farm_tm.farm_tm(:,i)),mean(slaughter_tm.slaughter_tm(:,i)),'o');
    hold on;
    [lof(i),upf(i)]=credint(farm_tm.farm_tm(:,i),0.95);
    [los(i),ups(i)]=credint(slaughter_tm.slaughter_tm(:,i),0.95);
    plot([lof(i) upf(i)],[mean(slaughter_tm.slaughter_tm(:,i)) mean(slaughter_tm.slaughter_tm(:,i))],'k');
    plot([mean(farm_tm.farm_tm(:,i)) mean(farm_tm.farm_tm(:,i))],[los(i) ups(i)],'k');
    title('organic');
    axis([-0.1 1.1 -0.1 1.1]);plot([0 1],[0 1],'k');
    xlabel('hidden farm prevalence');
    ylabel('hidden abattoir prevalence');
end
if small(i)==1
    subplot(2,2,2);
    plot(mean(farm_tm.farm_tm(:,i)),mean(slaughter_tm.slaughter_tm(:,i)),'o');
    hold on;
    [lof(i),upf(i)]=credint(farm_tm.farm_tm(:,i),0.95);
    [los(i),ups(i)]=credint(slaughter_tm.slaughter_tm(:,i),0.95);
    plot([lof(i) upf(i)],[mean(slaughter_tm.slaughter_tm(:,i)) mean(slaughter_tm.slaughter_tm(:,i))],'k');
    plot([mean(farm_tm.farm_tm(:,i)) mean(farm_tm.farm_tm(:,i))],[los(i) ups(i)],'k');
    title('small');
    axis([-0.1 1.1 -0.1 1.1]);plot([0 1],[0 1],'k');
    xlabel('hidden farm prevalence');
    ylabel('hidden abattoir prevalence');
end
if large(i)==1
    subplot(2,2,4);
    plot(mean(farm_tm.farm_tm(:,i)),mean(slaughter_tm.slaughter_tm(:,i)),'o');
    hold on; 
    [lof(i),upf(i)]=credint(farm_tm.farm_tm(:,i),0.95);
    [los(i),ups(i)]=credint(slaughter_tm.slaughter_tm(:,i),0.95);
    plot([lof(i) upf(i)],[mean(slaughter_tm.slaughter_tm(:,i)) mean(slaughter_tm.slaughter_tm(:,i))],'k');
    plot([mean(farm_tm.farm_tm(:,i)) mean(farm_tm.farm_tm(:,i))],[los(i) ups(i)],'k');
    title('large');
    axis([-0.1 1.1 -0.1 1.1]);plot([0 1],[0 1],'k');
    xlabel('hidden farm prevalence');
    ylabel('hidden abattoir prevalence');
end
end
figure(22);
thin=1:max(1,round(0.01*length(pfaecal.pfaecal(:,1)))):length(pfaecal.pfaecal(:,1));
for i=1:15
subplot(3,5,i);
plot(farm_tm.farm_tm(thin,i),pfaecal.pfaecal(thin,1),'.');
xlabel(strcat('carrier prev X_{',num2str(i),'}'),'fontsize',10);
ylabel('pfaecal','fontsize',10);
end
figure(23);
thin=1:max(1,round(0.01*length(penviro.penviro(:,1)))):length(penviro.penviro(:,1));
for i=1:15
subplot(3,5,i);
plot(slaughter_tm.slaughter_tm(thin,i),1-(1-penviro.penviro(thin,1)).*(1-pcarcass.pcarcass(thin,1)),'.');
xlabel(strcat('carrier prev Y_{',num2str(i),'}'),'fontsize',10);
ylabel('1-(1-penviro)(1-pcarcass)','fontsize',10);
end
figure(24);
thin=1:max(1,round(0.01*length(penviro.penviro(:,1)))):length(penviro.penviro(:,1));
for i=1:15
subplot(3,5,i);
plot(slaughter_tm.slaughter_tm(thin,i),1-(1-penviro.penviro(thin,1)).*(1-ppluck.ppluck(thin,1)),'.');
xlabel(strcat('carrier prev Y_{',num2str(i),'}'),'fontsize',10);
ylabel('1-(1-penviro)(1-ppluck)','fontsize',10);
end
figure(25);
thin=1:max(1,round(0.01*length(ptonsils.ptonsils(:,1)))):length(ptonsils.ptonsils(:,1));
for i=1:15
subplot(3,5,i);
plot(slaughter_tm.slaughter_tm(thin,i),ptonsils.ptonsils(thin,1),'.');
xlabel(strcat('carrier prev Y_{',num2str(i),'}'),'fontsize',10);
ylabel('ptonsils','fontsize',10);
end
figure(26);
thin=1:max(1,round(0.01*length(ptonsils.ptonsils(:,1)))):length(ptonsils.ptonsils(:,1));
for i=1:15
subplot(3,5,i);
plot(slaughter_tm.slaughter_tm(thin,i),pintestinal.pintestinal(thin,1),'.');
xlabel(strcat('carrier prev Y_{',num2str(i),'}'),'fontsize',10);
ylabel('pintestinal','fontsize',10);
end

 
     
 
 



