cat( date(),"\n")
rm(list=ls())
library("arm")

load("APOAIdata.RData")
dg = rowMeans(Y1) - rowMeans(Y2)
logf = sprintf("ResultsTest.RData")
G=dim(Y1)[1]
J=dim(Y1)[2]
f=J-1  # = df/2
mg = (rowSums((Y1 - rowMeans(Y1))^2) +
      rowSums((Y2 - rowMeans(Y2))^2)) / (2*J-2) 
data <- list ("G","J", "dg","mg","f")
    inits <- list(
        list(alpha=2,beta=3,tau=0,p1=0.01,psi=1,invsig2psi=0.5,
           b=rep(0,G), psig=runif(G,min=0,max=2),
           invsig2e=runif(G,min=0.1,max=1)) 
    )

parameters <- c("alpha", "beta", "tau", "psi","invsig2psi", "p1")
RR.sim <- bugs (data, inits, parameters, 
      model.file="rrmodel_dg.bug",
      n.chains=1, n.iter=6000, n.burnin=3000,n.thin=2)
attach.bugs (RR.sim)
save(RR.sim,alpha,beta,tau,psi,invsig2psi,p1, file=logf)

cat( date(),"\n")
RR.sim$summary[1:6,]
