CVNPgarr <- function(formula = formula(data),data=sys.parent(),ycolumn,sp=NULL,V=10,s.step=NULL,s.max=NULL,all.cks=F,contrasts = NULL)
  {
 # Data need to be centered
 #
 # This works!!
 #  aa <- CVNPgarr(substitute(logmedv ~ s(crim,df=mydf1)+s(zn,df=mydf2),list(mydf1=cdfcrim,mydf2=dfzn)), data = BHcentered.log, V = 5, s.step = 0.2, s.max = 13)

    
    # This function doesn't work if some variables in formula are transformed,
    # for example, log(y) etc.
    
# Auxilliary functions that call the Fortran code    
    NPnngarrote <- function(ff,fy,ssy,M,sumck)
      {
        dummy.shrcf <- rep(0,length=M)
        garrote.fit <- .Fortran("npsubgar",FF=as.double(ff),FY=as.double(fy),
                            YY=as.double(ssy),as.integer(M),SUMB=as.double(sumck),
                            SHRCF=as.double(dummy.shrcf))
        return(garrote.fit$SHRCF)
      }
#    assign("NPnngarrote",NPnngarrote,frame=1)

# Loading of the Fortran library    
    dyn.load("/home/cantoni/RECHERCHE/nngarrote/libR/npnewlib.so")
    
    n <- nrow(data)
    p <- ncol(data)-1
    
#    call <- match.call()
#    m <- match.call(expand = F)
#    Terms <-  terms(formula)
#    m$formula <- Terms
#    m$family <- m$method <- m$model <- m$x <- m$y <- m$control <- m$contrasts <- m$V <- m$s.step <- m$s.max <- m$all.cks <- m$... <- NULL
#    m[[1]] <- as.name("model.frame")
#    m <- eval(m, sys.parent())
#    y <- model.extract(m, response)
#    # This doesnt work for transformed y.
#    ycolumn <- charmatch(as.character(formula[[2]]),dimnames(data)[[2]])
#    X <- model.matrix(Terms, m, contrasts)[,-1]
#    n <- nrow(X)
#    p <- ncol(X)
#    xvars <- as.character(attr(Terms, "variables"))

    
#    assign("formula",formula,frame=1)
#    assign("data",data,frame=1)

# Splits for crossvalidation (one last larger group if not equally )
    randomsplit <- sample(1:n,n)
    CVdata <- data[randomsplit,]
    foldid <- rep(1:V,each=n%/%V)
    foldid <- c(foldid,rep(V,times= n - V * (n%/%V)))
    
# Cross-validated prediction errors
    if(is.null(s.max))
      s.max <- 2*p
    if(is.null(s.step))
      s.step <- 0.1
    s.grid <- seq(s.step,s.max,by=s.step)
    if(all.cks)
      all.ck <- matrix(0,ncol=length(s.grid),nrow=p)
    else all.ck <- NULL
    ME <- matrix(0,ncol=length(s.grid),nrow=V)

    for(i in 1:V)
      {
        cat("Fold",i,"\n")
        # centering of the x's of the construction sample
        thiscsample <- data.frame(cbind(scale(CVdata[foldid!=i,-ycolumn],center=T,scale=F), CVdata[foldid!=i,ycolumn]))
        dimnames(thiscsample)[[2]] <- c((dimnames(CVdata)[[2]])[-ycolumn],(dimnames(CVdata)[[2]])[ycolumn])
        # subtract the mean of the construction sample to the x's of the validation sample
        thisvsample <- data.frame(sweep(CVdata[foldid==i,-ycolumn,drop=F],2,colMeans(thiscsample[,-ycolumn])))
        dimnames(thisvsample)[[2]] <- c((dimnames(CVdata)[[2]])[-ycolumn])

#        assign("thiscsample",thiscsample,frame=1)
            
        # gam fit in fold i.
        thisgam <- gam(formula=formula,data=thiscsample,sp=sp)
            
        # Arguments for NPnngarrote
        thisFmatNP <- predict(thisgam,type="terms")
        # FmatNP <- t(t(thiscsample[,xvars[2:(p+1)]])*thisgam$coefficients[-1]) + thisgam$smooth
        thisFF.NP <- t(thisFmatNP)%*%thisFmatNP
        thisFy.NP <- t(thisFmatNP)%*%thiscsample[,ycolumn]

        for(j in 1:length(s.grid))
          {
            # Call to NPnngarrote
            NPgarr.res <- NPnngarrote(ff=thisFF.NP,fy=thisFy.NP,ssy=sum((thiscsample[,ycolumn]^2)),M=p,sumck=s.grid[j])
            # Prediction
            names(NPgarr.res) <- names(data)[-ycolumn]

            # predict.gam has troubles (only when type="terms")
            # when thisvsample has only one row.
            sy <- colSums(t(predict.gam(thisgam,newdata=thisvsample,type="terms"))*NPgarr.res) + thisgam$coefficients[1]

            # Need mean() instead of sum(), as in DC, because of different sizes
            # of the validation samples
            ME[i,j] <- mean((CVdata[foldid==i,ycolumn]-sy)^2)
          }
      }

    PE <- colSums(ME)
    s.ind <- which(PE==min(PE))
    s.min <- s.grid[s.ind]

    # Final fit
    y <- data[,ycolumn]
    gam.res <- gam(formula=formula,data=data,sp=sp)
    FmatNP <- predict(gam.res,type="terms")
    FF.NP <- t(FmatNP)%*%FmatNP
    Fy.NP <- t(FmatNP)%*%y
        
    cks <- NPnngarrote(FF.NP,Fy.NP,sum(y^2),M=p,sumck=s.min)
    fittedy <-  colSums(t(predict.gam(gam.res,type="terms"))*NPgarr.res) + gam.res$coefficients[1]


   # cks if asked for
    ck <- NULL
    if(all.cks)
      {
        ck <- matrix(0,ncol=length(s.grid),nrow=p)
        for(j in 1:length(s.grid))
          {
            ck[,j] <- NPnngarrote(ff=FF.NP,fy=Fy.NP,ssy=sum(y^2),M=p,sumck=s.grid[j])$cks
          }
       }
    
    return(list(call=call,s.opt=s.min,allPE=PE,cks=cks,all.ck=ck,fit=gam.res,fitted=fittedy))
  }

      


    
