NPgarrBlueSharks <- function(formula = formula(data),data=sys.parent(),ycolumn,sp=NULL,sumck,contrasts = NULL)
  {
    # ycolumn is the number of the column in data that correspond to the outcome
    # sp is the spar parameter
    # sumck is the value of s
    #
    # Warning: due to the behaviour of predict.gam, formula has to contain 
    # the parametric components first.
    
# Auxilliary functions that call the Fortran code    
    NPnngarrote <- function(ff,fy,ssy,M,sumck)
      {
        dummy.shrcf <- rep(0,length=M)
        garrote.fit <- .Fortran("npsubgar",FF=as.double(ff),FY=as.double(fy),
                            YY=as.double(ssy),as.integer(M),SUMB=as.double(sumck),
                            SHRCF=as.double(dummy.shrcf))
        return(garrote.fit$SHRCF)
      }

# Loading of the Fortran library    
    dyn.load("npsubgar.so")

    library(mgcv)

    dimX <- ncol(X)    
    tf <- terms.formula(formula, specials = c("s", "te"))
    terms <- attr(tf, "term.labels")
    y <- data[,as.character(attr(tf, "variables")[2])]
    n <- nrow(data)
    p <- length(terms)

    gam.res <- gam(formula,data,sp=sp,family=gaussian)

    FmatNP <- predict(gam.res,type="terms")
    FF.NP <- t(FmatNP)%*%FmatNP
    Fy.NP <- t(FmatNP)%*%y

    NPgarr.res <- NPnngarrote(FF.NP,Fy.NP,sum(y^2),p,sumck)

    names(NPgarr.res) <- terms

    fittedy <-  colSums(t(predict.gam(gam.res,type="terms"))*NPgarr.res)+gam.res$coefficients[1]

    return(list(call=call,cks=NPgarr.res,yhat=fittedy,fit=gam.res,gam.res=gam.res))
  }



