source("CVNPgarr.R")
source("truef.R")


# SIMULATION: NNG C1
######################
simt0V5.cks <- matrix(-1,ncol=100,nrow=10)
simt0V5.mse <- numeric(100)
simt0V5.df <- matrix(-1,ncol=100,nrow=10)

set.seed(445)

i <- 1

for(i in 1:100)
  {
    cat("Simulation",i,"\n")
    thisdata <- read.table(file=paste("simtrain",i,sep=""),sep=",",header=F,col.names = c(paste("x",1:10, sep = ""),"y"))
    thistest <- read.table(file=paste("simtest",i,sep=""),sep=",",header=F,col.names = c(paste("x",1:10, sep = ""),"y"))

    # CENTER DATA
    centered.X <- data.frame(scale(thisdata[,-11],center=T,scale=F))
    thisy <- truef(centered.X)+rnorm(100)*1.3175
    centered.data <- data.frame(centered.X,y=thisy)
    centered.test <- data.frame(sweep(thistest[,-11],2,colMeans(thisdata[,-11])))
    thisf <- truef(centered.test)

    # mgcv
    library(mgcv)
    initialfit <- gam(y~s(x1,k=8)+s(x2,k=8)+s(x3,k=8)+s(x4,k=8)+s(x5,k=8)+s(x6,k=8)+
s(x7,k=8)+s(x8,k=8)+s(x9,k=8)+s(x10,k=8), data = centered.data)
    simt0V5.df[,i] <- summary(initialfit)$edf

    initialsp <- initialfit$sp

    temp <- CVNPgarr(y ~ s(x1,k=8)+s(x2,k=8)+s(x3,k=8)+s(x4,k=8)+s(x5,k=8)+s(x6,k=8)+s(x7,k=8)+s(x8,k=8)+s(x9,k=8)+s(x10,k=8),sp=initialsp, data = centered.data, ycolumn=11, V = 5, s.max = 15,s.step=0.1)

    simt0V5.cks[,i] <- temp$cks

    gamfit <- gam(y ~ s(x1,k=8)+s(x2,k=8)+s(x3,k=8)+s(x4,k=8)+s(x5,k=8)+s(x6,k=8)+s(x7,k=8)+s(x8,k=8)+s(x9,k=8)+s(x10,k=8),sp=initialsp, data = centered.data)
    test.fitted <-  colSums(t(predict.gam(gamfit,type="terms",newdata=centered.test))*temp$cks) + gamfit$coefficients[1]

    simt0V5.mse[i] <- mean((thisf-test.fitted)^2)
  }

    

# SIMULATION: NNG C2
######################
Same as above but with
   
temp <- CVNPgarr(y ~ s(x1,k=8)+s(x2,k=8)+s(x3,k=8)+s(x4,k=8)+s(x5,k=8)+s(x6,k=8)+s(x7,k=8)+s(x8,k=8)+s(x9,k=8)+s(x10,k=8), data = centered.data, ycolumn=11, V = 5, s.max = 15,s.step=0.1)

(sp is not fixed)

