# Loading of the package
library(clustmixed)

# Documentation files
?URgerman
?lungfunction
?lmmDPMEM


#-------------------------------------------------------------------------------
# Unemployment data
#-------------------------------------------------------------------------------

# Loading of the data
data(URgerman)

# Fitting the model
output <- lmmDPMEM(response=~unemployment, timevar=~yearnew, id=~id, fixed=NULL, random=1, alpha=0, printout=TRUE, data=URgerman)

# Estimation results
round(output$alpha,5)
round(output$pimat,3)
round(output$pivec,3)
round(output$betavec,3)
round(output$mumat,3)

# Clustering of federal states by DPM-EM model
graph(output, color=FALSE, xaxt="n", xlab="year", cex.lab=1.5, cex.axis=1.5, ylab="unemployment rate [percent]")
axis(side=1, at=seq(0,5), labels=seq(2005,2010), cex.axis=1.5)


#-------------------------------------------------------------------------------
# Lung function growth data
#-------------------------------------------------------------------------------

# Loading of the data
data(lungfunction)

# Fitting the model
output <- lmmDPMEM(response=~log.fev1, timevar=~age, id=~subject, fixed=NULL, random=1, alpha=0, printout=TRUE, data=lungfunction)

# Clustering of lung function growth data by DPM-EM model
graph(output, color=FALSE, xlab="age [years]", ylab="log(fev1) [log(liter)]", cex.lab=1.5, cex.axis=1.5)
spaceplot(output, color=FALSE, ki.level=0.95, cex.lab=1.5, cex.axis=1.5)

