/*****************************************************************************************************************/
/*****************************************************************************************************************/
/* C code for metropolis within gibbs algorithm with adaptive proposals                                          */
/* Two-compartment intravenous bolus model                                                                       */
/* by Jaeger Jonathan , Universit de Lige, Belgium                                                            */
/*****************************************************************************************************************/
/*****************************************************************************************************************/

#include <stdlib.h>
#include <math.h>
#include <R.h>
#include <Rmath.h>
#include "ATRIMS.h"
#include "matrice.h"
#include "logpost.h"

void metropolis_within_gibbs(int *n_accept_gamma_vect, int *n_accept_tau,
							 int *n_accept_lpk_vect, int *n_accept_lpk_mean, int *n_accept_lpk_tau,
							 double *param, int *all_integer,
							 double *prec_c_prior, double *prec_c_prior_mu_c_prior,
							 double *P_11, double *P_10, double *P_01, double *P_00, double *P_0110,
							 double *t_chol_var_lpk_vect, double *rotation,
							 double *sum_y_sq, double *tBB, double *tBy,
							 double *TAU_POST,
							 double *GAMMA_VECT_POST,
							 double *LPK_MEAN_POST, double *LPK_TAU_POST, double *LPK_VECT_POST)
{
	int i, j, k, l;
	int i_three, i_three_plus_l;
	int i_nine, i_nine_plus_l_three;

	int N = all_integer[0];
	int I = all_integer[1];
	int I_three = I*3;

	int M1   = all_integer[2];
	int M2   = all_integer[3];
	int M    = (M1 + M2);
	int M_sq = M*M;

	int N_iteration = all_integer[4];
	int N_burnin    = all_integer[5];
	int N_thin      = all_integer[6];
	int N_total     = all_integer[7];
	
	int N_paral = all_integer[8];
	int N_paral_minus_one = N_paral - 1;

	int N_paral_two = N_paral*2;
	int N_paral_minus_one_two = N_paral_minus_one*2;

	int N_paral_three = N_paral*3;
	int N_paral_minus_one_three = N_paral_minus_one*3;
	int N_paral_I_three = N_paral*I_three;
	int N_paral_minus_one_I_three = N_paral_minus_one*I_three;

	int N_paral_four = N_paral*4;
	int N_paral_minus_one_four = N_paral_minus_one*4;

	int N_paral_N_total = N_paral*N_total;
	int l_N_paral;
	int l_N_paral_minus_one;
	int l_N_paral_N_total;
	int i_N_paral_three;
	int i_N_paral_N_total_three;

	int n_iteration;
	int indice_stockage = 0;
	int thin_intermed = 1;
	int n_paral;
	int n_paral_N_total;
	int n_paral_N_total_plus_indice_stockage;

	int N_I = N*I;

	double double_I = ((double) I);
	double I_over_deux = 0.5*double_I;
	double I_moins_un_demi = double_I - 0.5;

	double a_tau = param[0];
	double b_tau = param[1];
	double a_tau_post_moins_un = 0.5*((double) N_I) + a_tau - 1.0;

	double *a_gamma_vect_moins_un, *b_gamma_vect;
	
	a_gamma_vect_moins_un = (double*)calloc(2, sizeof(double));
	b_gamma_vect          = (double*)calloc(2, sizeof(double));
	
	a_gamma_vect_moins_un[0] = param[2] - 1.0;
	b_gamma_vect[0]          = param[3];
	a_gamma_vect_moins_un[1] = param[4] - 1.0;
	b_gamma_vect[1]          = param[5];


	double a_tau_lke  = param[6],  b_tau_lke  = param[7];
	double a_tau_lkpc = param[8],  b_tau_lkpc = param[9];
	double a_tau_lV   = param[10], b_tau_lV   = param[11];

	double max_tau_lpk = param[12];

	double mean_lkcp = param[13], prec_lkcp = param[14];
	double mean_lke  = param[15], prec_lke  = param[16];
	double mean_lkpc = param[17], prec_lkpc = param[18];
	double mean_lV   = param[19], prec_lV   = param[20];

	double *a_tau_lpk_post, *a_tau_lpk_post_moins_un, *b_tau_lpk;
	double *mu_lpk, *prec_lpk;

	a_tau_lpk_post          = (double*)calloc(3, sizeof(double));
	a_tau_lpk_post_moins_un = (double*)calloc(3, sizeof(double));
	b_tau_lpk               = (double*)calloc(3, sizeof(double));

	mu_lpk   = (double*)calloc(4, sizeof(double));
	prec_lpk = (double*)calloc(4, sizeof(double));

	a_tau_lpk_post[0] = I_over_deux + a_tau_lke;
	a_tau_lpk_post[1] = I_over_deux + a_tau_lkpc;
	a_tau_lpk_post[2] = I_over_deux + a_tau_lV;

	a_tau_lpk_post_moins_un[0] = a_tau_lpk_post[0] - 1.0;
	a_tau_lpk_post_moins_un[1] = a_tau_lpk_post[1] - 1.0;
	a_tau_lpk_post_moins_un[2] = a_tau_lpk_post[2] - 1.0;

	b_tau_lpk[0] = b_tau_lke;
	b_tau_lpk[1] = b_tau_lkpc;
	b_tau_lpk[2] = b_tau_lV;

	mu_lpk[0] = mean_lkcp;
	mu_lpk[1] = mean_lke;
	mu_lpk[2] = mean_lkpc;
	mu_lpk[3] = mean_lV;

	prec_lpk[0] = prec_lkcp;
	prec_lpk[1] = prec_lke;
	prec_lpk[2] = prec_lkpc;
	prec_lpk[3] = prec_lV;


	double mean_lpk_vect_int = 0.0;
	double var_lpk_vect_int = 0.0;
	double inv_sd_lpk_vect_int;
	double u, prob;

	
	double *tau, *log_tau;
	double *log_tau_x;
	double tau_prop, *log_tau_prop;
	double tau_n_paral, log_tau_n_paral;
	double *dmtri_prop_log_tau_prop;
	double *dmtri_prop_log_tau_n_paral;
	
	tau                        = (double*)calloc(N_paral, sizeof(double));
	log_tau                    = (double*)calloc(N_paral, sizeof(double));
	log_tau_x                  = (double*)calloc(N_paral_minus_one, sizeof(double));
	log_tau_prop               = (double*)calloc(1, sizeof(double));
	dmtri_prop_log_tau_prop    = (double*)calloc(1, sizeof(double));
	dmtri_prop_log_tau_n_paral = (double*)calloc(1, sizeof(double));
	

	double *gamma_vect, *log_gamma_vect;
	double *log_gamma_vect_x, *log_gamma_vect_x_int;
	double *gamma_vect_prop, *log_gamma_vect_prop, *log_gamma_vect_prop_int;
	double *gamma_vect_n_paral, *log_gamma_vect_n_paral;
	double *dmtri_prop_log_gamma_vect_prop;
	double *dmtri_prop_log_gamma_vect_n_paral;
	
	gamma_vect                        = (double*)calloc(N_paral_two, sizeof(double));
	log_gamma_vect                    = (double*)calloc(N_paral_two, sizeof(double));
	log_gamma_vect_x                  = (double*)calloc(N_paral_minus_one_two, sizeof(double));
	log_gamma_vect_x_int              = (double*)calloc(N_paral_minus_one, sizeof(double));
	log_gamma_vect_prop               = (double*)calloc(2, sizeof(double));
	log_gamma_vect_prop_int           = (double*)calloc(1, sizeof(double));
	gamma_vect_prop                   = (double*)calloc(2, sizeof(double));
	log_gamma_vect_n_paral            = (double*)calloc(2, sizeof(double));
	gamma_vect_n_paral                = (double*)calloc(2, sizeof(double));
	dmtri_prop_log_gamma_vect_prop    = (double*)calloc(2, sizeof(double));
	dmtri_prop_log_gamma_vect_n_paral = (double*)calloc(2, sizeof(double));


	double *lpk_mean;
	double *lpk_mean_x, *lpk_mean_x_int;
	double *lpk_mean_prop, *lpk_mean_prop_int;
	double *lpk_mean_n_paral;
	double *dmtri_prop_lpk_mean_prop;
	double *dmtri_prop_lpk_mean_n_paral;
	
	lpk_mean                    = (double*)calloc(N_paral_four, sizeof(double));
	lpk_mean_x                  = (double*)calloc(N_paral_minus_one_four, sizeof(double));
	lpk_mean_x_int              = (double*)calloc(N_paral_minus_one, sizeof(double));
	lpk_mean_prop               = (double*)calloc(4, sizeof(double));
	lpk_mean_prop_int           = (double*)calloc(1, sizeof(double));
	lpk_mean_n_paral            = (double*)calloc(4, sizeof(double));
	dmtri_prop_lpk_mean_prop    = (double*)calloc(4, sizeof(double));
	dmtri_prop_lpk_mean_n_paral = (double*)calloc(4, sizeof(double));

	
	double *lpk_tau, *log_lpk_tau;
	double *log_lpk_tau_x, *log_lpk_tau_x_int;
	double *lpk_tau_prop, *log_lpk_tau_prop_int, *log_lpk_tau_prop;
	double *lpk_tau_n_paral, *log_lpk_tau_n_paral;
	double *dmtri_prop_log_lpk_tau_prop;
	double *dmtri_prop_log_lpk_tau_n_paral;
	
	lpk_tau                        = (double*)calloc(N_paral_three, sizeof(double));
	log_lpk_tau                    = (double*)calloc(N_paral_three, sizeof(double));
	log_lpk_tau_x                  = (double*)calloc(N_paral_minus_one_three, sizeof(double));
	log_lpk_tau_x_int              = (double*)calloc(N_paral_minus_one, sizeof(double));
	lpk_tau_prop                   = (double*)calloc(3, sizeof(double));
	log_lpk_tau_prop_int           = (double*)calloc(1, sizeof(double));
	log_lpk_tau_prop               = (double*)calloc(3, sizeof(double));
	lpk_tau_n_paral                = (double*)calloc(3, sizeof(double));
	log_lpk_tau_n_paral            = (double*)calloc(3, sizeof(double));
	dmtri_prop_log_lpk_tau_prop    = (double*)calloc(3, sizeof(double));
	dmtri_prop_log_lpk_tau_n_paral = (double*)calloc(3, sizeof(double));


	double *lpk_vect;
	double *lpk_vect_prop;
	double *lpk_vect_n_paral;
	
	lpk_vect                    = (double*)calloc(N_paral_I_three, sizeof(double));
	lpk_vect_prop               = (double*)calloc(I_three, sizeof(double));
	lpk_vect_n_paral            = (double*)calloc(I_three, sizeof(double));


	double *z;
	double *z_x, *z_x_int;
	double *z_prop, *z_prop_int;
	double *z_n_paral;
	double *dmtri_prop_z_prop;
	double *dmtri_prop_z_n_paral;
	
	z                    = (double*)calloc(N_paral_I_three, sizeof(double));
	z_x                  = (double*)calloc(N_paral_minus_one_I_three, sizeof(double));
	z_x_int              = (double*)calloc(N_paral_minus_one, sizeof(double));
	z_prop               = (double*)calloc(I_three, sizeof(double));
	z_prop_int           = (double*)calloc(1, sizeof(double));
	z_n_paral            = (double*)calloc(I_three, sizeof(double));
	dmtri_prop_z_prop    = (double*)calloc(I_three, sizeof(double));
	dmtri_prop_z_n_paral = (double*)calloc(I_three, sizeof(double));
	
	
	double *dmtri_prop_n_paral;
	double *dmtri_prop_prop;

	dmtri_prop_n_paral = (double*)calloc(1, sizeof(double));
	dmtri_prop_prop    = (double*)calloc(1, sizeof(double));

	
	double *logpost_prop;
	double *logpost_n_paral;

	logpost_prop    = (double*)calloc(1, sizeof(double));
	logpost_n_paral = (double*)calloc(1, sizeof(double));


	/*************************************************************************************************************/
	/* step 0 : initialisation                                                                                   */
	/*************************************************************************************************************/

	for (n_paral = 0; n_paral < N_paral; n_paral++)
	{
		n_paral_N_total = n_paral*N_total;

		tau[n_paral] = TAU_POST[n_paral_N_total];
		log_tau[n_paral] = log(tau[n_paral]);

		for (l = 0; l < 2; l++)
		{
			l_N_paral = l*N_paral;
			gamma_vect[(l_N_paral + n_paral)]     = GAMMA_VECT_POST[(l_N_paral*N_total + n_paral_N_total)];
			log_gamma_vect[(l_N_paral + n_paral)] = log(gamma_vect[(l_N_paral + n_paral)]);
		}

		for (l = 0; l < 4; l++)
		{
			l_N_paral = l*N_paral;
			l_N_paral_N_total = l_N_paral*N_total;

			lpk_mean[(l_N_paral + n_paral)] = LPK_MEAN_POST[(l_N_paral_N_total + n_paral_N_total)];
		}

		for (l = 0; l < 3; l++)
		{
			l_N_paral = l*N_paral;
			l_N_paral_N_total = l_N_paral*N_total;

			lpk_tau[(l_N_paral + n_paral)]  = LPK_TAU_POST[(l_N_paral_N_total + n_paral_N_total)];
			log_lpk_tau[(l_N_paral + n_paral)]  = log(lpk_tau[(l_N_paral + n_paral)]);
			
			for (i = 0; i < I; i++)
			{
				i_N_paral_three = i*N_paral_three;
				i_N_paral_N_total_three = i_N_paral_three*N_total;

				lpk_vect[(i_N_paral_three + l_N_paral + n_paral)] = LPK_VECT_POST[(i_N_paral_N_total_three + l_N_paral_N_total + n_paral_N_total)];
			}
		}
	}

	for (i = 0; i < I; i++)
	{
		i_N_paral_three = i*N_paral_three;
		for (l = 0; l < 3; l++)
		{
			l_N_paral = l*N_paral;
			mean_lpk_vect_int = 0.0;
			var_lpk_vect_int = 0.0;
			for (n_paral = 0; n_paral < N_paral; n_paral++)
			{
				mean_lpk_vect_int += lpk_vect[(i_N_paral_three + l_N_paral + n_paral)];
				var_lpk_vect_int += lpk_vect[(i_N_paral_three + l_N_paral + n_paral)]*lpk_vect[(i_N_paral_three + l_N_paral + n_paral)];
			}
			mean_lpk_vect_int *= 1.0/((double) N_paral);
			var_lpk_vect_int -= (((double) N_paral)*mean_lpk_vect_int*mean_lpk_vect_int);
			var_lpk_vect_int *= 1.0/(((double) N_paral) - 1);
			if ((*rotation) > 0.0)
			{
				inv_sd_lpk_vect_int = 1.0/sqrt(var_lpk_vect_int);
			} else
			{
				inv_sd_lpk_vect_int = 1.0;
			}
			for (n_paral = 0; n_paral < N_paral; n_paral++)
			{
				z[(i_N_paral_three + l_N_paral + n_paral)] = (lpk_vect[(i_N_paral_three + l_N_paral + n_paral)]  - mean_lpk_vect_int)*inv_sd_lpk_vect_int;
			}
		}
	}


	for (n_iteration = 1; n_iteration < N_iteration; n_iteration++)
	{
	
		/*********************************************************************************************************/
		/* step 1 : loop on N_iteration  &  loop on N_paral                                                      */
		/*********************************************************************************************************/

		for (n_paral = 0; n_paral < N_paral; n_paral++)
		{
			/*****************************************************************************************************/
			/* step 1-1 : n_paral components                                                                     */
			/*****************************************************************************************************/
	
			tau_n_paral     = tau[n_paral];
			log_tau_n_paral = log_tau[n_paral];
			
			for (l = 0; l < 2; l++)
			{
				l_N_paral = l*N_paral;
				gamma_vect_n_paral[l]     = gamma_vect[(l_N_paral + n_paral)];
				log_gamma_vect_n_paral[l] = log_gamma_vect[(l_N_paral + n_paral)];
			}
					
			for (l = 0; l < 4; l++)
			{
				lpk_mean_n_paral[l] = lpk_mean[(l*N_paral + n_paral)];
			}

			for (l = 0; l < 3; l++)
			{
				l_N_paral = l*N_paral;
				lpk_tau_n_paral[l]  = lpk_tau[(l_N_paral + n_paral)];
				log_lpk_tau_n_paral[l] = log_lpk_tau[(l_N_paral + n_paral)];
				
				for (i = 0; i < I; i++)
				{
					lpk_vect_n_paral[(i*3 + l)] = lpk_vect[(i*N_paral_three + l_N_paral + n_paral)];
					z_n_paral[(i*3 + l)] = z[(i*N_paral_three + l_N_paral + n_paral)];
				}
			}

			/*****************************************************************************************************/
			/* step 1-2 : basis elements for the mixture of triangular dist & expoential dist                    */
			/*****************************************************************************************************/

			k = 0;
			for (j = 0; j < N_paral; j++)
			{
				if (((j - n_paral) < 0)|((j - n_paral) > 0))
				{
					log_tau_x[k]   = log_tau[j];
				
					for (l = 0; l < 2; l++)
					{
						log_gamma_vect_x[(l*N_paral_minus_one + k)] = log_gamma_vect[(l*N_paral + j)];
					}

					for (l = 0; l < 4; l++)
					{
						lpk_mean_x[(l*N_paral_minus_one + k)] = lpk_mean[(l*N_paral + j)];
					}

					for (l = 0; l < 3; l++)
					{
						l_N_paral = l*N_paral;
						l_N_paral_minus_one = l*N_paral_minus_one;
						log_lpk_tau_x[(l_N_paral_minus_one + k)]  = log_lpk_tau[(l_N_paral + j)];
					
						for (i = 0; i < I; i++)
						{
							z_x[(i*N_paral_minus_one_three + l_N_paral_minus_one + k)] = z[(i*N_paral_three + l_N_paral + j)];
						}
					}

					k += 1;
				}
			}

			
			/*****************************************************************************************************/
			/* step 1-3 : proposal & density for the proposal                                                    */
			/*****************************************************************************************************/
			

			R_rsort(log_tau_x, N_paral_minus_one);
			rmtri(log_tau_x, N_paral, log_tau_prop);
			tau_prop = exp((*log_tau_prop));
			dmtri(log_tau_x, N_paral, log_tau_n_paral, dmtri_prop_log_tau_n_paral);
			dmtri(log_tau_x, N_paral, (*log_tau_prop), dmtri_prop_log_tau_prop);
			
			for (l = 0; l < 2; l++)
			{
				l_N_paral_minus_one = l*N_paral_minus_one;
				for (k = 0; k < N_paral_minus_one; k++)
				{
					log_gamma_vect_x_int[k] = log_gamma_vect_x[(l_N_paral_minus_one + k)];
				}
				R_rsort(log_gamma_vect_x_int, N_paral_minus_one);
				rmtri(log_gamma_vect_x_int, N_paral, log_gamma_vect_prop_int);
				log_gamma_vect_prop[l] = (*log_gamma_vect_prop_int);
				gamma_vect_prop[l]     = exp(log_gamma_vect_prop[l]);
				dmtri(log_gamma_vect_x_int, N_paral, log_gamma_vect_n_paral[l], dmtri_prop_n_paral);
				dmtri(log_gamma_vect_x_int, N_paral, log_gamma_vect_prop[l], dmtri_prop_prop);
				dmtri_prop_log_gamma_vect_n_paral[l] = (*dmtri_prop_n_paral);
				dmtri_prop_log_gamma_vect_prop[l]    = (*dmtri_prop_prop);
			}

			for (l = 0; l < 4; l++)
			{
				l_N_paral_minus_one = l*N_paral_minus_one;
				for (k = 0; k < N_paral_minus_one; k++)
				{
					lpk_mean_x_int[k] = lpk_mean_x[(l_N_paral_minus_one + k)];
				}
				R_rsort(lpk_mean_x_int, N_paral_minus_one);
				rmtri(lpk_mean_x_int, N_paral, lpk_mean_prop_int);
				lpk_mean_prop[l] = (*lpk_mean_prop_int);
				dmtri(lpk_mean_x_int, N_paral, lpk_mean_n_paral[l], dmtri_prop_n_paral);
				dmtri(lpk_mean_x_int, N_paral, lpk_mean_prop[l],    dmtri_prop_prop);
				dmtri_prop_lpk_mean_n_paral[l] = (*dmtri_prop_n_paral);
				dmtri_prop_lpk_mean_prop[l]    = (*dmtri_prop_prop);
			}

			for (l = 0; l < 3; l++)
			{
				l_N_paral_minus_one = l*N_paral_minus_one;
				for (k = 0; k < N_paral_minus_one; k++)
				{
					log_lpk_tau_x_int[k] = log_lpk_tau_x[(l_N_paral_minus_one + k)];
				}
				R_rsort(log_lpk_tau_x_int, N_paral_minus_one);
				rmtri(log_lpk_tau_x_int, N_paral, log_lpk_tau_prop_int);
				log_lpk_tau_prop[l] = (*log_lpk_tau_prop_int);
				lpk_tau_prop[l] = exp(log_lpk_tau_prop[l]);
				dmtri(log_lpk_tau_x_int, N_paral, log_lpk_tau_n_paral[l], dmtri_prop_n_paral);
				dmtri(log_lpk_tau_x_int, N_paral, log_lpk_tau_prop[l],    dmtri_prop_prop);
				dmtri_prop_log_lpk_tau_n_paral[l] = (*dmtri_prop_n_paral);
				dmtri_prop_log_lpk_tau_prop[l]    = (*dmtri_prop_prop);
			}
			
			for (l = 0; l < 3; l++)
			{
				l_N_paral_minus_one = l*N_paral_minus_one;
				for (i = 0; i < I; i++)
				{
					i_three_plus_l = i*3 + l;
					for (k = 0; k < N_paral_minus_one; k++)
					{
						z_x_int[k] = z_x[(i*N_paral_minus_one_three + l_N_paral_minus_one + k)];
					}
					R_rsort(z_x_int, N_paral_minus_one);
					rmtri(z_x_int, N_paral, z_prop_int);
					z_prop[i_three_plus_l] = (*z_prop_int);
					dmtri(z_x_int, N_paral, z_n_paral[i_three_plus_l], dmtri_prop_n_paral);
					dmtri(z_x_int, N_paral, z_prop[i_three_plus_l],    dmtri_prop_prop);
					dmtri_prop_z_n_paral[i_three_plus_l] = (*dmtri_prop_n_paral);
					dmtri_prop_z_prop[i_three_plus_l]    = (*dmtri_prop_prop);
				}
			}


			/*****************************************************************************************************/
			/* step 1-4 : update of the parameters                                                               */
			/*****************************************************************************************************/

				/*************************************************************************************************/
				/* gamma_vect                                                                                    */
				/*************************************************************************************************/
				
				lpost_tau_gamma_lkcp(N, I, I_moins_un_demi,
									 M1, M2, M, M_sq,
									 prec_c_prior, prec_c_prior_mu_c_prior,
									 P_11, P_10, P_01, P_00, P_0110,
									 *sum_y_sq, tBB, tBy,
									 mu_lpk, prec_lpk,
									 a_tau_post_moins_un, b_tau,
									 a_gamma_vect_moins_un, b_gamma_vect,
									 tau_n_paral, log_tau_n_paral,
									 gamma_vect_n_paral, log_gamma_vect_n_paral,
									 gamma_vect_n_paral, log_gamma_vect_n_paral, 0,
									 lpk_mean_n_paral, lpk_mean_n_paral,
									 lpk_vect_n_paral,
									 logpost_n_paral);
				
				for (l = 0; l < 2; l++)
				{
					lpost_tau_gamma_lkcp(N, I, I_moins_un_demi,
										 M1, M2, M, M_sq,
										 prec_c_prior, prec_c_prior_mu_c_prior,
										 P_11, P_10, P_01, P_00, P_0110,
										 *sum_y_sq, tBB, tBy,
										 mu_lpk, prec_lpk,
										 a_tau_post_moins_un, b_tau,
										 a_gamma_vect_moins_un, b_gamma_vect,
										 tau_n_paral, log_tau_n_paral,
										 gamma_vect_prop,    log_gamma_vect_prop,
										 gamma_vect_n_paral, log_gamma_vect_n_paral, l,
										 lpk_mean_n_paral, lpk_mean_n_paral,
										 lpk_vect_n_paral,
										 logpost_prop);

					prob = exp((*logpost_prop) + log_gamma_vect_prop[l] - log(dmtri_prop_log_gamma_vect_prop[l]) -
							   (*logpost_n_paral) - log_gamma_vect_n_paral[l] + log(dmtri_prop_log_gamma_vect_n_paral[l]));

					GetRNGstate();
					u = runif(0.0, 1.0);
					PutRNGstate();
					
					if (u <= prob)
					{
						log_gamma_vect_n_paral[l] = log_gamma_vect_prop[l];
						gamma_vect_n_paral[l] = gamma_vect_prop[l];
						n_accept_gamma_vect[(l*N_paral + n_paral)] += 1;
						(*logpost_n_paral) = (*logpost_prop);
					}
				}

				/*************************************************************************************************/
				/* tau                                                                                           */
				/*************************************************************************************************/
				
				lpost_tau_gamma_lkcp(N, I, I_moins_un_demi,
									 M1, M2, M, M_sq,
									 prec_c_prior, prec_c_prior_mu_c_prior,
									 P_11, P_10, P_01, P_00, P_0110,
									 *sum_y_sq, tBB, tBy,
									 mu_lpk, prec_lpk,
									 a_tau_post_moins_un, b_tau,
									 a_gamma_vect_moins_un, b_gamma_vect,
									 tau_prop, (*log_tau_prop),
									 gamma_vect_n_paral, log_gamma_vect_n_paral,
									 gamma_vect_n_paral, log_gamma_vect_n_paral, 0,
									 lpk_mean_n_paral, lpk_mean_n_paral,
									 lpk_vect_n_paral,
									 logpost_prop);

				prob = exp((*logpost_prop) + (*log_tau_prop) - log((*dmtri_prop_log_tau_prop)) -
						   (*logpost_n_paral) - log_tau_n_paral + log((*dmtri_prop_log_tau_n_paral)));

				GetRNGstate();
				u = runif(0.0, 1.0);
				PutRNGstate();
				
				if (u <= prob)
				{
					log_tau_n_paral = (*log_tau_prop);
					tau_n_paral = tau_prop;
					n_accept_tau[n_paral] += 1;
					(*logpost_n_paral) = (*logpost_prop);
				}

				/*************************************************************************************************/
				/* lpk_mean[0] (lkcp)                                                                            */
				/*************************************************************************************************/
				
				lpost_tau_gamma_lkcp(N, I, I_moins_un_demi,
									 M1, M2, M, M_sq,
									 prec_c_prior, prec_c_prior_mu_c_prior,
									 P_11, P_10, P_01, P_00, P_0110,
									 *sum_y_sq, tBB, tBy,
									 mu_lpk, prec_lpk,
									 a_tau_post_moins_un, b_tau,
									 a_gamma_vect_moins_un, b_gamma_vect,
									 tau_n_paral, log_tau_n_paral,
									 gamma_vect_n_paral, log_gamma_vect_n_paral,
									 gamma_vect_n_paral, log_gamma_vect_n_paral, 0,
									 lpk_mean_prop, lpk_mean_n_paral,
									 lpk_vect_n_paral,
									 logpost_prop);

				prob = exp((*logpost_prop) - log(dmtri_prop_lpk_mean_prop[0]) -
						   (*logpost_n_paral) + log(dmtri_prop_lpk_mean_n_paral[0]));

				GetRNGstate();
				u = runif(0.0, 1.0);
				PutRNGstate();
				
				if (u <= prob)
				{
					lpk_mean_n_paral[0] = lpk_mean_prop[0];
					n_accept_lpk_mean[n_paral] += 1;
				}

				/*************************************************************************************************/
				/* lpk_mean                                                                                      */
				/*************************************************************************************************/

				lpost_lpk_mean(I,
							   mu_lpk, prec_lpk,
							   a_tau_lpk_post, b_tau_lpk, max_tau_lpk,
							   lpk_mean_n_paral, lpk_mean_n_paral, 0,
							   lpk_vect_n_paral,
							   logpost_n_paral);
							   
				for (l = 1; l < 4; l++)
				{
					lpost_lpk_mean(I,
								   mu_lpk, prec_lpk,
								   a_tau_lpk_post, b_tau_lpk, max_tau_lpk,
								   lpk_mean_prop, lpk_mean_n_paral, l,
								   lpk_vect_n_paral,
								   logpost_prop);
					
					prob = exp((*logpost_prop) - log(dmtri_prop_lpk_mean_prop[l]) -
							   (*logpost_n_paral) + log(dmtri_prop_lpk_mean_n_paral[l]));

					GetRNGstate();
					u = runif(0.0, 1.0);
					PutRNGstate();
				
					if (u <= prob)
					{
						lpk_mean_n_paral[l] = lpk_mean_prop[l];
						n_accept_lpk_mean[(l*N_paral + n_paral)] += 1;
						(*logpost_n_paral) = (*logpost_prop);
					}
				}

				/*************************************************************************************************/
				/* lpk_tau                                                                                       */
				/*************************************************************************************************/
				
				lpost_lpk_tau(I, double_I,
							  mu_lpk, prec_lpk,
							  a_tau_lpk_post_moins_un, b_tau_lpk, max_tau_lpk,
							  lpk_tau_n_paral, log_lpk_tau_n_paral,
							  lpk_tau_n_paral, log_lpk_tau_n_paral,
							  0,
							  lpk_vect_n_paral,
							  logpost_n_paral);

				for (l = 0; l < 3; l++)
				{
					lpost_lpk_tau(I, double_I,
								  mu_lpk, prec_lpk,
								  a_tau_lpk_post_moins_un, b_tau_lpk, max_tau_lpk,
								  lpk_tau_prop, log_lpk_tau_prop,
								  lpk_tau_n_paral, log_lpk_tau_n_paral,
								  l,
								  lpk_vect_n_paral,
								  logpost_prop);

					prob = exp((*logpost_prop) + log_lpk_tau_prop[l] - log(dmtri_prop_log_lpk_tau_prop[l]) -
							   (*logpost_n_paral) - log_lpk_tau_n_paral[l] + log(dmtri_prop_log_lpk_tau_n_paral[l]));

					GetRNGstate();
					u = runif(0.0, 1.0);
					PutRNGstate();

					if (u <= prob)
					{
						lpk_tau_n_paral[l] = lpk_tau_prop[l];
						log_lpk_tau_n_paral[l] = log_lpk_tau_prop[l];
						n_accept_lpk_tau[(l*N_paral + n_paral)] += 1;
						(*logpost_n_paral) = (*logpost_prop);
					}
				}

				/*************************************************************************************************/
				/* lpk_vect                                                                                      */
				/*************************************************************************************************/
				
				for (i = 0; i < I; i++)
				{
					i_three = i*3;
					i_nine = i*9;
					i_N_paral_three = i*N_paral_three;

					lpost_lpk_vect(N, I, I_three,
								   M1, M2, M, M_sq,
								   prec_c_prior, prec_c_prior_mu_c_prior,
								   P_11, P_10, P_01, P_00, P_0110,
								   tBB, tBy,
								   tau_n_paral,
								   gamma_vect_n_paral,
								   lpk_mean_n_paral, a_tau_lpk_post, b_tau_lpk, max_tau_lpk,
								   i, lpk_vect_n_paral, lpk_vect_n_paral,
								   logpost_n_paral);
								   
					for(l = 0; l < 3; l++)
					{
						i_nine_plus_l_three = i_nine + l*3;
						i_three_plus_l = i_three + l;
						
						for (k = 0; k < 3; k++)
						{
							lpk_vect_prop[(i_three + k)] = lpk_vect_n_paral[(i_three + k)] +
														   z_prop[i_three_plus_l]*t_chol_var_lpk_vect[(i_nine_plus_l_three + k)];
						}

						lpost_lpk_vect(N, I, I_three,
									   M1, M2, M, M_sq,
									   prec_c_prior, prec_c_prior_mu_c_prior,
									   P_11, P_10, P_01, P_00, P_0110,
									   tBB, tBy,
									   tau_n_paral,
									   gamma_vect_n_paral,
									   lpk_mean_n_paral, a_tau_lpk_post, b_tau_lpk, max_tau_lpk,
									   i, lpk_vect_prop, lpk_vect_n_paral,
									   logpost_prop);
					
						prob = exp((*logpost_prop) - log(dmtri_prop_z_prop[i_three_plus_l]) -
								   (*logpost_n_paral) + log(dmtri_prop_z_n_paral[i_three_plus_l]));

						GetRNGstate();
						u = runif(0.0, 1.0);
						PutRNGstate();
				
						if (u <= prob)
						{
							for (k = 0; k < 3;  k++)
							{
								lpk_vect_n_paral[(i_three + k)] = lpk_vect_prop[(i_three + k)];
							}
							z_n_paral[i_three_plus_l] = z_prop[i_three_plus_l];
							n_accept_lpk_vect[(i_N_paral_three + l*N_paral + n_paral)] += 1;
							(*logpost_n_paral) = (*logpost_prop);
						}
					}
				}

			/*****************************************************************************************************/
			/* step 1-5 : storage of the n_paral component                                                       */
			/*****************************************************************************************************/
			
			tau[n_paral]     = tau_n_paral;
			log_tau[n_paral] = log_tau_n_paral;
			
			for (l = 0; l < 2; l++)
			{
				gamma_vect[(l*N_paral + n_paral)]     = gamma_vect_n_paral[l];
				log_gamma_vect[(l*N_paral + n_paral)] = log_gamma_vect_n_paral[l];

			}
			
			for (l = 0; l < 4; l++)
			{
				lpk_mean[(l*N_paral + n_paral)] = lpk_mean_n_paral[l];
			}

			for (l = 0; l < 3; l++)
			{
				l_N_paral = l*N_paral;
				lpk_tau[(l_N_paral + n_paral)] = lpk_tau_n_paral[l];
				log_lpk_tau[(l_N_paral + n_paral)] = log_lpk_tau_n_paral[l];
				
				for (i = 0; i < I; i++)
				{
					lpk_vect[(i*N_paral_three + l_N_paral + n_paral)] = lpk_vect_n_paral[(i*3 + l)];
					z[(i*N_paral_three + l_N_paral + n_paral)] = z_n_paral[(i*3 + l)];
				}
			}
		}

		/*********************************************************************************************************/
		/* step 2 : storage of the updated parameters                                                            */
		/*********************************************************************************************************/
		
		if ((n_iteration >= N_burnin)  & (thin_intermed >= N_thin))
		{
			for (n_paral = 0; n_paral < N_paral; n_paral++)
			{
				n_paral_N_total = n_paral*N_total;
				n_paral_N_total_plus_indice_stockage = n_paral_N_total + indice_stockage;

				TAU_POST[n_paral_N_total_plus_indice_stockage] = tau[n_paral];

				for (l = 0; l < 2; l++)
				{
					GAMMA_VECT_POST[(l*N_paral_N_total + n_paral_N_total + indice_stockage)] = gamma_vect[(l*N_paral + n_paral)];
				}

				for (l = 0; l < 4; l++)
				{
					l_N_paral = l*N_paral;
					l_N_paral_N_total = l_N_paral*N_total;
					
					LPK_MEAN_POST[(l_N_paral_N_total + n_paral_N_total + indice_stockage)] = lpk_mean[(l_N_paral + n_paral)];
				}

				for (l = 0; l < 3; l++)
				{
					l_N_paral = l*N_paral;
					l_N_paral_N_total = l_N_paral*N_total;
					
					LPK_TAU_POST[(l_N_paral_N_total + n_paral_N_total + indice_stockage)]  = lpk_tau[(l_N_paral + n_paral)];
					
					for (i = 0; i < I; i++)
					{
						i_N_paral_three = i*N_paral_three;
						LPK_VECT_POST[(i_N_paral_three*N_total + l_N_paral_N_total + n_paral_N_total + indice_stockage)] = lpk_vect[(i_N_paral_three + l_N_paral + n_paral)];
					}
				}
			}
			thin_intermed = 0;
			indice_stockage +=1 ;
		}
		thin_intermed += 1;
	}

	free(logpost_prop);
	free(logpost_n_paral);
	
	free(a_gamma_vect_moins_un);
	free(b_gamma_vect);

	free(mu_lpk);
	free(prec_lpk);
	free(a_tau_lpk_post);
	free(a_tau_lpk_post_moins_un);
	free(b_tau_lpk);
	
	free(gamma_vect);
	free(log_gamma_vect);
	free(log_gamma_vect_x);
	free(log_gamma_vect_x_int);
	free(log_gamma_vect_n_paral);
	free(log_gamma_vect_prop);
	free(log_gamma_vect_prop_int);
	free(gamma_vect_n_paral);
	free(gamma_vect_prop);
	free(dmtri_prop_log_gamma_vect_prop);
	free(dmtri_prop_log_gamma_vect_n_paral);

	free(tau);
	free(log_tau);
	free(log_tau_x);
	free(log_tau_prop);
	free(dmtri_prop_log_tau_prop);
	free(dmtri_prop_log_tau_n_paral);
	
	free(lpk_mean);
	free(lpk_mean_x);
	free(lpk_mean_x_int);
	free(lpk_mean_prop);
	free(lpk_mean_prop_int);
	free(lpk_mean_n_paral);
	free(dmtri_prop_lpk_mean_prop);
	free(dmtri_prop_lpk_mean_n_paral);

	free(lpk_tau);
	free(log_lpk_tau);
	free(log_lpk_tau_x);
	free(log_lpk_tau_x_int);
	free(lpk_tau_prop);
	free(log_lpk_tau_prop_int);
	free(log_lpk_tau_prop);
	free(lpk_tau_n_paral);
	free(log_lpk_tau_n_paral);
	free(dmtri_prop_log_lpk_tau_prop);
	free(dmtri_prop_log_lpk_tau_n_paral);

	free(lpk_vect);
	free(lpk_vect_prop);
	free(lpk_vect_n_paral);
	
	free(z);
	free(z_x);
	free(z_x_int);
	free(z_prop);
	free(z_prop_int);
	free(z_n_paral);
	free(dmtri_prop_z_prop);
	free(dmtri_prop_z_n_paral);

	free(dmtri_prop_n_paral);
	free(dmtri_prop_prop);
}