###################################################################################################################
###################################################################################################################
##                                                                                                               ##
##   Indometh dataset - One-compartment IV bolus model vs Two-compartment IV bolus model                         ##
##   by Jaeger Jonathan , Universit de Lige, Belgium                                                          ##
##   10/05/2012                                                                                                  ##
##                                                                                                               ##
###################################################################################################################
###################################################################################################################

#--------------------------------------------------- directory ---------------------------------------------------#

#   directory <- "C:/Users/Jonathan/Google Drive/code_indometh/"
   directory <- "C:/Users/ULg/Google Drive/code_indometh/"
   setwd(directory)


#--------------------------------------------------- packages ----------------------------------------------------#

   require(lattice)
   require(R2WinBUGS)
   require(coda)
   require(nlme)
   require(splines)
   require(msm)


#------------------------------------------------------ plot -----------------------------------------------------#

   data(Indometh)

   y <- Indometh$conc
   t <- Indometh$time
   subject <- as.numeric(Indometh$Subject)
   dose <- 25

   par(mfrow = c(1, 1), mar = c(5, 5, 1, 1), cex = 1)
   plot(y ~ t, xlab = "time", ylab = "concentration", type = "n")
   for (i in unique(subject))
   {
      lines(y[subject == i] ~ t[subject == i], type = "b", lty = i, lwd = 2)
   }




#-----------------------------------------------------------------------------------------------------------------#
#-----------------------------------------------------------------------------------------------------------------#
#                                                                                                                 #
#              Bayesian analysis with B-ODE-P-spline and gaussian error distribution // 1cmp IV bolus             #
#                                                                                                                 #
#-----------------------------------------------------------------------------------------------------------------#
#-----------------------------------------------------------------------------------------------------------------#

   y <- Indometh$conc
   time <- Indometh$time
   subject <- as.numeric(as.character(Indometh$Subject))
   T <- max(time)

   I <- length(unique(subject))
   N <- dim(Indometh)[1]/I


   #---------------------------------- knots, spline basis & elementary matrices ---------------------------------#

      order <- 6
      degree <- order - 1

      knots.intermed <- seq(0, 8, by = 0.5)
      knots <- c(rep(min(knots.intermed),degree),
                 knots.intermed,
                 rep(max(knots.intermed),degree))

      M <- length(knots.intermed) - 2 + order

      B <- splineDesign(knots,
                        unique(time),
                        ord = order,
                        derivs = rep(0, length(unique(time))))
      tBB <- t(B)%*%B

      sum_y <- sum(y)
      sum_y_sq <- sum(y*y)
      tBy <- numeric(I*M)
      for (i in 1:I)
      {
         tBy[((i-1)*M + (1:M))] <- t(B)%*%y[(i-1)*N + (1:N)]
      }

      length_x_ <- 100000
      x_ <- seq(0, T, length=length_x_)
      delta_x_ <- x_[2] - x_[1]
      x_tilde <- (x_[1:(length_x_-1)] + x_[2:length_x_])/2

      B_0_intermed <- splineDesign(knots,
                                   x_tilde,
                                   ord = order,
                                   derivs = rep(0, length(x_tilde)))
      B_1_intermed <- splineDesign(knots,
                                   x_tilde,
                                   ord = order,
                                   derivs = rep(1, length(x_tilde)))

      P_11 <- t(B_1_intermed)%*%B_1_intermed*delta_x_
      P_10 <- t(B_1_intermed)%*%B_0_intermed*delta_x_
      P_01 <- t(B_0_intermed)%*%B_1_intermed*delta_x_
      P_00 <- t(B_0_intermed)%*%B_0_intermed*delta_x_
      P_0110 <- P_01 + P_10


   #-------------------------------------------------- storage ---------------------------------------------------#

      #-------------------------------------------------- run1 ---------------------------------------------------#

         N_burnin_1_1    <- 1000
         N_iteration_1_1 <- 2000
         N_thin_1_1      <- 10
         N_total_1_1     <- ceiling((N_iteration_1_1 - N_burnin_1_1)/N_thin_1_1)
         N_paral_1_1     <- 20


         tau_post_1_1      <- array(0,
                                    dim = c(N_total_1_1, N_paral_1_1))
         gamma_post_1_1    <- array(0,
                                    dim = c(N_total_1_1, N_paral_1_1))
         lpk_mean_post_1_1 <- array(0,
                                    dim = c(N_total_1_1, N_paral_1_1, 2))
         lpk_tau_post_1_1  <- array(0,
                                    dim = c(N_total_1_1, N_paral_1_1, 2))
         lpk_vect_post_1_1 <- array(0,
                                    dim = c(N_total_1_1, N_paral_1_1, 2, I))
         c_post_1_1        <- array(0,
                                    dim = c(N_total_1_1, N_paral_1_1, M, I))


      #-------------------------------------------------- run2 ---------------------------------------------------#

         N_burnin_1_2    <- 2000
         N_iteration_1_2 <- 7000
         N_thin_1_2      <- 5
         N_total_1_2     <- ceiling((N_iteration_1_2 - N_burnin_1_2)/N_thin_1_2)
         N_paral_1_2     <- N_paral_1_1


         tau_post_1_2      <- array(0,
                                    dim = c(N_total_1_2, N_paral_1_2))
         gamma_post_1_2    <- array(0,
                                    dim = c(N_total_1_2, N_paral_1_2))
         lpk_mean_post_1_2 <- array(0,
                                    dim = c(N_total_1_2, N_paral_1_2, 2))
         lpk_tau_post_1_2  <- array(0,
                                    dim = c(N_total_1_2, N_paral_1_2, 2))
         lpk_vect_post_1_2 <- array(0,
                                    dim = c(N_total_1_2, N_paral_1_2, 2, I))
         c_post_1_2        <- array(0,
                                    dim = c(N_total_1_2, N_paral_1_2, M, I))


   #-------------------------------------------- hyperprior parameters -------------------------------------------#

      a_tau <- 1e-3
      b_tau <- 1e-3

      a_gamma <- 1e0
      b_gamma <- 1e-8


      a_tau_lke   <- 1e0
      b_tau_lke   <- 1e-3
      a_tau_lV    <- 1e0
      b_tau_lV    <- 1e-3
      max_tau_lpk <- 1e5


      mu_lke   <- 0.0
      prec_lke <- 1e-2
      mu_lV    <- 0.0
      prec_lV  <- 1e-2


      param_1 <- c(a_tau, b_tau,
                   a_gamma, b_gamma,
                   a_tau_lke, b_tau_lke,
                   a_tau_lV,  b_tau_lV,
                   max_tau_lpk,
                   mu_lke, prec_lke,
                   mu_lV,  prec_lV)


      prec_c_prior <- array(0, dim = c(M, M))
      mu_c_prior <- numeric(M)
      prec_c_prior[1:M, 1:M] <- diag(c(1e8, rep(0, M - 1)))
      mu_c_prior[1:M] <- c(dose, rep(0, M - 1))
      prec_c_prior_mu_c_prior <- prec_c_prior%*%mu_c_prior


   #-------------------------------- Metropolis-Hastings with adaptive proposals ---------------------------------#

      #-----------------------------------------------------------------------------------------------------------#
      #-------------------------------------------------- run1 ---------------------------------------------------#
      #-----------------------------------------------------------------------------------------------------------#

         #------------------------------- Initialization of the parameter's chains -------------------------------#

            tau_post_1_1[1, ] <- 10^rnorm(N_paral_1_1, 1.7, 0.2)

            gamma_post_1_1[1, ] <- 10^seq(1, 8, length = N_paral_1_1)

            lpk_mean_post_1_1[1, , 1] <- rnorm(N_paral_1_1, 0.30, 0.1)
            lpk_mean_post_1_1[1, , 2] <- rnorm(N_paral_1_1, 2.20, 0.1)

            lpk_tau_post_1_1[1, , 1] <- 10^rnorm(N_paral_1_1, 2.1, 0.6)
            lpk_tau_post_1_1[1, , 2] <- 10^rnorm(N_paral_1_1, 2.1, 0.3)

            for (i in 1:I)
            {
               lpk_vect_post_1_1[1, , 1, i] <- rnorm(N_paral_1_1, 0.3, 0.1)
               lpk_vect_post_1_1[1, , 2, i] <- rnorm(N_paral_1_1, 2.2, 0.1)
            }


         #----------------------------------------------- n_accept -----------------------------------------------#

            n_accept_tau       <- rep(0, N_paral_1_1)
            n_accept_gamma     <- rep(0, N_paral_1_1)
            n_accept_lpk_mean  <- rep(0, N_paral_1_1*2)
            n_accept_lpk_tau   <- rep(0, N_paral_1_1*2)
            n_accept_lpk_vect  <- rep(0, N_paral_1_1*2*I)


        #----------------------------------------- appel de la fonction C ----------------------------------------#

            all_integer_1_1 <- c(N, I,
                                 M,
                                 N_iteration_1_1, N_burnin_1_1, N_thin_1_1, N_total_1_1, N_paral_1_1)

            t_chol_var_lpk_vect_1_1 <- array(0,
                                             dim = c(2, I*2))
            for (i in 1:I)
            {
               t_chol_var_lpk_vect_1_1[1:2, (i - 1)*2 + 1:2] <- diag(c(1, 1))
            }
            rotation_1_1 <- -1.0

            dyn.load(paste(directory,"codeC_one_cmp_IV_bolus/codeC.dll",sep=""))

            metropolis_within_gibbs_1_1 <- .C("metropolis_within_gibbs",
                                              n_accept_gamma = as.integer(n_accept_gamma),
                                              n_accept_tau = as.integer(n_accept_tau),
                                              n_accept_lpk_vect = as.integer(n_accept_lpk_vect),
                                              n_accept_lpk_mean = as.integer(n_accept_lpk_mean),
                                              n_accept_lpk_tau = as.integer(n_accept_lpk_tau),
                                              as.double(param_1), as.integer(all_integer_1_1),
                                              as.double(prec_c_prior), as.double(prec_c_prior_mu_c_prior),
                                              as.double(P_11), as.double(P_00), as.double(P_0110),
                                              as.double(t_chol_var_lpk_vect_1_1), as.double(rotation_1_1),
                                              as.double(sum_y_sq), as.double(tBB), as.double(tBy),
                                              tau = as.double(tau_post_1_1),
                                              gamma = as.double(gamma_post_1_1),
                                              lpk_mean = as.double(lpk_mean_post_1_1),
                                              lpk_tau = as.double(lpk_tau_post_1_1),
                                              lpk_vect = as.double(lpk_vect_post_1_1))

            dyn.unload(paste(directory,"codeC_one_cmp_IV_bolus/codeC.dll",sep=""))


         #-------------------------------------------- exclude burnin --------------------------------------------#

            tau_post_1_1[] <- metropolis_within_gibbs_1_1$tau

            gamma_post_1_1[] <- metropolis_within_gibbs_1_1$gamma

            lpk_vect_post_1_1[] <- metropolis_within_gibbs_1_1$lpk_vect
            lpk_mean_post_1_1[] <- metropolis_within_gibbs_1_1$lpk_mean
            lpk_tau_post_1_1[]  <- metropolis_within_gibbs_1_1$lpk_tau


      #-----------------------------------------------------------------------------------------------------------#
      #-------------------------------------------------- run2 ---------------------------------------------------#
      #-----------------------------------------------------------------------------------------------------------#

         #------------------------------- Initialization of the parameter's chains -------------------------------#

            tau_post_1_2[1, ] <- 10^apply(log10(tau_post_1_1), 2, mean)

            gamma_post_1_2[1, ] <- 10^seq(1, 8, length = N_paral_1_2)

            lpk_mean_post_1_2[1, , 1] <- apply(lpk_mean_post_1_1[, , 1], 2, mean)
            lpk_mean_post_1_2[1, , 2] <- apply(lpk_mean_post_1_1[, , 2], 2, mean)

            lpk_tau_post_1_2[1, , 1] <- 10^apply(log10(lpk_tau_post_1_1[, , 1]), 2, mean)
            lpk_tau_post_1_2[1, , 2] <- 10^apply(log10(lpk_tau_post_1_1[, , 1]), 2, mean)

            for (i in 1:I)
            {
               lpk_vect_post_1_2[1, , 1, i] <- apply(lpk_vect_post_1_1[, , 1, i], 2, mean)
               lpk_vect_post_1_2[1, , 2, i] <- apply(lpk_vect_post_1_1[, , 2, i], 2, mean)
            }


         #----------------------------------------------- n_accept -----------------------------------------------#

            n_accept_tau       <- rep(0, N_paral_1_2)
            n_accept_gamma     <- rep(0, N_paral_1_2)
            n_accept_lpk_mean  <- rep(0, N_paral_1_2*2)
            n_accept_lpk_tau   <- rep(0, N_paral_1_2*2)
            n_accept_lpk_vect  <- rep(0, N_paral_1_2*2*I)


        #----------------------------------------- appel de la fonction C ----------------------------------------#

            all_integer_1_2 <- c(N, I,
                                 M,
                                 N_iteration_1_2, N_burnin_1_2, N_thin_1_2, N_total_1_2, N_paral_1_2)

            t_chol_var_lpk_vect_1_2 <- array(0,
                                             dim = c(2, I*2))
            for (i in 1:I)
            {
               t_chol_var_lpk_vect_1_2[1:2, (i - 1)*2 + 1:2] <- t(chol(var(cbind(as.numeric(lpk_vect_post_1_1[, , 1, i]),
                                                                                 as.numeric(lpk_vect_post_1_1[, , 2, i])))))
            }
            rotation_1_2 <- 1.0

            dyn.load(paste(directory,"codeC_one_cmp_IV_bolus/codeC.dll",sep=""))

            metropolis_within_gibbs_1_2 <- .C("metropolis_within_gibbs",
                                              n_accept_gamma = as.integer(n_accept_gamma),
                                              n_accept_tau = as.integer(n_accept_tau),
                                              n_accept_lpk_vect = as.integer(n_accept_lpk_vect),
                                              n_accept_lpk_mean = as.integer(n_accept_lpk_mean),
                                              n_accept_lpk_tau = as.integer(n_accept_lpk_tau),
                                              as.double(param_1), as.integer(all_integer_1_2),
                                              as.double(prec_c_prior), as.double(prec_c_prior_mu_c_prior),
                                              as.double(P_11), as.double(P_00), as.double(P_0110),
                                              as.double(t_chol_var_lpk_vect_1_2), as.double(rotation_1_2),
                                              as.double(sum_y_sq), as.double(tBB), as.double(tBy),
                                              tau = as.double(tau_post_1_2),
                                              gamma = as.double(gamma_post_1_2),
                                              lpk_mean = as.double(lpk_mean_post_1_2),
                                              lpk_tau = as.double(lpk_tau_post_1_2),
                                              lpk_vect = as.double(lpk_vect_post_1_2))

            dyn.unload(paste(directory,"codeC_one_cmp_IV_bolus/codeC.dll",sep=""))

         #-------------------------------------------- exclude burnin --------------------------------------------#

            tau_post_1_2[] <- metropolis_within_gibbs_1_2$tau

            gamma_post_1_2[] <- metropolis_within_gibbs_1_2$gamma

            lpk_vect_post_1_2[] <- metropolis_within_gibbs_1_2$lpk_vect
            lpk_mean_post_1_2[] <- metropolis_within_gibbs_1_2$lpk_mean
            lpk_tau_post_1_2[]  <- metropolis_within_gibbs_1_2$lpk_tau

      #------------------------------------------- traces & histograms -------------------------------------------#

         windows()
         par(mfrow = c(2,2), mar = c(4,5,1,1),cex = 1)

         plot(log10(as.numeric(tau_post_1_2)),type="l",
              ylab = expression(paste("log"[10],group("(",tau,")"),sep="")))
         hist(log10(as.numeric(tau_post_1_2)),breaks=20,main="",freq=F,
              xlab = expression(paste("log"[10],group("(",tau,")"),sep="")))

         plot(log10(as.numeric(gamma_post_1_2)),type="l",
              ylab = expression(paste("log"[10],group("(",gamma[21],")"),sep="")))
         hist(log10(as.numeric(gamma_post_1_2)),breaks=20,main="",freq=F,
              xlab = expression(paste("log"[10],group("(",gamma[21],")"),sep="")))



         windows()
         par(mfrow = c(2,2), mar = c(4,5,1,1), cex = 1)

         plot(as.numeric(lpk_mean_post_1_2[,,1]),type="l",
              ylab = expression(lk[e]))
         hist(as.numeric(lpk_mean_post_1_2[,,1]),breaks=20,main="",freq=F,
              xlab = expression(lk[e]))

         plot(as.numeric(lpk_mean_post_1_2[,,2]),type="l",
              ylab = expression(lV))
         hist(as.numeric(lpk_mean_post_1_2[,,2]),breaks=20,main="",freq=F,
              xlab = expression(lV))



         windows()
         par(mfrow = c(2,2),mar=c(4,5,1,1), cex = 1)

         plot(log10(as.numeric(lpk_tau_post_1_2[,,1])),type="l",
              ylab = expression(paste("log"[10],group("(",tau[lk[e]],")"),sep="")))
         hist(log10(as.numeric(lpk_tau_post_1_2[,,1])),breaks=20,main="",freq=F,
              xlab = expression(paste("log"[10],group("(",tau[lk[e]],")"),sep="")))

         plot(log10(as.numeric(lpk_tau_post_1_2[,,2])),type="l",
              ylab = expression(paste("log"[10],group("(",tau[lV],")"),sep="")))
         hist(log10(as.numeric(lpk_tau_post_1_2[,,2])),breaks=20,main="",freq=F,
              xlab = expression(paste("log"[10],group("(",tau[lV],")"),sep="")))






#-----------------------------------------------------------------------------------------------------------------#
#-----------------------------------------------------------------------------------------------------------------#
#                                                                                                                 #
#              Bayesian analysis with B-ODE-P-spline and gaussian error distribution // 2cmp IV bolus             #
#                                                                                                                 #
#-----------------------------------------------------------------------------------------------------------------#
#-----------------------------------------------------------------------------------------------------------------#

   y <- Indometh$conc
   time <- Indometh$time
   subject <- as.numeric(as.character(Indometh$Subject))
   T <- max(time)

   I <- length(unique(subject))
   N <- dim(Indometh)[1]/I


   #---------------------------------- knots, spline basis & elementary matrices ---------------------------------#

      order <- 6
      degree <- order - 1

      knots.intermed <- unique(c(seq(0, 8, by = 0.5)))
      knots <- c(rep(min(knots.intermed),degree),
                 knots.intermed,
                 rep(max(knots.intermed),degree))

      M1 <- M2 <- length(knots.intermed) - 2 + order
      M <- M1 + M2

      B <- splineDesign(knots,
                        unique(time),
                        ord = order,
                        derivs = rep(0, length(unique(time))))
      tBB <- t(B)%*%B

      sum_y <- sum(y)
      sum_y_sq <- sum(y*y)
      tBy <- numeric(I*M1)
      for (i in 1:I)
      {
         tBy[((i-1)*M1 + (1:M1))] <- t(B)%*%y[(i-1)*N + (1:N)]
      }

      length_x_ <- 100000
      x_ <- seq(0, T, length=length_x_)
      delta_x_ <- x_[2] - x_[1]
      x_tilde <- (x_[1:(length_x_-1)] + x_[2:length_x_])/2

      B_0_intermed <- splineDesign(knots,
                                   x_tilde,
                                   ord = order,
                                   derivs = rep(0, length(x_tilde)))
      B_1_intermed <- splineDesign(knots,
                                   x_tilde,
                                   ord = order,
                                   derivs = rep(1, length(x_tilde)))

      P_11 <- t(B_1_intermed)%*%B_1_intermed*delta_x_
      P_10 <- t(B_1_intermed)%*%B_0_intermed*delta_x_
      P_01 <- t(B_0_intermed)%*%B_1_intermed*delta_x_
      P_00 <- t(B_0_intermed)%*%B_0_intermed*delta_x_
      P_0110 <- P_01 + P_10


   #-------------------------------------------------- storage ---------------------------------------------------#

      #-------------------------------------------------- run1 ---------------------------------------------------#

         N_burnin_2_1    <- 1000
         N_iteration_2_1 <- 2000
         N_thin_2_1      <- 10
         N_total_2_1     <- ceiling((N_iteration_2_1 - N_burnin_2_1)/N_thin_2_1)
         N_paral_2_1     <- 20


         tau_post_2_1        <- array(0,
                                    dim = c(N_total_2_1, N_paral_2_1))
         gamma_vect_post_2_1 <- array(0,
                                      dim = c(N_total_2_1, N_paral_2_1, 2))
         lpk_mean_post_2_1   <- array(0,
                                      dim = c(N_total_2_1, N_paral_2_1, 4))
         lpk_tau_post_2_1    <- array(0,
                                      dim = c(N_total_2_1, N_paral_2_1, 3))
         lpk_vect_post_2_1   <- array(0,
                                      dim = c(N_total_2_1, N_paral_2_1, 3, I))
         c_post_2_1          <- array(0,
                                      dim = c(N_total_2_1, N_paral_2_1, M, I))


      #-------------------------------------------------- run2 ---------------------------------------------------#

         N_burnin_2_2    <- 2000
         N_iteration_2_2 <- 7000
         N_thin_2_2      <- 5
         N_total_2_2     <- ceiling((N_iteration_2_2 - N_burnin_2_2)/N_thin_2_2)
         N_paral_2_2     <- N_paral_2_1


         tau_post_2_2        <- array(0,
                                      dim = c(N_total_2_2, N_paral_2_2))
         gamma_vect_post_2_2 <- array(0,
                                      dim = c(N_total_2_2, N_paral_2_2, 2))
         lpk_mean_post_2_2   <- array(0,
                                      dim = c(N_total_2_2, N_paral_2_2, 4))
         lpk_tau_post_2_2    <- array(0,
                                      dim = c(N_total_2_2, N_paral_2_2, 3))
         lpk_vect_post_2_2   <- array(0,
                                      dim = c(N_total_2_2, N_paral_2_2, 3, I))
         c_post_2_2          <- array(0,
                                      dim = c(N_total_2_2, N_paral_2_2, M, I))


   #-------------------------------------------- hyperprior parameters -------------------------------------------#

      a_tau <- 1e-3
      b_tau <- 1e-3

      a_gamma_1 <- 1e0
      b_gamma_1 <- 1e-8

      a_gamma_2 <- 1e0
      b_gamma_2 <- 1e-8


      a_tau_lke   <- 1e0
      b_tau_lke   <- 1e-2

      a_tau_lkpc  <- 1e0
      b_tau_lkpc  <- 1e-2

      a_tau_lV    <- 1e0
      b_tau_lV    <- 1e-2

      max_tau_lpk <- 1e5


      mu_lkcp   <- 0.0
      prec_lkcp <- 1e-2

      mu_lke    <- 0.0
      prec_lke  <- 1e-2

      mu_lkpc   <- 0.0
      prec_lkpc <- 1e-2

      mu_lV     <- 0.0
      prec_lV   <- 1e-2


      param_2 <- c(a_tau, b_tau,
                   a_gamma_1, b_gamma_1,
                   a_gamma_2, b_gamma_2,
                   a_tau_lke, b_tau_lke,
                   a_tau_lkpc, b_tau_lkpc,
                   a_tau_lV,  b_tau_lV,
                   max_tau_lpk,
                   mu_lkcp, prec_lkcp,
                   mu_lke, prec_lke,
                   mu_lkpc, prec_lkpc,
                   mu_lV,  prec_lV)


      prec_c_prior <- array(0, dim = c(M, M))
      mu_c_prior <- numeric(M)
      prec_c_prior[1:M1, 1:M1]         <- diag(c(1e10, rep(0, M1 - 1)))
      prec_c_prior[(M1+1):M, (M1+1):M] <- diag(c(1e10, rep(0, M2 - 1)))
      mu_c_prior[1:M1]     <- c(dose, rep(0, M1 - 1))
      mu_c_prior[(M1+1):M] <- c(0, rep(0, M2 - 1))
      prec_c_prior_mu_c_prior <- prec_c_prior%*%mu_c_prior


   #-------------------------------- Metropolis-Hastings with adaptive proposals ---------------------------------#

      #-----------------------------------------------------------------------------------------------------------#
      #-------------------------------------------------- run1 ---------------------------------------------------#
      #-----------------------------------------------------------------------------------------------------------#

         #------------------------------- Initialization of the parameter's chains -------------------------------#

            tau_post_2_1[1, ] <- 10^rnorm(N_paral_2_1, 2.07, 0.1)

            gamma_vect_post_2_1[1, , 1] <- 10^seq(1, 8, length = N_paral_2_1)
            gamma_vect_post_2_1[1, , 2] <- 10^seq(1, 8, length = N_paral_2_1)

            lpk_mean_post_2_1[1, , 1] <- rnorm(N_paral_2_1, -0.1, 0.15)
            lpk_mean_post_2_1[1, , 2] <- rnorm(N_paral_2_1, 0.0,  0.20)
            for (n in 1:N_paral_2_1)
            {
               lpk_mean_post_2_1[1, n, 3] <- rtnorm(1,
                                                    -0.75,
                                                    0.50,
                                                    -Inf,
                                                    lpk_mean_post_2_1[1, n, 1])
            }
            lpk_mean_post_2_1[1, , 4] <- rnorm(N_paral_2_1, 2.0, 0.10)

            lpk_tau_post_2_1[1, , 1] <- 10^seq(1, 3, length = N_paral_2_1)
            lpk_tau_post_2_1[1, , 2] <- 10^seq(1, 3, length = N_paral_2_1)
            lpk_tau_post_2_1[1, , 3] <- 10^seq(1, 3, length = N_paral_2_1)

            for (i in 1:I)
            {
               lpk_vect_post_2_1[1, , 1, i] <- rnorm(N_paral_2_1,
                                                     0.0,
                                                     0.25)
               for (n in 1:N_paral_2_1)
               {
                  lpk_vect_post_2_1[1, n, 2, i] <- rtnorm(1,
                                                          -0.75,
                                                          0.60,
                                                          -Inf,
                                                          lpk_mean_post_2_1[1, n, 1])
               }
               lpk_vect_post_2_1[1, , 3, i] <- rnorm(N_paral_2_1,
                                                     2.0,
                                                     0.15)
            }


         #----------------------------------------------- n_accept -----------------------------------------------#

            n_accept_tau        <- rep(0, N_paral_2_1)
            n_accept_gamma_vect <- rep(0, N_paral_2_1*2)
            n_accept_lpk_mean   <- rep(0, N_paral_2_1*4)
            n_accept_lpk_tau    <- rep(0, N_paral_2_1*3)
            n_accept_lpk_vect   <- rep(0, N_paral_2_1*3*I)


        #----------------------------------------- appel de la fonction C ----------------------------------------#

            all_integer_2_1 <- c(N, I,
                                 M1, M2,
                                 N_iteration_2_1, N_burnin_2_1, N_thin_2_1, N_total_2_1, N_paral_2_1)

            t_chol_var_lpk_vect_2_1 <- array(0,
                                             dim = c(3, I*3))
            for (i in 1:I)
            {
               t_chol_var_lpk_vect_2_1[1:3, (i - 1)*3 + 1:3] <- diag(rep(1, 3))
            }
            rotation_2_1 <- -1.0

            dyn.load(paste(directory,"codeC_two_cmp_IV_bolus/codeC.dll",sep=""))

            metropolis_within_gibbs_2_1 <- .C("metropolis_within_gibbs",
                                              n_accept_gamma_vect = as.integer(n_accept_gamma_vect),
                                              n_accept_tau = as.integer(n_accept_tau),
                                              n_accept_lpk_vect = as.integer(n_accept_lpk_vect),
                                              n_accept_lpk_mean = as.integer(n_accept_lpk_mean),
                                              n_accept_lpk_tau = as.integer(n_accept_lpk_tau),
                                              as.double(param_2), as.integer(all_integer_2_1),
                                              as.double(prec_c_prior), as.double(prec_c_prior_mu_c_prior),
                                              as.double(P_11), as.double(P_10), as.double(P_01), as.double(P_00), as.double(P_0110),
                                              as.double(t_chol_var_lpk_vect_2_1), as.double(rotation_2_1),
                                              as.double(sum_y_sq), as.double(tBB), as.double(tBy),
                                              tau = as.double(tau_post_2_1),
                                              gamma_vect = as.double(gamma_vect_post_2_1),
                                              lpk_mean = as.double(lpk_mean_post_2_1),
                                              lpk_tau = as.double(lpk_tau_post_2_1),
                                              lpk_vect = as.double(lpk_vect_post_2_1))

            dyn.unload(paste(directory,"codeC_two_cmp_IV_bolus/codeC.dll",sep=""))


         #-------------------------------------------- exclude burnin --------------------------------------------#

            tau_post_2_1[] <- metropolis_within_gibbs_2_1$tau

            gamma_vect_post_2_1[] <- metropolis_within_gibbs_2_1$gamma_vect

            lpk_vect_post_2_1[] <- metropolis_within_gibbs_2_1$lpk_vect
            lpk_mean_post_2_1[] <- metropolis_within_gibbs_2_1$lpk_mean
            lpk_tau_post_2_1[]  <- metropolis_within_gibbs_2_1$lpk_tau


      #-----------------------------------------------------------------------------------------------------------#
      #-------------------------------------------------- run2 ---------------------------------------------------#
      #-----------------------------------------------------------------------------------------------------------#

         #------------------------------- Initialization of the parameter's chains -------------------------------#

            tau_post_2_2[1, ] <- 10^apply(log10(tau_post_2_1), 2, mean)

            gamma_vect_post_2_2[1, , 1] <- 10^seq(1, 8, length = N_paral_2_2)
            gamma_vect_post_2_2[1, , 2] <- 10^seq(1, 8, length = N_paral_2_2)

            lpk_mean_post_2_2[1, , 1] <- apply(lpk_mean_post_2_1[, , 1], 2, mean)
            lpk_mean_post_2_2[1, , 2] <- apply(lpk_mean_post_2_1[, , 2], 2, mean)
            lpk_mean_post_2_2[1, , 3] <- apply(lpk_mean_post_2_1[, , 3], 2, mean)
            lpk_mean_post_2_2[1, , 4] <- apply(lpk_mean_post_2_1[, , 4], 2, mean)

            lpk_tau_post_2_2[1, , 1] <- 10^apply(log10(lpk_tau_post_2_1[, , 1]), 2, mean)
            lpk_tau_post_2_2[1, , 2] <- 10^apply(log10(lpk_tau_post_2_1[, , 2]), 2, mean)
            lpk_tau_post_2_2[1, , 3] <- 10^apply(log10(lpk_tau_post_2_1[, , 3]), 2, mean)

            for (i in 1:I)
            {
               lpk_vect_post_2_2[1, , 1, i] <- apply(lpk_vect_post_2_1[, , 1, i], 2, mean)
               lpk_vect_post_2_2[1, , 2, i] <- apply(lpk_vect_post_2_1[, , 2, i], 2, mean)
               lpk_vect_post_2_2[1, , 3, i] <- apply(lpk_vect_post_2_1[, , 3, i], 2, mean)
            }


         #----------------------------------------------- n_accept -----------------------------------------------#

            n_accept_tau        <- rep(0, N_paral_2_2)
            n_accept_gamma_vect <- rep(0, N_paral_2_2*2)
            n_accept_lpk_mean   <- rep(0, N_paral_2_2*4)
            n_accept_lpk_tau    <- rep(0, N_paral_2_2*3)
            n_accept_lpk_vect   <- rep(0, N_paral_2_2*3*I)


        #----------------------------------------- appel de la fonction C ----------------------------------------#

            all_integer_2_2 <- c(N, I,
                                 M1, M2,
                                 N_iteration_2_2, N_burnin_2_2, N_thin_2_2, N_total_2_2, N_paral_2_2)

            t_chol_var_lpk_vect_2_2 <- array(0,
                                             dim = c(3, I*3))
            for (i in 1:I)
            {
               t_chol_var_lpk_vect_2_2[1:3, (i - 1)*3 + 1:3] <- t(chol(var(cbind(as.numeric(lpk_vect_post_2_1[, , 1, i]),
                                                                                 as.numeric(lpk_vect_post_2_1[, , 2, i]),
                                                                                 as.numeric(lpk_vect_post_2_1[, , 3, i])))))
            }
            rotation_2_2 <- 1.0

            dyn.load(paste(directory,"codeC_two_cmp_IV_bolus/codeC.dll",sep=""))

            metropolis_within_gibbs_2_2 <- .C("metropolis_within_gibbs",
                                              n_accept_gamma_vect = as.integer(n_accept_gamma_vect),
                                              n_accept_tau = as.integer(n_accept_tau),
                                              n_accept_lpk_vect = as.integer(n_accept_lpk_vect),
                                              n_accept_lpk_mean = as.integer(n_accept_lpk_mean),
                                              n_accept_lpk_tau = as.integer(n_accept_lpk_tau),
                                              as.double(param_2), as.integer(all_integer_2_2),
                                              as.double(prec_c_prior), as.double(prec_c_prior_mu_c_prior),
                                              as.double(P_11), as.double(P_10), as.double(P_01), as.double(P_00), as.double(P_0110),
                                              as.double(t_chol_var_lpk_vect_2_2), as.double(rotation_2_2),
                                              as.double(sum_y_sq), as.double(tBB), as.double(tBy),
                                              tau = as.double(tau_post_2_2),
                                              gamma_vect = as.double(gamma_vect_post_2_2),
                                              lpk_mean = as.double(lpk_mean_post_2_2),
                                              lpk_tau = as.double(lpk_tau_post_2_2),
                                              lpk_vect = as.double(lpk_vect_post_2_2))

            dyn.unload(paste(directory,"codeC_two_cmp_IV_bolus/codeC.dll",sep=""))

         #-------------------------------------------- exclude burnin --------------------------------------------#

            tau_post_2_2[] <- metropolis_within_gibbs_2_2$tau

            gamma_vect_post_2_2[] <- metropolis_within_gibbs_2_2$gamma_vect

            lpk_vect_post_2_2[] <- metropolis_within_gibbs_2_2$lpk_vect
            lpk_mean_post_2_2[] <- metropolis_within_gibbs_2_2$lpk_mean
            lpk_tau_post_2_2[]  <- metropolis_within_gibbs_2_2$lpk_tau


      #------------------------------------------- traces & histograms -------------------------------------------#

         windows()
         par(mfrow = c(3,2), mar = c(4,5,1,1),cex = 1)

         plot(log10(as.numeric(tau_post_2_2)),type="l",
              ylab = expression(paste("log"[10],group("(",tau,")"),sep="")))
         hist(log10(as.numeric(tau_post_2_2)),breaks=20,main="",freq=F,
              xlab = expression(paste("log"[10],group("(",tau,")"),sep="")))

         plot(log10(as.numeric(gamma_vect_post_2_2[,,1])),type="l",
              ylab = expression(paste("log"[10],group("(",gamma[21],")"),sep="")))
         hist(log10(as.numeric(gamma_vect_post_2_2[,,1])),breaks=20,main="",freq=F,
              xlab = expression(paste("log"[10],group("(",gamma[21],")"),sep="")))

         plot(log10(as.numeric(gamma_vect_post_2_2[,,2])),type="l",
              ylab = expression(paste("log"[10],group("(",gamma[22],")"),sep="")))
         hist(log10(as.numeric(gamma_vect_post_2_2[,,2])),breaks=20,main="",freq=F,
              xlab = expression(paste("log"[10],group("(",gamma[22],")"),sep="")))



         windows()
         par(mfrow = c(4,2), mar = c(4,5,1,1), cex = 1)

         plot(as.numeric(lpk_mean_post_2_2[,,2]),type="l",
              ylab = expression(lk[e]))
         hist(as.numeric(lpk_mean_post_2_2[,,2]),breaks=20,main="",freq=F,
              xlab = expression(lk[e]))

         plot(as.numeric(lpk_mean_post_2_2[,,1]),type="l",
              ylab = expression(lk[cp]))
         hist(as.numeric(lpk_mean_post_2_2[,,1]),breaks=20,main="",freq=F,
              xlab = expression(lk[cp]))

         plot(as.numeric(lpk_mean_post_2_2[,,3]),type="l",
              ylab = expression(lk[pc]))
         hist(as.numeric(lpk_mean_post_2_2[,,3]),breaks=20,main="",freq=F,
              xlab = expression(lk[pc]))

         plot(as.numeric(lpk_mean_post_2_2[,,4]),type="l",
              ylab = expression(lV))
         hist(as.numeric(lpk_mean_post_2_2[,,4]),breaks=20,main="",freq=F,
              xlab = expression(lV))



         windows()
         par(mfrow = c(3,2),mar=c(4,5,1,1), cex = 1)

         plot(log10(as.numeric(lpk_tau_post_2_2[,,1])),type="l",
              ylab = expression(paste("log"[10],group("(",tau[lk[e]],")"),sep="")))
         hist(log10(as.numeric(lpk_tau_post_2_2[,,1])),breaks=20,main="",freq=F,
              xlab = expression(paste("log"[10],group("(",tau[lk[e]],")"),sep="")))

         plot(log10(as.numeric(lpk_tau_post_2_2[,,2])),type="l",
              ylab = expression(paste("log"[10],group("(",tau[lk[pc]],")"),sep="")))
         hist(log10(as.numeric(lpk_tau_post_2_2[,,2])),breaks=20,main="",freq=F,
              xlab = expression(paste("log"[10],group("(",tau[lk[pc]],")"),sep="")))

         plot(log10(as.numeric(lpk_tau_post_2_2[,,3])),type="l",
              ylab = expression(paste("log"[10],group("(",tau[lV],")"),sep="")))
         hist(log10(as.numeric(lpk_tau_post_2_2[,,3])),breaks=20,main="",freq=F,
              xlab = expression(paste("log"[10],group("(",tau[lV],")"),sep="")))





#-----------------------------------------------------------------------------------------------------------------#
#-----------------------------------------------------------------------------------------------------------------#
#                                                                                                                 #
#                              Comparison between the IV bolus 1cmp & IV bolus 2 cmp                              #
#                                                                                                                 #
#-----------------------------------------------------------------------------------------------------------------#
#-----------------------------------------------------------------------------------------------------------------#

   breaks1 <- seq(-1, 10, by = 0.2)
   breaks2 <- seq(-1, 10, by = 0.4)

   a1 <- hist(log10(as.numeric(gamma_vect_post_2_2[,,1])), breaks = breaks1, prob = T)
   a2 <- hist(log10(as.numeric(gamma_post_1_2[])), breaks = breaks2, prob = T)

   xlim <- c(min(log10(gamma_vect_post_2_2[,,1]),log10(gamma_post_1_2[])),
             max(log10(gamma_vect_post_2_2[,,1]),log10(gamma_post_1_2[])))
   ylim <- c(0, max(a1$density, a2$density))

   windows()
   par(mfrow = c(1, 1),
       mar = c(5, 5, 1, 1),
       cex = 1.6)

   hist(log10(as.numeric(gamma_post_1_2[])),
        breaks = breaks2,
        prob = T,
        xlim = xlim, ylim = ylim,
        main = "", xlab = expression(paste("log"[10],group("(",gamma,")"),sep="")), ylab = "Density",
        col = "lightgray",
        border = "gray")
   hist(log10(as.numeric(gamma_vect_post_2_2[,,1])),
        breaks = breaks1,
        prob = T,
        add = TRUE,
        col = "gray",
        border = "darkgray")
   box()
   curve(log(10)*(10^x)*dgamma(10^x, 1, 10^(-8)),
         from = -2, to = 10,
         add = TRUE,
         lwd = 2,
         n = 600,
         col = "black")
   legend("topleft",
          legend = c("    1-compartment IV bolus","    2-compartment IV bolus"),
          fill = c("lightgray",
                   "gray"),
          border = c("gray",
                     "darkgray"),
          bty = "n")
   legend("topleft",
          legend = c("","","prior density"),
          lty = c(-1,-1,1),
          lwd = c(2,2,2),
          bty = "n")
