### Simulate 100 data sets for M2 and positive correlation

library(mvtnorm)
for(i in 1:100){
z1 <- runif(500, 1.5, 4)
z2 <- runif(500, 4, 9)
z3 <- runif(500, 3, 5.5)
z4 <- runif(500, 4, 4.5)

fz1_1 <- -((z1-(4-1.5))/(.5*(4-1.5)))^2
fz2_1 <- exp((z2-(9-4))/(.3*(9-4)))
fz3_1 <- .5*z3
fz4_1 <- sin((z4)^2+1)


fz1_2 <- -((z1-(4-1.5))/(.5*(4-1.5)))^2
fz2_2 <- .5*z2
fz3_2 <- -sin((z3)-1)
fz4_2 <- -sin((z4)*1.5-2)

eta1 <- fz1_1 + fz2_1 + fz3_1 + fz4_1 
eta2 <- fz1_2 + fz2_2 + fz3_2 + fz4_2
cov <- diag(2)
cov[1,2]<- .1
cov[2,1]<- .1
eps <- rmvnorm(length(eta1),c(0,0), cov) 
y <- cbind(eta1, eta2)+eps

data <- cbind(y, z1, z2, z3, z4)
colnames(data)[1:2] <- c("y1", "y2")
write.table(data, file=paste("cov01_",i,".dat", sep=""),row.names=F, quote=F)
}