library("mvtnorm")
library("gamlss.dist")
library("quantreg")
library("MCMCpack")
library("statmod")
source("weights.R")
source("Pin.R")
source("lin.R")
source("ga.R")
source("delta_gam.R")
source("bsplines.R")
bivquant <- function(y, X,z1,z2=NULL,B,burn, thin, tau1, tau2, directory=null, name=null){
  beta_save <- paste(directory,"/",name, "_beta.txt", sep="")
  gamma_save <- paste(directory,"/",name, "_gamma.txt", sep="")
  delta_save <- paste(directory,"/",name, "_delta.txt", sep="")
  delta_gamma_save <- paste(directory,"/",name, "_delta_gamma.txt", sep="")
  w_save <- paste(directory,"/",name, "_w.txt", sep="")
  nu_save <- paste(directory,"/",name, "_nu.txt", sep="")
  zgamma_save <- list()
  

a_1 <- 0.001
b_1 <-.001
acP <- 0
Xt <- t(X)
n <- nrow(X)/2
  Lgalt<-list()
if(is.null(z1)){
  k <- 0
  gamma <-rep(1,22)
  Z<-matrix(nrow=2*n, ncol=22, data=0)
  K<-diag(22)
  Zt <- t(Z)
  Zgr <- Z
  gammagr<- gamma
  Zg <- Zgr%*%gammagr
  }else{ z <- list()
  z[[1]] <- as.matrix(z1)-mean(z1)
  if(is.null(z2)){
  z2 <- z1
  }
         z[[2]] <- as.matrix(z2)-mean(z2)
        k <- ncol(z1)+ncol(z2)
spl_work <- list() 
  Z_work <- list()
  Zt <- list()
  K_work <- list()
   A <- list()

  gamma <- list()
  Zg_sep <- list()
 for(zi in 1:2){
spl_work[[zi]] <- list() 
  Z_work[[zi]] <- list()
  K_work[[zi]] <- list()
   for(j in 1:ncol(z[[zi]])){
         spl_work[[zi]][[j]] <- bsplines(z[[zi]][,j])
    Z_work[[zi]][[j]]<- as.matrix(spl_work[[zi]][[j]])
if(zi==1){
    Z_work[[zi]][[j]]<- matrix(ncol=ncol(Z_work[[zi]][[j]]), data=rbind(as.vector((Z_work[[zi]][[j]])),0))
    }else{
      Z_work[[zi]][[j]]<- matrix(data=rbind(0,as.vector((Z_work[[zi]][[j]]))),ncol=ncol(Z_work[[zi]][[j]]))
       }
    K_work[[zi]][[j]] <- attr(spl_work[[zi]][[j]], "K")


   }
}
  Z <- list()
  K <- list()
  Kkl <- list()

 a_1st<- vector(length=k)
  Z <- c(Z_work[[1]], Z_work[[2]])
  K <- c(K_work[[1]], K_work[[2]])
  
for(j in 1:k){
    gamma[[j]] <- rep(0, ncol(Z[[j]]))
  Zt[[j]] <- t(Z[[j]])
  if(j==1){
    Zgr <- Z[[j]]
    gammagr <- gamma[[j]]
     zh <-matrix(nrow=k, ncol=2)
    zh[1,1]<-1
    zh[1,2]<-ncol(Zgr)
  }else{zh[j,1]<- ncol(Zgr)+1
    Zgr <- cbind(Zgr, Z[[j]])
    zh[j,2]<-ncol(Zgr)
    gammagr <- c(gammagr, gamma[[j]])}

            A[[j]] <- (rep(1, nrow(Z[[j]])))%*%(Z[[j]])
          a_1st[j] <- a_1 + qr(K[[j]])$rank/2

    }
    Zgrt <- t(Zgr)
    
    Zg <- Zgr%*%gammagr
                         delta_gamma<-rep(1,k)
}
  for(j in 1:k){
  zgamma_save[[j]] <- paste(directory,"/",name, "_nonlin_",j,".txt", sep="")}
  xi1 <- (1-2*tau1)/(tau1*(1-tau1))
  xi2 <- (1-2*tau2)/(tau2*(1-tau2))
  xi <- c(xi1,xi2)
  n <- length(y)/2
  y1 <- y[seq(1, 2*n-1, by=2)]
  y2 <- y[seq(2, 2*n, by=2)]

#Startvalues
beta <- solve(Xt%*%X)%*%Xt%*%y
  Xb <- X%*%beta
delta1 <-2
delta2 <- 2
delta <- c(delta1, delta2)
nu <- 0
w <- rep(1, 2*n)
Pinv <- diag(c(delta1, delta2))
 Pinv[1,2]<-nu
 Pinv[2,1]<-nu
P <- solve(Pinv)
sigma1 <- 2/(tau1*(1-tau1))
sigma2 <- 2/(tau2*(1-tau2))
sigma <- c(sigma1,sigma2)


Sigblocki <- as.matrix.csr(rep(c(1,0,0,1) ,n), nrow=2*n, ncol=2*n)
attr(Sigblocki,"ia")<- seq(1,(2*(2*n)+1),2)
s1 <- seq(1, 2*n)
attr(Sigblocki, "ja")<- t(matrix(data=c(1,s1, s1,1,1,s1,s1, 1),  ncol=4)[seq(2,length(s1),2),])
attr(Sigblocki,"ra")<-rep(c(1,0,0,1), n)
Sigblockin <- Sigblocki
   write(paste("beta",1:length(beta), sep=""),ncolumns=length(beta), beta_save)
   write(paste("gammagr", 1:length(gammagr), sep=""), ncolumns=length(gammagr), gamma_save)
   write(paste("delta",1:length(delta),sep=""), ncolumns=2, delta_save)
   write(paste("delta_gamma", 1:length(delta_gamma), sep=""), ncolumns=length(delta_gamma),delta_gamma_save)
    for(j in 1:k){
  write(paste("Zg",1:length(y),sep=""), ncolumns=length(y), zgamma_save[[j]])}
   write(paste("nu"), nu_save)
   write(paste("w", 1:length(w), sep=""), ncolumns=length(w), w_save)
    for(b in 1:B)
      {
       if(b%%1000==0)
        {
        cat("Iteration: ",b,"\n",sep="")
        cat("Acceptance rate weights: ",acccount/n,"\n",sep="")    
      
        }
eta <- Xb + Zg
eta1 <- eta[seq(1, 2*n-1, by=2)]
eta2 <- eta[seq(2, 2*n, by=2)]
  ###################################################
  ### Weight Updating ###############################
  ###################################################
retw <-  weights(xi1, sigma1, y1, eta1, xi2, sigma2, y2, eta2, delta, n, w, P)
       w <- retw$w
       acccount <- retw$accc
       
###################################################
### Linear Effects  ###############################
###################################################
  betal <- linear(w, sigma, Sigblocki, P, n, Xt, X, z, y, Zg, xi)
  beta <- betal$beta
  Xb <- betal$Xb
  Sigmainv <- betal$Sigmainv

###################################################
### Nonlinear Effects #############################
###################################################

  if(is.null(z)==FALSE){
    for(j in 1:k){
#### gamma
      indmj <- c(1:k)[-j]
      Zgrest <- 0
    for(l in indmj){Zgrest <- Zgrest + Z[[l]]%*%gamma[[l]]}
       gamh<- ga(gamma, j, Z, Zt, K,delta_gamma, Sigmainv, y, Xb, Zgrest, A, zh, Lgalt)
    gamma[[j]]<-gamh$gammaj
      Lgalt[[j]]<-gamh$Lgalt
   # index for the part of the long gamma vector we want the gamma to be in
    ind <- seq(zh[j,1],zh[j,2])
    gammagr[ind]<- gamma[[j]]
      
##### delta_gamma
        delta_gamma[j] <- rgamma(1, a_1st[j], b_1+(.5*t(gamma[[j]])%*%K[[j]]%*%gamma[[j]]))

      Zg_sep[[j]] <- Z[[j]]%*%gamma[[j]]
}     
Zg <- Zgr%*%gammagr
  
 }
 eta <- Xb + Zg
eta1 <- eta[seq(1, 2*n-1, by=2)]
eta2 <- eta[seq(2, 2*n, by=2)]      
       
  ###################################################
  ### Covariance Update #############################
  ###################################################
          Pinvh <- Pin(Pinv,P, w, n, y, eta, xi, sigma, b, Sigblocki, a_1, b_1)
    Pinv <- Pinvh$Pinv
   P <- Pinvh$P
# #picking out precision and covariance
   delta <-1/diag(Pinv)
       delta1 <- delta[1]
       delta2 <- delta[2]
   nu <- Pinv[1,2]
        acP <- acP + Pinvh$akz
  
 
###Speichern
if(b>burn & (floor((b-burn)/thin%in%1:(B-burn)/thin)==(b-burn)/thin%in%1:(B-burn)/thin)){
  write(beta, ncolumns=length(beta),beta_save, append=T)
  write(gammagr, gamma_save,ncolumns=length(gammagr), append=T)
  write(delta, delta_save, append=T)
  write(as.vector(t(delta_gamma)), delta_gamma_save, ncolumns=length(as.vector(t(delta_gamma))),append=T)
  for(j in 1:k){
  write(Zg_sep[[j]], zgamma_save[[j]],ncolumns = length(Zg_sep[[j]]), append=T)}
  write(nu, nu_save, append=T)
  write(w, w_save,ncolumns=length(w), append=T)

}
      
      
      }

    }