linear <- function (w, sigma, Sigblocki, P, n, Xt, X, z, y, Zg, xi) {
    # Covariance with diagonal matrix of weights and sigma and block elements
      D <- diag(sqrt(1/(w*sigma)))
      attr(Sigblocki,"ra")<-rep(as.vector(P), n)
      Sigmainv <- D%*%Sigblocki%*%D
      Pb <- as.matrix(Xt%*%Sigmainv%*%X)
    # Efficient sampling from Gaussian
      L<-chol(Pb)
            nub<-forwardsolve(L,as.matrix(Xt%*%Sigmainv%*%(y-Zg-rep(xi, n)*w)),upper.tri=T,transpose=T)
            mub<-backsolve(L,nub)
      beta<-mub+solve(L,rnorm(length(mub),0,1))
    # new linear predictor
      Xb <- X%*%beta
      ret <- list("beta"=beta, "Xb"=Xb, "Sigmainv"=Sigmainv)
  }
