weights <- function (xi1, sigma1, y1, eta1, xi2, sigma2, y2, eta2, delta, n, w, P) {

  # Counting accepted weights, counter to zero
    acccount <- 0
  # Parameters for Inverse Gauss Proposal (vectorial)
    a1g<-sqrt((xi1^2+2*sigma1)/(y1-eta1)^2)
    a2g <-sqrt((xi2^2+2*sigma2)/(y2-eta2)^2)
    b1 <- (delta[1]*(xi1^2+2*sigma1)/sigma1)
    b2 <- (delta[2]*(xi2^2+2*sigma2)/sigma2)
  
  # Vectorial Proposal from inverse Inverse Gaussian
    w1propg <- 1/rinvgauss(n,a1g, b1)
    w2propg <- 1/rinvgauss(n,a2g, b2)
  
  ### Acceptance Propability
  # current values of w
    w1curr <- w[seq(1, 2*n-1, by=2)]
    w2curr <- w[seq(2, 2*n, by=2)]
  ## Proposal
  # Parameters for Proposal
    mu.propg <- cbind(eta1+xi1*w1propg, 
                      eta2+xi2*w2propg)
    mu.currg <- cbind(eta1+xi1*w1curr, 
                      eta2+xi2*w2curr)
  # Log density of Proposal 
    log.prop.propg <- -1.5*log(1/w1propg)-(b1*(1/w1propg-a1g)^2/(2*a1g^2*(1/w1propg)))-
                       1.5*log(1/w2propg)-(b2*(1/w2propg-a2g)^2/(2*a2g^2*(1/w2propg)))
    log.prop.currg <- -1.5*log(1/w1curr)-(b1*(1/w1curr-a1g)^2/(2*a1g^2*(1/w1curr)))-
                       1.5*log(1/w2curr)-(b2*(1/w2curr-a2g)^2/(2*a2g^2*(1/w2curr)))
  ## Posterior
  # Kernel of the Posterior and determinant for the covariance 
    kern.prop <-rowSums((cbind(1/sqrt(sigma1*w1propg), 1/sqrt(sigma2*w2propg))*
                        (cbind(y1,y2)-mu.propg))%*%P*
                        (cbind(1/sqrt(sigma1*w1propg), 1/sqrt(sigma2*w2propg))*
                        (cbind(y1,y2)-mu.propg)))
    de.prop <- ((1/(sigma1*w1propg)*1/(sigma2*w2propg)))*det(P)
    kern.curr <- rowSums((cbind(1/sqrt(sigma1*w1curr), 1/sqrt(sigma2*w2curr))*
                          (cbind(y1,y2)-mu.currg))%*%P*
                          (cbind(1/sqrt(sigma1*w1curr), 1/sqrt(sigma2*w2curr))*
                          (cbind(y1,y2)-mu.currg)))
    de.curr <- ((1/(sigma1*w1curr)*1/(sigma2*w2curr)))*det(P)
  # Log density of Posterior
    log.post.propg <- 1/2*log(de.prop)  -1/2*kern.prop-
                      w1propg*delta[1] +2*log(w1propg)-
                      w2propg*delta[2]+2*log(w2propg)
    log.post.currg <- 1/2*log(de.curr)  -1/2*kern.curr-
                      w1curr*delta[1] +2*log(w1curr)-
                      w2curr*delta[2]+2*log(w2curr)
  ## acceptance probability into index vector
    ind <- (log.post.propg + log.prop.currg - log.post.currg - log.prop.propg > log(runif(n)))
  # accepted values into current values
    w1curr[ind]<- w1propg[ind]
    w2curr[ind]<-w2propg[ind]
    acccount <- table(ind)[2]
  # final version of w
    w <- as.vector(t(cbind(w1curr, w2curr)))
  return(list("w"=w, "acc"=acccount))
    }
