library(JM)
library(HI)

#Kaplan-Meier
survFit <- survfit(Surv(years, status2) ~ factor(drug), data = pbc2.id)
plot(survFit, lwd = c(1,3))

#Marginal Models
lmeFit <- lme(log(serBilir) ~ year + drug * year,
    random = ~ year | id, data = pbc2)
coxFit <- coxph(Surv(years, status2) ~ factor(drug), data = pbc2.id, x = TRUE)


#JM
jm = jointModel(lmeFit, coxFit, timeVar = "year", method = "Cox-PH-GH")
coef = jm$coefficients$betas

# Initial values (coefficients under ignorability)
init.list <- list(betas = fixef(lmeFit), sigma = lmeFit$sigma, D = getVarCov(lmeFit),
  			 gammas = coef(coxFit), lambda0 = basehaz(coxFit)[,"hazard"], alpha = 0)

# Fitting the JM with zero EM iterations and "init.list" initial values
jm.init <- jointModel(lmeFit, coxFit, timeVar = "year", method = "Cox-PH-GH", only.EM = TRUE, iter.EM = 0,
  		   init = init.list)
# Obtaining the corresponding Hessian matrix
H <- jm.init$Hessian
H.inv <- solve(H)

#Calculate the ISNI
pBetas <- head(grep("Y.", colnames(H), fixed = TRUE), -1)
pAlpha <- which(colnames(H) == "T.alpha")
isni <- -c(H.inv[pBetas, pBetas] %*% H[pBetas, pAlpha])
se.betas <- sqrt(diag(vcov(lmeFit)))
sigma.y = sd(log(pbc2.id$serBilir))
# ISNI e sensitivity transformation 
round(cbind(ISNI = isni, rISNI = isni/sigma.y*se.betas), 3)

## Proposed relative formulation
# Number of bootstrapped samples
N = 1000
# Longitudinal data
n.long = length(pbc2$id)
betas = fixef(lmeFit)
sigma = lmeFit$sigma
X = cbind("int" = 1, "year" = pbc2$year, "drug" = pbc2$drug, "drug:year" = pbc2$year*as.numeric(pbc2$drug))
Z = cbind("int" = 1, "year" = pbc2$year)
b = ranef(lmeFit)
id = pbc2$id
# Survival data
type == "ph"
years = pbc2.id$years
rep.time = which(table(years)>1)
n.time = table(years)[rep.time]
h0.par = basehaz(coxFit)[,"hazard"]
h0 = c(h0.par[-rep.time], rep(h0[rep.time], n.time))
W = cbind("drug" = pbc2.id$drug)
gammas = coef(coxFit)
eta.t <- as.vector(W %*% gammas)
n = length(pbc2.id$years)
csi = 1.2

# Bootstrapping the longitudinal data
mu = as.vector(fitted(lmeFit))
y = matrix(NA, N, n.long)

for(i in 1:n.long){
y[,i] = rnorm(1000, mu[i], sigma)
}

attach(pbc2)

p = function(t, i){
	 log.h = csi + (csi-1) * t + eta.t[i] 
	 h = exp(log.h)
	 log.h - h
        }
            
trueTimes = matrix(NA, N, n)

# Generating true dropout times 
for(i in 1:n){
trueTimes[,i] <- arms(years[1], function(t) p(t, i), function(t) (t > 0.001) * (t < 50), N)
}
# Mean of the censoring process
mean.exp = 4
# Simulating censoring times from an exponential distribution,
# and calculating the observed event times, i.e., min(true event times, censoring times)
Ctimes <- rep(rexp(n, 1/mean.exp), N)
Ctimes = matrix(Ctimes, N, n)
Time = matrix(NA, N, n)
event = matrix(NA, N, n)

# Time to dropout
for(i in 1:n){
Time[, i] <- pmin(trueTimes[,i], Ctimes[,i])
# Event indicator
event[,i] <- as.numeric(trueTimes[,i] <= Ctimes[,i])
}


data.long = vector("list", length = N)
data.surv = vector("list", length = N)
lme.list = vector("list", length = N)
surv.list = vector("list", length = N)

# Generating N initial values
for(B in 1:N){
data.long[[B]] = data.frame(y=y[B,], t = pbc2$year, drug = pbc2$drug, id = pbc2$id)
data.surv[[B]] = data.frame(Time = Time[B,], event = event[B,], drug = pbc2.id$drug)
lme.list[[B]] <- lme(y ~ t + drug + drug : t, random = ~ t | id, data = data.long[[B]])
surv.list[[B]] <- coxph(Surv(Time, event) ~ factor(drug), data = data.surv[[B]], x = TRUE)
}

betas.mat = matrix(NA, N, 4)
sigma.mat = matrix(NA, N, 1)
gammas.mat = matrix(NA, N, 1)
D.mat = matrix(NA, N, 4)
H = vector("list",length=N)
ISNI = matrix(NA, N, 4)

# Computing N ISNIs
for(B in 1:N){
betas.mat[B,] = fixef(lme.list[[B]])
sigma.mat[B,] = lme.list[[B]]$sigma
gammas.mat[B,] = coef(surv.list[[B]])
D.mat[B,] = c(getVarCov(lme.list[[B]]))
h0 = basehaz(surv.list[[B]])[,"hazard"]
init.list <- list(betas = fixef(lme.list[[B]]), sigma = lme.list[[B]]$sigma, D = getVarCov(lme.list[[B]]), gammas = coef(surv.list[[B]]), lambda0 = h0, alpha = 0)
jm.init <- jointModel(lme.list[[B]], surv.list[[B]], timeVar = "t", method = "Cox-PH-GH", only.EM = TRUE, iter.EM = 0,
  		   init = init.list)
H[[B]] <- jm.init$Hessian
H.inv <- solve(H[[B]])
pBetas <- head(grep("Y.", colnames(H[[B]]), fixed = TRUE), -1)
pAlpha <- which(colnames(H[[B]]) == "T.alpha")
ISNI[B,] <- -c(H.inv[pBetas, pBetas] %*% H[[B]][pBetas, pAlpha])
	c(getVarCov(lme.list[[B]]))
}

# ISNI standard errors and relative ISNI
se.isni = round(apply(ISNI.trim, 2, sd),3)
isni.rel.se = round(isni/se.isni,3)






