#sample size
N<-20

#parameter values
beta<-c(2, -0.2, 0.3, -0.3, 0.7, 0.5)
names(beta)<-c("(Intercept)","x","U","G0","G.z.psi","U.x.diff")

sd.k<- .2 #st.dev of changepoint random effects. Alternative "reasonable" values: .1, .2, .4
sd.eps<-.01#st.dev of the response. Alternative "reasonable" values: .03, .05


#call of the starting linear model
mycall<-call("lme.formula",fixed=y~x, data=quote(d[[1]]), random=quote(list(id=pdDiag(~1+x))))

#generate data
d<-sim.seg(N, n=c(5,15), fixEff = beta[1:4], S=diag(c(.1,.1,.1,sd.k)^2), sd.epsilon=sd.eps,
  z.psi=beta[5], x.diff=beta[6], psi.link="l")

#library(nlme)
#plot(groupedData(y~x|id,data=d[[1]]))

#fit a segmented mixed model with random changepoints.
#The 'random' argument specifies that diagonal covariance matrix for the random effects
oo<- seg.lme5a(mycall, Z=x, z.psi=~z.psi, x.diff=~x.diff,
        random=list(id=pdDiag(~1+x+U+G0)), psi.link="l")

#Perform bootstrap restarting to escape the local optima and to obtain better
#point estimates (Especially if you have very noisy data)
 ooB<-bootsegMix(oo,B=10, display=TRUE)

#a simple print method
ooB

#fixed effects
fixed.effects(ooB[[1]])
sqrt(diag(vcov(ooB[[1]])))


#Perform bootstrap to obtain standard errors and confidence intervals
cibootList<- ci.boot(bootNP(ooB,50))

#Normal based CI
cibootList$Norm


#compare fixed effect estimates
rbind(true=beta, estimated=fixef(oo[[1]]))

#compare observed and fitted values
plot(fitted.segmented.lme(oo), d$data$y);abline(0,1)

#compare true and estimated/predicted changepoints
plot(ooB$est.psi, d$psii, xlab="Estimates/Predicted", ylab="True");abline(0,1)


idV=1
with(subset(d$data, id==idV), plot(x, y, type="b", main=paste("id =",idV), ylim=range(d$data$y)))
plot(oo, id=as.character(idV), add=TRUE)
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
