
fitted.segmented.lme<-function(fit, level=1){
#fit: an object of class "segmented.lme" 
#What about "fitted(oo$lme.fit.noG)" or "fitted(obj,level=1)+fit$Off"?  
       obj<-fit[[1]]
       level<-deparse(level)
       switch(level,
            "0"={
                mu<-fitted(obj,level=0) + fit$Off
                if("G0"%in%names(ranef(obj))){
                  ni<-tapply(obj$groups[,1], obj$groups[,1], length)
                  ki<-rep(ranef(obj)[["G0"]],ni)
                  mu<-mu + ki*obj$data[["G0"]]
                  }
                    },
            "1"={ mu<-fitted(obj,level=1)+fit$Off
                    }
              ) #end_switch
       return(mu)
       }


bootNP<-function(fit, B=50, seed=NULL, it.max.b=6){
#Non parametric boot for slme4
#fit: un oggetto di classe "segmented.lme"
#-----------------------
update.lme.call<-function (old.call, fixed., ..., evaluate=FALSE) {
    call <- old.call
    extras <- match.call(expand.dots = FALSE)$...
    if (!missing(fixed.)) call$fixed <- update.formula(call$fixed, fixed.)
    if (length(extras) > 0) {
        existing <- !is.na(match(names(extras), names(call)))
        for (a in names(extras)[existing]) call[[a]] <- extras[[a]]
        if (any(!existing)) {
            call <- c(as.list(call), extras[!existing])
            call <- as.call(call)
            }
        }
    if (evaluate) eval(call, parent.frame()) else call
    }
#---------
    N<-nlevels(fit$lme.fit$groups[[1]]) #n. of subjects
    newData<-fit$lme.fit$data
    nomeRispo<-all.vars(formula(fit$lme.fit))[1]
    #AGGIUSTA la risposta
    newData[,nomeRispo]<-newData[,nomeRispo] + fit$Off

    o.b<-fit$boot.call
    call.b<-update(object=fit, obj=o.b, data=newD, it.max=it.max.b,
          start=list(kappa0=startKappa0,kappa=startingKappa), display=FALSE, evaluate=FALSE)

    startingKappa<-extract.psi(fit)
    startKappa0<- startingKappa[1]
    startingKappa<-startingKappa[-1]
    nomiKappa<-names(startingKappa)
    nomiKappa<-sapply(strsplit(nomiKappa, "G\\."),function(x)x[2])
    names(startingKappa) <- nomiKappa

    est<-fixef(fit[[1]])
    se<-sqrt(diag(vcov(fit[[1]])))
    COEF<-SE<-matrix(,B,length(est))
    if(!is.null(seed)) set.seed(seed)

    for(i in seq(B)){
       #build the boot sample
       #idx<-sample(N, replace=TRUE)
       idx<-sample(1:N, size=N, replace=TRUE)
       newD<-do.call("rbind",lapply(idx, function(x)newData[newData$id==x,]))
       newD$y.b<- newD$y
       fit.b<-try(suppressWarnings(eval(call.b)), silent=TRUE) #envir=newD)
       if(is.list(fit.b)){
            Tt<-nlme:::summary.lme(fit.b[[1]])$tTable
            COEF[i,]<-Tt[,1] #coef
            SE[i,]<-Tt[,2] #se
            }
       }
       r<-list(coef=rbind(est,COEF),se=rbind(se,SE))
       r
       }

ci.boot<-function(m, conf.level=0.95){
#computes three boot CI
#m: object returned by bootNP()
    est.orig<-m$coef[1,]
    se.orig<-m$se[1,]

    zalpha<- -qnorm((1-conf.level)/2)

    #percentile
    CIt<-CIN<-CIperc<-apply(m$coef[-1,], 2, quantile, prob=c((1-conf.level)/2, (conf.level + (1-conf.level)/2)), na.rm=TRUE)

    #Normal-based
    SE<-apply(m$coef[-1,],2,sd, na.rm=TRUE)
    CIN[1,]<-est.orig - zalpha*SE
    CIN[2,]<-est.orig + zalpha*SE

    #t-boot
    Tdistr<-(m$coef[-1,]-matrix(m$coef[1,],ncol=length(est.orig), nrow=nrow(m$coef)-1, byrow=TRUE))/m$se[-1,]
    quantT<-apply(Tdistr,2,quantile, prob=c((1-conf.level)/2, (conf.level + (1-conf.level)/2)), na.rm=TRUE)
    CIt[1,]<-est.orig- quantT[2,]*se.orig
    CIt[2,]<-est.orig- quantT[1,]*se.orig

    ris<-list(perc=CIperc, Norm=CIN, t=CIt)
    ris
    }




extract.psi<-function(obj){
#questa funzione restituisce i "kappa", ovvero i coeff di psi..
      nomiG<-obj$namesGZ$nomiG
      b<-fixef(obj[[1]])[c("G0",nomiG)]
      b
}

logL<-function(fit, metodo=1){
#se metodo=1 takes the logLik from the lme fit without the G variables..
#e<- yy-fit0 #level0 residuals
# -(249/2)*log(2*pi)-.5*determinant(V)$modulus-(t(e)%*%solve(V) %*%e) /2
    if(metodo==1) return(logLik(fit$lme.fit.noG))
    if(class(fit[[1]])=="lme"){
      obj<-fit[[1]]
      All<-extract.lmeDesign(obj)
      #ZZ<-All$Z
      XX<-All$X
      yy<-All$y
      Off<-fit$Off
      V<-mgcv::extract.lme.cov(obj, data=obj$data)
     } else {
      #ZZ<-fit$Z
      XX<-fit$X
      yy<-fit$y
      V<-fit$V
      Off<-fit$Off
      }
    yy<-yy+Off #true response
    idG<-match(c("G0",fit$namesGZ$nomiG), colnames(XX))
    idG<-idG[!is.na(idG)]
    p<-ncol(XX) #including the changepoint parameters
    XX<-XX[,-idG]
    b<-fixef(obj)[-idG]
    #mu<-fitted.segmented.lme(.., level=0)
    #mu<-drop(XX%*%b)
    #sum(dmvnorm(yy, mu, V, log=TRUE)) #OK
    L<-chol(V) #L'L=V
    y1<-backsolve(L,yy,transpose=TRUE)
    X1<-backsolve(L,XX,transpose=TRUE)
    e1<-y1-drop(X1%*%b)
    n<-length(y1)
    #NB sum(log(diag(L)))  uguale a determinant(V, logarithm=TRUE)$modulus/2
    ll<- if(fit[[1]]$method=="REML") {
      (p-n)*log(2*pi)/2-sum(log(diag(L)))-drop(crossprod(e1))/2-as.numeric(determinant(crossprod(X1))$modulus)/2
      } else {-n/2*log(2*pi)-sum(log(diag(L)))-drop(crossprod(e1))/2}
    ll
    }


bootsegMix<-function(fit,B=10, display=FALSE, metodo=1, frac=1, it.max=6, it.max.b=5, seed=NULL, start=NULL){
#metodo: viene passato alla funzione logL. Se 1 la logL che viene calcolata  quella della componente
#   fit$lme.fit.noG, namely the logLik from the lme fit without the G variables..
#bootRestart for slme4
#fit: un oggetto di classe "segmented.lme" (anche proveniente da un altra "bootsegMix" call)
#frac: size of the boot resample..
#start : un vettor con i nomi (se non fornito gli starting values sono presi da fit)
#-----------------------
update.lme.call<-function (old.call, fixed., ..., evaluate=FALSE) {
    call <- old.call
    extras <- match.call(expand.dots = FALSE)$...
    if (!missing(fixed.)) call$fixed <- update.formula(call$fixed, fixed.)
    if (length(extras) > 0) {
        existing <- !is.na(match(names(extras), names(call)))
        for (a in names(extras)[existing]) call[[a]] <- extras[[a]]
        if (any(!existing)) {
            call <- c(as.list(call), extras[!existing])
            call <- as.call(call)
            }
        }
    if (evaluate) eval(call, parent.frame()) else call
    }
#---------
    N<-nlevels(fit$lme.fit$groups[[1]]) #n. of subjects
    newData<-fit$lme.fit$data
    nomeRispo<-all.vars(formula(fit$lme.fit))[1]
    #AGGIUSTA la risposta
    newData[,nomeRispo]<-newData[,nomeRispo] + fit$Off

    o.b<-fit$boot.call
#old:    start.psi<-extract.psi(fit)
#old:    est.psi<-start.psi["G0"]
#old:    call.b<-update(object=fit, obj=o.b, data=newD, psi=est.psi, display=FALSE, evaluate=FALSE)
    call.b<-update(object=fit, obj=o.b, data=newD, it.max=it.max.b,
          start=list(kappa0=startKappa0,kappa=startingKappa), display=FALSE, evaluate=FALSE)

    #mycall$data=quote(gh)
    o.ok<-update.lme.call(o.b, fixed.=y~.,evaluate=FALSE)
#old:    call.ok<-update(object=fit, obj=o.ok, data=newData, psi=est.psi.b, display=FALSE, evaluate=FALSE)

    call.ok<-update(object=fit, obj=o.ok, data=newData, it.max=it.max,
          start=list(kappa0=startKappa0.b,kappa=startingKappa.b), display=FALSE, evaluate=FALSE)

    all.L<-all.psi<-NULL
    it<-0
    L0<-L.orig<-logL(fit, metodo=metodo)
    if(display){
       flush.console()
        cat("original data:", 0, "  logLik =", formatC(as.numeric(L.orig), 3, format = "f"),"   psi parms:", formatC(extract.psi(fit),4,format="f"),"\n")
    }
    if(is.null(start)){
        startingKappa<-extract.psi(fit)
        startKappa0<- startingKappa[1]
        startingKappa<-startingKappa[-1]
        nomiKappa<-names(startingKappa)
        nomiKappa<-sapply(strsplit(nomiKappa, "G\\."),function(x)x[2])
        names(startingKappa) <- nomiKappa
    } else {
        nomiG<-sapply(strsplit(fit$namesGZ$nomiG, "G\\."),function(x)x[2])
        if(length(intersect(names(start), c("G0", nomiG)))!=length(start)) stop("'start' should include all the changepoint parameters")
        startKappa0<-start["G0"]
        startingKappa<-start[-which("G0"%in%names(start))]
        nomiKappa<-names(startingKappa)
    }
    if(!is.null(seed)) set.seed(seed)
    for(i in seq(B)){
       #build the boot sample
       #idx<-sample(N, replace=TRUE)
       idx<-sample(1:N, size=trunc(N*frac), replace=TRUE)
       newD<-do.call("rbind",lapply(idx, function(x)newData[newData$id==x,]))
       newD$y.b<- newD$y
       fit.b<-try(suppressWarnings(eval(call.b)), silent=TRUE) #envir=newD)
       if(!is.list(fit.b)){
#        fit.b<-NULL
        while(!is.list(fit.b)){
          idx<-sample(1:N, size=trunc(N*frac), replace=TRUE)
          newD<-do.call("rbind",lapply(idx, function(x)newData[newData$id==x,]))
          newD$y.b<- newD$y
          fit.b<-try(suppressWarnings(eval(call.b)), silent=TRUE) #envir=newD)
          }
       }
       if(is.list(fit.b)){
            #old: start.psi.b<-extract.psi(fit.b)
            #old: est.psi.b<-start.psi.b["G0"]
            startingKappa.b<-extract.psi(fit.b)
            startKappa0.b<- startingKappa.b[1]
            startingKappa.b<-startingKappa.b[-1]
            #NB "nomiKappa" dovrebbero essere sempre gli stessi
            names(startingKappa.b) <- nomiKappa
            fit.ok<-try(suppressWarnings(eval(call.ok)), silent=TRUE) # data=newData)
            L1<-if(is.list(fit.ok)) logL(fit.ok, metodo=metodo) else (-Inf)
            } else {
            stop("the first bootstrap fit is unsuccessful")
            }
       if(L0<L1) {
          fit<-fit.ok
          L0<-L1
          }
       all.psi[length(all.psi)+1]<-est.psi<-extract.psi(fit)["G0"]
       all.L[length(all.L)+1]<-L.ok<-max(L0,L1)
       it<-it+1
       if(display){
       flush.console()
        ll<-if(it<10) "  logLik =" else " logLik ="
        cat("boot resample:", it, ll, formatC(L.ok, 3, format = "f"),"   psi parms:", formatC(extract.psi(fit),4,format="f"),"\n")
       }
       startingKappa<-extract.psi(fit)
       startKappa0<- startingKappa[1]
       startingKappa<-startingKappa[-1]
       nomiKappa<-names(startingKappa)
       nomiKappa<-sapply(strsplit(nomiKappa, "G\\."),function(x)x[2])
       names(startingKappa) <- nomiKappa
       } #end boot replicates
    fit$history.boot.restart<-cbind(b=1:length(all.psi),psi=all.psi, logL=all.L)
    #r<-list(seg.lme.fit=fit, history=cbind(b=1:length(all.psi),psi=all.psi, logL=all.L) )
    fit
    }


print.segmented.lme<-function(x,...){
#    cat("*** Segmented Linear mixed-effects model ***\n")
    cat("Segmented Linear mixed-effects model \n")
    cat("  psi.link =", x$call$psi.link, "\n")
    if(!is.null(x$history.boot.restart)) {
    n.sol<-length(unique(x$history.boot.restart[,"psi"]))
    cat("  boot restart on", nrow(x$history.boot.restart), "samples; ", n.sol, "different solutions found\n")
    }
    cat("\n")
    print(x[[1]])
    }

#--------------------------------------------------------------------------------

seg.lme5a<- function(obj, Z, psi, z.psi=~1, x.diff=~1,
            random=NULL, #una lista quale 'list(id=pdDiag(~1+x+U+G0))'
            random.noG=NULL, #una lista senza G0. Se NULL viene aggiornata la formula di random escludendo "G0"
            start.pd=NULL, #una matrice come starting value
            psi.link=c("identity","logit"), nq=0, adjust=0,
            start=NULL, #*named* list list(delta0, delta, kappa) and the 'delta' component, dovrebbe essere anche
            #nominata con i nomi delle variabili in x.diff
            data,
            fixed.parms=NULL, #a *named* vector meaning the coefficients to be mantained fixed during the estimation
            tol=0.001, it.max=10, display=FALSE){
#obj is the lme fit or simply its call
#random: a list with a formula for the cluster variable 'id' and standard linear variables and "U" and "G0" meaning
#     random effects for the difference in slope and changepoint parameters. If it.max=0 the breakpoint is not estimated and
#     the formula should not include the term "G0".
#random = list(id=pdBlocked(list(pdDiag(~1+x), pdSymm(~U+G0-1))))
#random = list(id=pdBlocked(list(pdSymm(~1+x), pdSymm(~U+G0-1))))
#random=list(id=pdDiag(~1+weeks+U+G0))
#random=list(id=pdSymm(~1+weeks+U+G0))
#
#Problemi: se control?
#control = list(msVerbose = FALSE, niterEM = 100, opt = "optim")
#
#nq: no. obs che consentono di "invalidare" la stima del breakpoints.
# Ovvero se nq=0, gli \hat{\psi}_i sono annullati se \hat{\psi}_i<=min(Z_i) o \hat{\psi}>=max(z_i)
#        se nq>0 gli \hat{\psi}_i sono annullati se \hat{\psi}_i<=min(sort(z)[1:nq]) o \hat{\psi}>= max(rev(z)[1:nq]
#adjust valore numerico (0,1,2).
#   Se 0 i psi_i vengono stimati "normalmente" e alla convergenza al vettore numerico dei psi viene assegnato un
#   vettore di attributi che serve ad etichettare se il breakpoint ? plausibile o meno (secondo il valore di nq)
#   Se 1 i psi ottenuti alla fine dell'algoritm vengono aggiustati secondo il valore di nq. Ad es., se nq=1 il breakpoint
#   immediatamente prima del max (o dopo il min) vengono forzati al min/max e cos? sono di fatto annullati; naturalmente il
#   modello ? ristimato secondo  i nuovi psi. Se 2 l'aggiustamento viene fatto durante l'algoritmo..
#---------------------
    require(nlme)
    #------------------
    update.lme.call<-function (old.call, fixed., ..., evaluate=FALSE) {
    call <- old.call
    extras <- match.call(expand.dots = FALSE)$...
    if (!missing(fixed.)) call$fixed <- update.formula(call$fixed, fixed.)
    if (length(extras) > 0) {
        existing <- !is.na(match(names(extras), names(call)))
        for (a in names(extras)[existing]) call[[a]] <- extras[[a]]
        if (any(!existing)) {
            call <- c(as.list(call), extras[!existing])
            call <- as.call(call)
            }
        }
    if (evaluate) eval(call, parent.frame()) else call
    }
    #---------------------------------------------------------------------------
    f.pd<-function(obj){
    #dato un modello lme 'obj' restituisce una matrice pdMat che deve essere utilizzata come componente random
    #   nelle call "call.ok$random<-list(id=pd)"
          pdClasse<-class(obj$modelStruct$reStruct[[1]])[1]
          if(pdClasse=="pdBlocked"){ #assumiamo solo 2 blocchi..(? un LIMITE, ma ? facile generalizzare..)
              start.v<-unlist(lapply(obj$modelStruct$reStruct[[1]], function(z){as.numeric(z)}))
              cl1<-class(obj$modelStruct$reStruct[[1]][[1]])[1]
              cl2<-class(obj$modelStruct$reStruct[[1]][[2]])[1]
              fo1<-attr(obj$modelStruct$reStruct[[1]][[1]],"formula")
              fo2<-attr(obj$modelStruct$reStruct[[1]][[2]],"formula")
              no1<-attr(obj$modelStruct$reStruct[[1]][[1]],"Dimnames")[[1]]
              no2<-attr(obj$modelStruct$reStruct[[1]][[2]],"Dimnames")[[1]]
              pd<-pdBlocked(start.v, pdClass = c(cl1,cl2), nam = list(no1, no2), form=list(fo1, fo2))
                } else {
              fo<-attr(obj$modelStruct$reStruct[[1]],"formula")
              pd <- pdMat(as.numeric(obj$modelStruct$reStruct[[1]]), form = fo, pdClass = pdClasse)
                }
              pd}
    #---------------------------------------------------------------------------
    ###
    if(missing(psi) && it.max==0) stop("Please supply 'psi' with 'it.max=0'")
    if(!(is.call(obj) || class(obj)=="lme")) stop(" 'obj' should be a lme fit or a lme call")
    #if(names(obj$modelStruct[[1]])!="id")
    if(is.null(random)) {
      random=list(id=pdMat(as.numeric(obj$modelStruct$reStruct[[1]]),
          form=attr(obj$modelStruct[[1]][[1]],"formula"),
          pdClass=class(obj$modelStruct$reStruct[[1]])[1]))
      }
    psi.link<-match.arg(psi.link)
    logit<-function(xx,a,b){log((xx-a)/(b-xx))}
    inv.logit<-function(xx,a,b){((a+b*exp(xx))/(1+exp(xx)))}
    #Queste funzioni min1() e max1() restituiscono il "quasi" min o max
    if(nq>0){
        min1<-function(x,na.rm=FALSE){x<-sort(x)[-(1:nq)];min(x,na.rm=na.rm)}
        max1<-function(x,na.rm=FALSE){x<-rev(x)[-(1:nq)];max(x,na.rm=na.rm)}
        } else {
        min1<-min
        max1<-max
        }
    adjust<-max(min(adjust,2),0)  #solo 0,1,2 sono consentiti..
    #--------------------------
    my.call<-if(is.call(obj)) obj else obj$call
    #------------------------
    if(as.character(my.call$random[[1]])!="list") stop("please, use a list to specify the random part") #vedi gamm() per un approccio pi? elegnate?
    name.group<-names(eval(my.call$random))
    name.Z<-deparse(substitute(Z))
    if(is.null(my.call$data)) stop("`obj' should include the argument `data'")
    allNOMI<-unique(c(name.Z, name.group, all.vars(my.call$fixed), all.vars(my.call$random),
        all.vars(z.psi), all.vars(x.diff)))
    formTUTTI<-as.formula(paste("~.+", paste(allNOMI,collapse="+")))
    formTUTTI<-update.formula(my.call$fixed, as.formula(paste("~.+", paste(allNOMI,collapse="+"))))
    anyFixedG<-FALSE
    if(!is.null(fixed.parms)){
      name.fixed.butG0<-setdiff(names(fixed.parms),"G0") #nomi dei termini fissi escluso G0
      anyFixedG<-if(length(name.fixed.butG0)>=1) TRUE else FALSE #ci sono fixed coef nel submodel of psi?
      if(anyFixedG){
         formTUTTI<-update.formula(formTUTTI, as.formula(paste("~.+", paste(name.fixed.butG0,collapse="+"))))
         }
      }
    if(missing(data)) {
        mf<-model.frame(formTUTTI, data=eval(my.call$data), na.action=na.omit)
        } else {
        mf<-model.frame(formTUTTI, data=data, na.action=na.omit)
        }
    nomeRispo<-names(mf)[1]
    Rispo<-model.response(mf)
    #
    Z <- mf[[name.Z]]
    id <- mf[[name.group]] #obj$groups[,1]
    ni<- tapply(id, id, length) #vector of cluster sizes
    N<-length(ni)#n. of clusters (subjects)
    n<-length(id) #n. of total measurements

    id.x.diff<-FALSE
    id.z.psi<-FALSE
    #M.z.psi <- mf[all.vars(z.psi)] #
    #M.x.diff <- mf[all.vars(x.diff)] #

    M.z.psi <- model.matrix(z.psi, data = mf)
    if("(Intercept)"%in%colnames(M.z.psi)) M.z.psi<-M.z.psi[,-match("(Intercept)", colnames(M.z.psi)),drop=FALSE]
    M.x.diff <- model.matrix(x.diff, data = mf)
    if("(Intercept)"%in%colnames(M.x.diff)) M.x.diff<-M.x.diff[,-match("(Intercept)", colnames(M.x.diff)),drop=FALSE]

    fixed<-"U+G0" #fixed<-"U"
    nomiG<-NULL #se non ci sono explicative nel changepoint (se ci sono poi viene sovrascritto)
    namesGZ<-list(nameZ=name.Z)

    Offs.kappa<-0
    if(NCOL(M.z.psi)>0){
          id.z.psi <- TRUE
          Z.psi  <- data.matrix(M.z.psi)
          if(anyFixedG){
            if(!all(name.fixed.butG0 %in% colnames(M.z.psi))) stop("variable(s) in 'fixed.parms' should be included in 'z.psi'")
            Offs.kappa<-Fixed.z.psi<-drop(Z.psi[, name.fixed.butG0, drop=FALSE]%*% fixed.parms[name.fixed.butG0])
            Z.psi<-Z.psi[,setdiff(colnames(Z.psi), name.fixed.butG0), drop=FALSE]
            }
          if(ncol(Z.psi)>0){
            nomiG<-paste("G.",colnames(Z.psi),sep="") #paste("G.",colnames(M.z.psi)[-1],sep="")
            namesGZ$nomiG<-nomiG
            fixed<-paste(fixed,paste(nomiG,collapse="+"),sep="+")
            } else {
              id.z.psi <- FALSE
              }
          } else { #se NCOL(M.z.psi)<=0
            if(anyFixedG) stop("variable(s) in 'fixed.parms' should be included in 'z.psi' ")
          }
    if(NCOL(M.x.diff)>0) {
          X.diff <- data.matrix(M.x.diff) #eval(obj$call$data)[,deparse(substitute(x.diff))]
          id.x.diff <- TRUE
          nomiUx<-paste("U.",colnames(M.x.diff),sep="")
          namesGZ$nomiUx<-nomiUx
          fixed<-paste(fixed,paste(nomiUx,collapse="+"),sep="+")
          }
    min.Z<-min1(Z)
    max.Z<-max1(Z)
    mf["U"]<-rep(1,length(id))
    #if(!is.null(obj$data)) my.dd<-cbind(obj$data,my.dd)
    if(name.group!="id") mf['id']<-mf[name.group] #costruisci un'altra variabile di clustering con il nome id
    mf[name.Z]<- Z

    est.kappa0<-TRUE
    if("G0" %in% names(fixed.parms)) {
        est.kappa0<-FALSE
        kappa0<-kappa0Fixed<-fixed.parms["G0"]
        }

    if(est.kappa0){
      if(!is.null(start$kappa0)) {
      psi<-if(psi.link=="logit") inv.logit(start$kappa0,min.Z,max.Z) else start$kappa0
      }
      if(missing(psi)){
        formulaFix.Poly<-update.formula(my.call$fixed, paste("~.+",name.Z,"+",paste("I(",name.Z,"^2)",sep="")))
        obj2<-update.lme.call(my.call, fixed = formulaFix.Poly, data=mf, evaluate=TRUE)
        psi<- -fixed.effects(obj2)[name.Z]/(2*fixed.effects(obj2)[paste("I(",name.Z,"^2)",sep="")])
        }
      } else { #se ? fissato e quindi non devi stimarlo
      psi<- kappa0
      }
    psi.new <- psi #stime iniziali
    if(length(psi)!=1 && length(psi)!=N) stop("length(psi) has to be equal to 1 or n. of clusters")
    if(length(psi) == 1) {
        psi.new <- rep(psi.new, N) #subj-specific changepoints
        }
    psi.ex<-rep(psi.new, ni ) #length = N (n. tot obs)

    #----------------------------------------
    mf$U<- pmax(0, Z-psi.ex)
    formulaFix.noG<-update.formula(my.call$fixed, paste("~.+","U"))
    if(id.x.diff){
        Ux<- as.matrix(mf$U*X.diff)
        colnames(Ux)<-nomiUx
        mf<-cbind(mf,Ux) #$Ux<- my.dd$U*X.diff
        formulaFix.noG<-update.formula(my.call$fixed, paste(".~.+U+",paste(nomiUx,collapse="+"),sep=""))
        }
    #se vuoi assumere i psi fissi (it.max=0)
    if(it.max==0) {
        #aggiorna i random effects. Attenzione in tal caso random deve essere "U" ( o "1").
        #Se fosse "U+G0" darebbe errore perch G0 non esiste
        #Oppure dovresti modificare la formula di random,
        #attr(random[[1]], "formula")<-update.formula(attr(random[[1]], "formula"), ~.-G0)
        formulaRand<-formulaRandOrig<-my.call$random
        call.ok<-update.lme.call(my.call, fixed = formulaFix.noG, random=random, data=mf, evaluate=FALSE)
        o<-eval(call.ok)
        return(o)
        } #end if(it.max=0)
#---------------------------------------------------------------------------
    #should we fit a preliminary model? extract starting values
    start.delta0<-start$delta0
    if(id.x.diff) start.delta<-start$delta
    need.prelim<- (is.null(start.delta0) || (id.x.diff && is.null(start.delta)))
    if(need.prelim){
      o<-update.lme.call(my.call, fixed=formulaFix.noG, data=mf, evaluate=TRUE)
      delta0i<-unlist(coef(o)["U"]) #length= N
      if(id.x.diff) delta<-fixed.effects(o)[nomiUx] #length= n.1
      } else {
       delta0i<-if(length(start.delta0)==N) start.delta0 else rep(start.delta0,N)
       if(id.x.diff) delta<-start.delta[nomiUx]
      }

    start.kappa<-start$kappa

    eta.psi<-0

    if(id.z.psi) {
        if(is.null(start.kappa)) {
          kappa<- rep(0, ncol(Z.psi))
          names(kappa)<-nomiG
          eta.psi<-rep(0,nrow(Z.psi))
          } else {
          kappa<-start.kappa
          names(kappa)<-paste("G.",names(kappa),sep="")
          if((length(kappa)!=NCOL(M.z.psi)) || any(is.na(match(names(kappa), nomiG)))) stop("error in the names/length of start.kappa")
          eta.psi <- drop(Z.psi%*%kappa)
          }
        }
#################################
    if(anyFixedG) eta.psi<- eta.psi + Offs.kappa
    #Offs.kappa<-data.matrix(mf[name.fixed.butG0])%*%fixed.parms[name.fixed.butG0]

    #-----------------------------------------------------------
    formulaFix<-update.formula(my.call$fixed, paste(".~.+",fixed))

    if(!est.kappa0) formulaFix<-update.formula(formulaFix, .~.-G0)
    formulaRand<-formulaRandOrig<-my.call$random
    minMax<-cbind(tapply(Z,id,min1),tapply(Z,id,max1)) #matrice nx2 dei min-max
    #---------------------------------------------------------
    call.ok<-update.lme.call(my.call, fixed = formulaFix, random=random, data=mf, evaluate=FALSE,
        control = list(msVerbose = FALSE, niterEM = 100, opt = "optim"))
    if(!is.null(start.pd)) call.ok$random<-quote(list(id=start.pd))
    #--------------------------------------------------------
    kappa0i  <- if(psi.link=="logit") logit(psi.ex,min.Z,max.Z)  else psi.ex #length=n
    if(est.kappa0) kappa0<-mean(kappa0i)
    ki<-kappa0i-kappa0
    etai<- kappa0i + eta.psi
    psi.ex<-if(psi.link=="logit") inv.logit(etai,min.Z,max.Z) else etai  #length=n

    #----------------------------------------------------------
    boot.call<-update.lme.call(my.call, y.b~., data=newData, evaluate=FALSE) #salva la call before modifying obj
    it <- 1
    epsilon <- 9
    obj<-o #serve per estrarre la logLik
    b.new<-rep(.1,length(all.vars(formulaFix))) #la risposta conteggiata in all.vars(formulaFix) conta per l'intecetta

    while(abs(epsilon) > tol){
        DD<-if(psi.link=="logit") (max.Z-min.Z)*exp(etai)/((1+exp(etai))^2) else rep(1,n)
        V<-ifelse(Z >psi.ex, -1, 0)
        VD <- V*DD
        mf$U <- pmax(0, Z-psi.ex)
        mf$G0<- rep(delta0i,ni)*VD #rowSums(rep(delta0i,ni)*VD)
        if(id.x.diff){
            Ux<- as.matrix(mf$U*X.diff)
            colnames(Ux)<-nomiUx
            mf[,which(names(mf)%in%nomiUx)]<-Ux
            deltaMatrix<-cbind(rep(delta0i,ni), matrix(delta,nrow=length(V),ncol=length(delta),byrow=TRUE))
            deltaVDx<-deltaMatrix*VD*cbind(1,M.x.diff)
            mf$G0<-rowSums(deltaVDx)
            }
        if(id.z.psi){
            G<-cbind(mf$G0,mf$G0*M.z.psi)
            colnames(G)<-c("G0",nomiG)
            mf[,colnames(G)]<-G
            }
        dev.old <- obj$logLik
        #costruisci l'offset e modifica la risposta..
        Off<- if(est.kappa0)  -kappa0i*mf$G0 else -ki*mf$G0
        if(id.z.psi) Off<- Off - drop(as.matrix(mf[nomiG])%*%kappa[nomiG])
        mf[nomeRispo]<-Rispo-Off
        # estimate the model
        ########################################
        obj<-eval(call.ok)
        ########################################
        b.old<-b.new
        b.new<-fixed.effects(obj)
###    if(psi.new>max(Z)| psi.new<min(Z)) stop("estimated psi out of range: try another starting value!")
        dev.new <- obj$logLik#sum((fitted(obj)-my.dd[,paste(formula(obj))[2]])^2) #
        if(display){
            flush.console()
            if(it == 1) cat(0," ",formatC(dev.old,3,format="f"),"",
                "(No breakpoint(s))","\n")
            spp <- if(it < 10) "" else NULL
            cat(it,spp,"",formatC(dev.new,3,format="f"),formatC(abs(epsilon),3,format="f"),"\n")
            }
        epsilon <- abs((dev.new-dev.old)/(dev.old+.1))
        #epsilon <- max(abs((b.new-b.old)/b.old))
        if(it >= it.max) break
        if(abs(epsilon) <= tol) break
        it <- it+1
        #stopping rules not met: update the estimates
        ##-------------------------------

        #delta0i<-if(inflate.res) inflate.2residuals(obj, coeff=TRUE)[,"U"] else unlist(coef(obj)["U"])    #length=N
        if(id.x.diff) delta <- fixed.effects(obj)[nomiUx]
        delta0i<-unlist(coef(obj)["U"])

        if(est.kappa0){
            kappa0.old<-kappa0 #length=1
            kappa0 <- fixed.effects(obj)["G0"]
            #questo controllo ? sbagliato se link.psi="logit"
            #if(kappa0<= min(Z) || kappa0>=max(Z)) stop("estimated psi outside the range")
            }
        kappa0i.old<-kappa0i #length=n
        ki<-if("G0"%in%names(ranef(obj))) unlist(ranef(obj)["G0"]) else rep(0,N)
        kappa0i <- kappa0+ki #length=N
        #kappa0i <-if(inflate.res) inflate.2residuals(obj, coeff=TRUE)[,"G0"] else unlist(coef(obj)["G0"]) #length=N
        kappa0i<-rep(kappa0i,ni) #+ kappa0i.old #length=n
        ki<-rep(ki,ni)
        etai<-kappa0i
        if(id.z.psi) {
            kappa.old<-kappa #length=1
            kappa<-fixed.effects(obj)[nomiG]  #esclude G0..
            etai<-etai+drop(Z.psi%*%kappa)
            }
        if(anyFixedG){
          etai <- etai+ Offs.kappa
            }
        psi.old <- psi.ex #length=n.obs
        psi.ex<-if(psi.link=="logit") inv.logit(etai,min.Z,max.Z) else etai  #length=n
        #eventuale aggiustamento dei psi.
#        if(adjust==2){
#            id.bp<-I(psi.new>minMax[,1]&psi.new<minMax[,2])
#            psi.new[!id.bp] <- tapply(Z,id,max)[!id.bp]# minMax[!id.bp,2]
#            }
        pd<-f.pd(obj)
        call.ok$random<-quote(list(id=pd))
#        if(it > it.max) break
#        if(abs(epsilon) <= tol) break
        } #end_while
#---------------------------------------------------------------------------------------
#Adesso devi fare in modo che le linee *veramente si uniscano (no salti), boot restarting e
#valore di logLik ed infine aggiorna obj<-eval(call.ok)

    fixed.noG<-update.formula(call.ok$fixed, paste(".~.-G0-",paste(nomiG, collapse="-"),sep=""))
    if(is.null(random.noG)){
        random.noG<-random
        #Escludi G0 dalla formula random..
        #  -qui se random  un'unica formula tipo 'list(id=pdDiag(~1+weeks+U+G0))' (o forse anche 'list(id=pdSymm(~1+weeks+U+G0))'
        attr(random.noG[[1]], "formula")<- update.formula(attr(random[[1]], "formula"), ~.-G0)#~1 + weeks + U
        #  -qui se random  una lista di formule 'list(id=pdBlocked(list(pdSymm(~1+weeks), pdSymm(~U-1))))'
        #attr(random.noG[[1]][[2]], "formula")<-update.formula(attr(random.noG[[1]][[2]], "formula"),~.-G0)
        }
    call.ok.noG<-update.lme.call(call.ok, fixed = fixed.noG, random = random.noG)
    mf[nomeRispo]<-Rispo
    obj.noG<-eval(call.ok.noG)

    if(it > it.max) warning("max iterations achieved", call. = FALSE)
    psi.new<-psi.ex[cumsum(ni)]
    names(psi.new)<-levels(unlist(obj$groups))
    id.bp<-I(psi.new>minMax[,1]&psi.new<minMax[,2])

    #mf$rispo<-Rispo
    #o.new<-lme.formula(rispo ~ x + U + U.x.diff, data = mf, random=list(id=pdDiag(~1+x+U)), method=..)
    #return(o.new)

    if(adjust==1){
#ristima il modello con i nuovi psi ( e le nuove variabili)
        psi.new[!id.bp] <- tapply(Z,id,max)[!id.bp]# minMax[!id.bp,2]
        psi.ex <- rep(psi.new, aa) #length=n.obs
        DD<-fn1(c(rep(kappa0,aa),kappa1), Z.psi ,2, link=psi.link) #length=n.obs
        V<-ifelse(Z >psi.ex, -1, 0)
        my.dd$U<- pmax(0, Z -psi.ex)
        VD <- V*DD
        deltaMatrix<-cbind(rep(betaa,aa), matrix(delta,nrow=length(V),ncol=length(delta),byrow=TRUE))
        deltaVDx<-deltaMatrix*VD*M.x.diff
        G0<-rowSums(deltaVDx)
        G<-G0*M.z.psi
        colnames(G)<-c("G0",paste("G.",colnames(M.z.psi)[-1],collapse="+",sep=""))
        my.dd<-cbind(my.dd, G)
        dev.old <- obj$logLik
        #stima il modello:
        obj<-eval(call.ok)
        }

    attr(psi.new,which="is.break")<-id.bp
    #if(id.z.psi) names(kappa)<- colnames(M.z.psi) #? gi? fatto prima
    RIS <- list("lme.fit"=obj, "lme.fit.noG"=obj.noG, "est.psi"=psi.new, call=match.call())
    if(!is.null(fixed.parms)) RIS$fixed.parms<-fixed.parms
    if(id.z.psi) {
        RIS$fixed.eta.psi<-drop(as.matrix(cbind(1,M.z.psi[cumsum(ni),]))%*%c(kappa0,kappa))
        }
    if(id.x.diff) {
        RIS$fixed.eta.delta<-drop(as.matrix(cbind(1,M.x.diff[cumsum(ni),]))%*%fixef(obj)[c("U",nomiUx)])
        }
    RIS$call$psi.link<-psi.link #in questo modo il nome ? "completo"..
    RIS$boot.call<-boot.call
    RIS$namesGZ<-namesGZ
    RIS$Off<-Off
    class(RIS)<-"segmented.lme"
    RIS
}


sim.seg<-function(N=30,n=c(5,20),fixEff=c(2,-.2,.3, .4),S=diag(c(.05,.05,.05,.07)^2),
            psi.link = c("identity", "logit"),
            psii=NULL,
            #psi=c(0.5,"rnorm(n, 0, .07)","identity"), #la var=.05, .07, .1)
            z.psi, x.diff,  #x.diff=list(.1,rbinom(N,size=1,prob=.5) )
            sd.epsilon=.01, seed, display=FALSE){
    require(MASS) #per mvrnorm()
    id.psi.assegnati<-FALSE
    if(length(psii)==N) {
     id.psi.assegnati<-TRUE
     psi.valori<-psii
    }
    psi.link<-match.arg(psi.link)
    if(!psi.link%in%c("identity","logit")) stop("invalid 'psi.link'")
    logit<-function(x)log(x/(1-x))
    #logit<-function(xx,a,b){log((xx-a)/(b-xx))}
    #inv.logit<-function(xx,a,b){((a+b*exp(xx))/(1+exp(xx)))}
    if(length(fixEff)!=4) stop("Exactly four fixed effect values should be supplied in 'fixEff'.")
    if(ncol(S)!=nrow(S)) stop("'S' should be a 4x4 square matrix")
    if(length(fixEff)!=ncol(S)) stop("dimension of 'S' and length 'fixEff' do not match")
    if(!missing(seed)) set.seed(seed)
    RANEF<-mvrnorm(n = N, mu=rep(0,ncol(S)), Sigma=S, empirical=FALSE)
    COEF<-t(t(RANEF) + fixEff)
    if(length(fixEff)==3){
    #oramai non serve.. perch? length(fixEff)=4
        COEF<-cbind(COEF,1)
        RANEF<-cbind(RANEF,1)
        kappa0<-eval(parse(text=psi[1]))
        ki<-RANEF[,4]<-eval(parse(text=psi[2]))
        kappa0i<-COEF[,4]<-kappa0+ki
        } else {
        kappa0i<-COEF[,4]
        kappa0<-fixEff[4]
        }
    colnames(COEF)<-c("beta0i","beta1i","deltai","kappa0i")
    colnames(RANEF)<-c("b0i","b1i","di","ki")
    #esplicative nella diffSlope e psi
    kappa1<-delta1<-0
    xx.diff<-zz.psi<-rep(0,N)
    id.x.diff<-id.z.psi<-FALSE
    if(!missing(x.diff)){
          id.x.diff<-TRUE
          delta1<-x.diff[[1]]
          xx.diff<-if(length(x.diff)==1) {rep(c(0,1),c(ceiling(N/2), floor(N/2)))} else {x.diff[[2]]}
          if(length(xx.diff)!=N) stop("x.diff must be a N-vector")
          }
    if(!missing(z.psi)){
          id.z.psi<-TRUE
          kappa1<-z.psi[[1]]
          zz.psi<-if(length(z.psi)==1) {rep(c(0,1),length=N)} else {z.psi[[2]]}
          if(length(zz.psi)!=N) stop("z.psi must be a N-vector")
          }
    fixed.eta.psi<- if(id.z.psi) kappa0+kappa1*zz.psi else kappa0
    eta.psi<-if(id.z.psi) kappa0i+kappa1*zz.psi else kappa0i
    if(psi.link=="identity"){
        psi.ok<-eta.psi
        fixed.psi.ok<-fixed.eta.psi
        } else {
        psi.ok<-plogis(eta.psi)
        fixed.psi.ok<-plogis(fixed.eta.psi)
        }
    if(id.psi.assegnati) psi.ok<-psi.valori
    ni<-sample(min(n):max(n),size=N, replace=TRUE) #rpois(N, ni) oppure MASS::rnegbin(n,ni,theta=1)? theta->Inf ? poisson..
    if(length(n)==N) ni <- n
    if(length(n)==1) ni <- rep(n,N)
    X<-Y<-list()
    for(i in 1:N){
        #xi<-sort(runif(ni[i],0,1))
        xi<-seq(0,1, length=ni[i])
        Xi<-cbind(1,xi,pmax(xi-psi.ok[i],0))
        etai<-drop(Xi%*%COEF[i,1:3])+delta1*xx.diff[i]*pmax(xi-psi.ok[i],0)
        yi<- etai + rnorm(ni[i],0,sd.epsilon)
        #X[i,]<-xi
        #Y[i,]<-yi
        X[[length(X)+1]]<-xi
        Y[[length(Y)+1]]<-yi
        }
    #Ris<-data.frame(cbind(id=rep(1:n,times=k), y=as.vector(t(Y)),x=as.vector(t(X))))
    Ris<-data.frame(cbind(id=rep(1:N,times=ni), time=unlist(sapply(ni, function(xx){1:xx})),
        y=unlist(Y),x=unlist(X)))
    if(id.x.diff) Ris$x.diff<-rep(xx.diff,times=ni)
    if(id.z.psi) Ris$z.psi<- rep(zz.psi,times=ni)
        if(display) {
            plot(y~x, data=Ris, type="n")
            xx<-seq(0,1,length=100)
            for(i in 1:N) {
                lines(Ris[Ris[,1]==i,3],Ris[Ris[,1]==i,2],col=grey(.7))
                points(y~x, data=Ris, pch=19, cex=.6)
                #questo ? per aggiungere la relazione segmented di effetti fissi..
                psi.i<-fixed.psi.ok[i]
                #psi.i<-psi.ok[i]
                segFix.i<- fixEff[1]+fixEff[2]*xx+(fixEff[3]+delta1*xx.diff[i])*pmax(xx-psi.i,0)
                points(xx, segFix.i, type="l",lwd=2, col=2)
                }
            }
    names(fixEff)<-c("beta0","beta1","delta0","kappa0")
    FixEff<-  c(fixEff, delta1=delta1, kappa1=kappa1)
    call<-match.call()
    Ris<-list(data=Ris,coef=COEF,fixef=FixEff,ranef=RANEF,psii=psi.ok,var=S,ni=ni,call=call)
    return(Ris)
    }
