
           m=c(100, 500, 1000, 5000)
           phi=0.6
           lambda=1.5
           P=seq(0.1,0.90,by=0.1)           
           
           g<-function(a,b)
           {
                 if(a==b)
                 return(1)
                 else 
                 return(0)
            }
            
            
postscript("p_interval_mle.pdf", height=8, width=8)
par(mfrow=c(2,2)) 
 
for(ii in 1:length(m))
{
    n=m[ii]
    mse_p_mle=matrix(0,length(P),1)
    phat_mle=matrix(0,length(P),1)
    
    for(pp in 1:length(P))
    {
         p=P[pp]           
         p_mle=NULL                                           
         MCsz=500
         
         for(tt in 1:MCsz)
         {                 
                      #set.seed(2) 
                      y=NULL   
                      y[1]=rpois(1,lambda)
   
                      prob=NULL
                      for(j in c(1:11))
                      {
                            k=seq(0,10)
                            prob[j]=(exp(-lambda)*lambda^(j-1))/(factorial(j-1))
                      }

                      q=NULL
                      for(i in 1:(n-1))
                      {
                           for(j in c(1:11))
                           {
                                 d=j-1
                                 q[j]=phi*g(y[i],d)+(1-phi)*prob[j]
                           } 
                           y[i+1]=sample(0:10,1,replace=T,q)
                       }                      
                       z=NULL
                       for(i in 1:n)
                       {
                            x=rbinom(1,1,p)
                            z[i]=x*y[i]            # Simulation of z[1],z[2],....z[n] ~ z_t = x_t y_t    
                       }
                            
                       likelihood=function(x)
                       {
                           phihat=x[1]
                           lambdahat=x[2]
                           phat=x[3]

                           if(z[1]==0)
                           f=log(1-phat+phat*exp(-lambdahat))
                           else
                           f=log(phat*exp(-lambdahat)*lambdahat^z[1]/factorial(z[1]))
       
                           for(i in 1:(n-1))
                           {
                                if(z[i]==0 && z[i+1]==0)
                                f=f+log(1-phat+phat*exp(-lambdahat)+{phat^2*phihat*exp(-lambdahat)*(1-exp(-lambdahat))}/{1-phat+phat*exp(-lambdahat)})
                                else if(z[i]==0 && z[i+1]!=0)
                                f=f+log(phat*{1-phat+phat*exp(-lambdahat)*(1-phihat)}*{exp(-lambdahat)*lambdahat^z[i+1]}/{{1-phat+phat*exp(-lambdahat)}*factorial(z[i+1])})
                                else if(z[i]!=0 && z[i+1]==0)
                                f=f+log(1-phat+phat*exp(-lambdahat)*(1-phihat))  
                                else if(z[i]!=0 && z[i+1]!=0)
                                f=f+log(phat*{phihat*g(z[i+1],z[i])+(1-phihat)*exp(-lambdahat)*lambdahat^z[i+1]/factorial(z[i+1])})
                            }
                            return(-f)
                         }
                         opt<-optim(fn=likelihood, lower=c(0.01,0.01,0.01), upper=c(0.99,5,0.99),  par=c(0.5,4,0.5))
                         print(opt$par)
     
                         p_mle[tt]=opt$par[3]
              }
              mse_p_mle[pp]=sum((p_mle-mean(p_mle))^2)/MCsz
              phat_mle[pp]=mean(p_mle)
     } 
 
   plot(P, type="l", ylab=expression(paste("Estimated values of ",pi[0],"")), xlab=expression(paste("Actual values of ",pi[0],"")), ylim=c(0, 1.3), lty=1, axes=FALSE, 
   main=paste("n",m[ii], sep="="))
   axis(1, at=seq(1,length(P), by=2), lab=c(0,0.25, 0.5, 0.75, 1))
   axis(2, las=1, at=c(0, 0.4, 0.8,  1.2))
   box()
   lines(phat_mle, lty=2)
   lines((phat_mle-1.96*sqrt(mse_p_mle)), lty=3)
   lines((phat_mle+1.96*sqrt(mse_p_mle)), lty=3)
   legend(2, 1.2, c(expression(paste("estimated ",pi[0],"")), expression(paste("actual ",pi[0],""))), lty=c(2,1))
}   
dev.off()    
       
                            
                            
                            
                            
                      
