loglik.plot <- function(fit1, fit2, fit3, fit4, fit5, fit6, fit7, fit8) {
  ylim.ar1 <- range(c(fit1$loglik.trace, fit2$loglik.trace, fit3$loglik.trace, fit4$loglik.trace))
  ylim.ar2 <- range(c(fit5$loglik.trace, fit6$loglik.trace, fit7$loglik.trace, fit8$loglik.trace))
  legend.ar1 <- c(paste("Poisson + AR(1): AIC =", round(fit1$aic, 1)),
                  paste(     "NB + AR(1): AIC =", round(fit2$aic, 1)),
                  paste(    "ZIP + AR(1): AIC =", round(fit3$aic, 1)),
                  paste(   "ZINB + AR(1): AIC =", round(fit4$aic, 1)))
  legend.ar2 <- c(paste("Poisson + AR(2): AIC =", round(fit5$aic, 1)),
                  paste(     "NB + AR(2): AIC =", round(fit6$aic, 1)),
                  paste(    "ZIP + AR(2): AIC =", round(fit7$aic, 1)),
                  paste(   "ZINB + AR(2): AIC =", round(fit8$aic, 1)))
  par(mfcol = c(2, 1))
  plot(fit1$loglik.trace, lty = 1, col = 1, xlab = "Iteration", ylab = "Log-likelihood", ylim = ylim.ar1)
    lines(fit2$loglik.trace, lty = 2, col = 2)
    lines(fit3$loglik.trace, lty = 3, col = 3)
    lines(fit4$loglik.trace, lty = 4, col = 4)
    legend("bottomright", box.lty = 0, lty = 1:4, col = 1:4, legend = legend.ar1)
  plot(fit5$loglik.trace, lty = 1, col = 5, xlab = "Iteration", ylab = "Log-likelihood", ylim = ylim.ar2)
    lines(fit6$loglik.trace, lty = 2, col = 6)
    lines(fit7$loglik.trace, lty = 3, col = 7)
    lines(fit8$loglik.trace, lty = 4, col = 8)
    legend("bottomright", box.lty = 0, lty = 1:4, col = 5:8, legend = legend.ar2)
}

para.plot <- function(fit1, fit2, fit3, fit4, fit5, fit6, fit7, fit8, k.inv = FALSE, sigma.sq = FALSE) {
  par(mfcol = c(4, 2))
  dzim.plot(fit1, k.inv = k.inv, sigma.sq = sigma.sq, main = "Poisson + AR(1)")
  dzim.plot(fit2, k.inv = k.inv, sigma.sq = sigma.sq, main = "NB + AR(1)")
  dzim.plot(fit3, k.inv = k.inv, sigma.sq = sigma.sq, main = "ZIP + AR(1)")
  dzim.plot(fit4, k.inv = k.inv, sigma.sq = sigma.sq, main = "ZINB + AR(1)")
  dzim.plot(fit5, k.inv = k.inv, sigma.sq = sigma.sq, main = "Poisson + AR(2)")
  dzim.plot(fit6, k.inv = k.inv, sigma.sq = sigma.sq, main = "NB + AR(2)")
  dzim.plot(fit7, k.inv = k.inv, sigma.sq = sigma.sq, main = "ZIP + AR(2)")
  dzim.plot(fit8, k.inv = k.inv, sigma.sq = sigma.sq, main = "ZINB + AR(2)")
}

para.se <- function(fit1, fit2, fit3, fit4, fit5, fit6, fit7, fit8, k.inv = FALSE, sigma.sq = FALSE) { 
  f <- function(fit, k.inv = k.inv, sigma.sq = sigma.sq) {
    control <- fit$control
    para <- fit$para
    se <- fit$se
    if(k.inv == TRUE) {
      if(control$dist == "nb" | control$dist == "zinb") {
        if(control$dist == "nb")   ind <- 1
        if(control$dist == "zinb") ind <- 2
        names(para)[ind] <- "k.inv"
        para[ind] <- 1 / fit$para[ind]
        se[ind] <- fit$se[ind] / fit$para[ind]^2 
      }      
    }
    if(sigma.sq == TRUE) {
      len <- length(para)
      names(para)[len] <- "sigma.sq"
      para[len] <- fit$para[len]^2
      se[len] <- 2 * fit$para[len] * fit$se[len] 
    }
    print(round(cbind(para, se), 3))
  }
  cat("\n Poisson + AR(1): \n")
  f(fit1, k.inv = k.inv, sigma.sq = sigma.sq)
  cat("\n NB + AR(1): \n")
  f(fit2, k.inv = k.inv, sigma.sq = sigma.sq)
  cat("\n ZIP + AR(1): \n")
  f(fit3, k.inv = k.inv, sigma.sq = sigma.sq)
  cat("\n ZINB + AR(1): \n")
  f(fit4, k.inv = k.inv, sigma.sq = sigma.sq)
  cat("\n Poisson + AR(2): \n")
  f(fit5, k.inv = k.inv, sigma.sq = sigma.sq)
  cat("\n NB + AR(2): \n")
  f(fit6, k.inv = k.inv, sigma.sq = sigma.sq)
  cat("\n ZIP + AR(2): \n")
  f(fit7, k.inv = k.inv, sigma.sq = sigma.sq)
  cat("\n ZINB + AR(2): \n")
  f(fit8, k.inv = k.inv, sigma.sq = sigma.sq)
}
