library(ZIM)

set.seed(123)
data(injury)
y <- injury
t <- 1:length(y)
x <- (t > 57)

f <- function(dist, order) {
  dzim(y ~ x, dist = dist, order = order,
       trace = TRUE, N = 500, R = 500, niter = 500)
}

system.time(fit1 <- f('poisson', 1))
system.time(fit2 <- f('nb', 1))
system.time(fit3 <- f('zip', 1))
system.time(fit4 <- f('zinb', 1))
system.time(fit5 <- f('poisson', 2))
system.time(fit6 <- f('nb', 2))
system.time(fit7 <- f('zip', 2))
system.time(fit8 <- f('zinb', 2))

save(y, fit1, fit2, fit3, fit4, fit5, fit6, fit7, fit8, file = 'application.RData')
