library(ZIM)
source('../Functions.R')
load('application.RData')

pdf("application_loglik.pdf", width = 8, height = 10)
  loglik.plot(fit1, fit2, fit3, fit4, fit5, fit6, fit7, fit8)
dev.off()

pdf("application_para.pdf", width = 8, height = 10)
  para.plot(fit1, fit2, fit3, fit4, fit5, fit6, fit7, fit8, k.inv = TRUE, sigma.sq = FALSE)
dev.off()

pdf("application_ps.pdf", width = 8, height = 10)
  par(mfrow = c(2, 1))
  plot(y, type = "p", xaxt = "n", yaxt = "n", pch = 20, ylab = "Injury Count")
    axis(side = 1, at = seq(1, 96, 8))
    axis(side = 2, at = 0:9)
    mtext("Pre-intervention",  line = 1, at = 25, cex = 1.5)
    mtext("Post-intervention", line = 1, at = 80, cex = 1.5)
    abline(v = 57, lty = 3)
    lines(fit1$mu, lty = 1, col = "orange")
    lines(fit2$mu, lty = 2, col = "red")
    legend("topright", box.lty = 0, lty = 1:2, col = c("orange", "red"), legend = c("Poisson + AR(1)", "NB + AR(1)"))
  plot(y, type = "p", xaxt = "n", yaxt = "n", pch = 20, ylab = "Injury Count")
    axis(side = 1, at = seq(1, 96, 8))
    axis(side = 2, at = 0:9)
    mtext("Pre-intervention",  line = 1, at = 25, cex = 1.5)
    mtext("Post-intervention", line = 1, at = 80, cex = 1.5)
    abline(v = 57, lty = 3)
    lines(fit3$mu, lty = 1, col = "forestgreen")
    lines(fit4$mu, lty = 2, col = "blue")
    legend("topright", box.lty = 0, lty = 1:2, col = c("forestgreen", "blue"), legend = c("ZIP + AR(1)", "ZINB + AR(1)"))
dev.off()

para.se(fit1, fit2, fit3, fit4, fit5, fit6, fit7, fit8, k.inv = TRUE, sigma.sq = FALSE)


