library(ZIM)

set.seed(123)
n <- 200
t <- 1:n
x <- (t > n / 2)
X <- cbind(rep(1, n), x)
w <- rep(1, n)
omega <- 0.3
k <- 2.5
beta <- c(2, -1)
phi <- c(0.8, -0.6)
sigma <- 0.5
mu0 <- rep(0, 2)
Sigma0 <- diag(1, 2)
data <- dzim.sim(X, w, omega, k, beta, phi, sigma, mu0, Sigma0)
mu <- (1 - omega) * w * exp(X %*% beta + data$s[, 1])
y <- ts(data$y)

f <- function(dist, order) {
  dzim(y ~ x, dist = dist, order = order, 
       trace = TRUE, N = 500, R = 500, niter = 500)
}

system.time(fit1 <- f('poisson', 1))
system.time(fit2 <- f('nb', 1))
system.time(fit3 <- f('zip', 1))
system.time(fit4 <- f('zinb', 1))
system.time(fit5 <- f('poisson', 2))
system.time(fit6 <- f('nb', 2))
system.time(fit7 <- f('zip', 2))
system.time(fit8 <- f('zinb', 2))

save(y, mu, fit1, fit2, fit3, fit4, fit5, fit6, fit7, fit8, file = 'example.RData')



