# 
library(bbmle)
#
#
# data taken from:
# http://www.hpa.org.uk/webw/HPAweb\&HPAwebStandard/HPAweb_C/1233906819629?p=1191942169773
#
#Guy's & St. Thomas:
mcas.g <- c(49,28,28,19,42,32,40,41,46,36,48,35,31,25,18,28,30,21,16,13,14,18,21,19,13,16,8,10,8,7,2,8,6,2,6,2,1,2,2,1)
name.g <- "Guy's & St. Thomas"
#King's College Hospital
mcas.k <- c(12,22,30,28,20,35,27,26,28,34,25,20,18,16,10,20,20,20,28,31,15,12,27,16,8,12,11,8,14,4,14,9,7,9,6,4,2,4,7,3)
name.k <- "King's College Hospital"
#Leeds Teaching Hospital
mcas.l <- c(51,49,52,44,48,35,32,50,41,47,55,61,58,41,45,56,51,33,39,42,38,56,44,42,39,39,39,36,20,24,49,34,17,13,14,11,6,7,3,4)
name.l <- "Leeds Teaching Hospital"
#
mcas <- mcas.k
tijd <- 0:39
#
tp <- tijd[-length(tijd)]
tn <- tijd[-1]
#
barplot(mcas,names.arg=tijd,xlab="season",space=0,ylab="Number of detected prevalent cases",main=name.k)
#
################################################################################
################################################################################
#                               FITTING THE MODELS                             #
################################################################################
################################################################################
#
#
########################### MARTINGAlE  MODELS  ###############################
#
### 1. non-hom. martingale: gen gam ####
#
# reltol default  sqrt(.Machine$double.eps)=1.490116 10^(-8)
#
#
e.gg <- mle2(minuslogl=mll.gg, start=list(lp=1,lb=1,la=-.1), fixed=list(INV=FALSE),data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=(tijd)),method="Nelder-Mead",control=list(maxit=500000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(e.gg)
AIC(e.gg)
#
### 2. non-hom. martingale: gamma ####
#
e.g <- mle2(minuslogl=mll.gg, start=list(lp=1,lb=1,la=.1), fixed=list(INV=FALSE,la=0),data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),method="Nelder-Mead",control=list(maxit=500000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(e.g)
AIC(e.g)
#
#### 3. non-hom. martingale: weibull ####
#
e.w <- mle2(minuslogl=mll.gg, start=list(lp=1,lb=-1,la=-.1), fixed=list(INV=FALSE,lp=0),data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),method="Nelder-Mead",control=list(maxit=500000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(e.w)
AIC(e.w)
#
#### 4. non-hom. martingale: exp ####
#
e.e <- mle2(minuslogl=mll.gg, start=list(lp=2,lb=1,la=-1), fixed=list(INV=FALSE,lp=0,la=0),data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=3*tijd),method="Nelder-Mead",control=list(maxit=500000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(e.e)
AIC(e.e)
#
########################   BIRTH-DEATH MODELS  #################################
#
#### 5. birth-death: generalized gammma ####
#
bd.gg <- mle2(minuslogl=min.ll, start=list(lp1=2,lb1=-1,la1=-.1,lp2=1,lb2=-1,la2=-.1), data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),fixed=list(INV=FALSE),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(bd.gg)
AIC(bd.gg)
#
### 6. birth-death: gamma ###
#
bd.g <- mle2(minuslogl=min.ll, start=list(lp1=1,lb1=-1,la1=-.5,lp2=1,lb2=-1,la2=-.5), data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),fixed=list(INV=FALSE,la1=0,la2=0),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(bd.g)
AIC(bd.g)
#
### 7. birth-death: weibull###
#
bd.w <- mle2(minuslogl=min.ll, start=list(lp1=1,lb1=-1,la1=-.5,lp2=1,lb2=-1,la2=-.5), data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),fixed=list(INV=FALSE,lp1=0,lp2=0),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-6)*.Machine$double.eps))
summary(bd.w)
AIC(bd.w)
#
### 8.  birth-death: exp##
#
bd.e <- mle2(minuslogl=min.ll, start=list(lp1=1,lb1=1,la1=-.5,lp2=1,lb2=-1,la2=-.5), data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),fixed=list(INV=FALSE,lp1=0,lp2=0,la1=0,la2=0),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(bd.e)
AIC(bd.e)
#
### 9.  birth-death: birthrate exp; deathrate generalized gamma ###
#
bd.e.gg <- mle2(minuslogl=min.ll, start=list(lp1=1,lb1=.1,la1=-.5,lp2=1,lb2=1,la2=.5), data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),fixed=list(INV=FALSE,lp1=0,la1=0),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(bd.e.gg)
AIC(bd.e.gg)
#
### 10.  birth-death: birthrate exp deathrate gamma ###
#
bd.e.g <- mle2(minuslogl=min.ll, start=list(lp1=1,lb1=1,la1=-.5,lp2=-1,lb2=1,la2=-.5), data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),fixed=list(INV=FALSE,lp1=0,la1=0,la2=0),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(bd.e.g)
AIC(bd.e.g)
#
### 11.  birth-death: birthrate exp; deathrate weibul ###
#
bd.e.w <- mle2(minuslogl=min.ll, start=list(lp1=1,lb1=1,la1=-.5,lp2=1,lb2=1,la2=-.5), data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),fixed=list(INV=FALSE,lp1=0,la1=0,lp2=0),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(bd.e.w)
AIC(bd.e.w)
#
#### 12. birth-death: exponential deathrate; birthrate gen gam###
#
bd.gg.e <- mle2(minuslogl=min.ll, start=list(lp1=.1,lb1=-1,la1=-.5,lp2=1,lb2=1,la2=-.5), data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),fixed=list(INV=FALSE,lp2=0,la2=0),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(bd.gg.e)
AIC(bd.gg.e)
#
#### 13. exponential deathrate; birth rate gamma ###
#
bd.g.e <- mle2(minuslogl=min.ll, start=list(lp1=1,lb1=.1,la1=-.5,lp2=1,lb2=1,la2=-.5), data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),fixed=list(INV=FALSE,lp2=0,la2=0,la1=0),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(bd.g.e)
AIC(bd.g.e)
#
#### 14. birth-death: exponential deathrate; birthrate weibull###
#
bd.w.e <- mle2(minuslogl=min.ll, start=list(lp1=1,lb1=1,la1=-.5,lp2=1,lb2=-1,la2=-.5), data=list(ynul=mcas[-length(mcas)],y=mcas[-1],time=tijd),fixed=list(INV=FALSE,lp2=0,la2=0,lp1=0),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps))
summary(bd.w.e)
AIC(bd.w.e)
#
#
#
################################################################################
################################################################################
#     PLOTS
#           generalized gamma model non-homo. martingale
#    a=1:gamma; p=1:weibull; a=1&p=1: exponential
################################################################################
fit.e <- e.g
#plot(profile(fit.e),which=1)
#
est.fit <- coef(fit.e)
#
hazard <- 1-Sggamma(q=tn,p=exp(est.fit[1]),b=exp(est.fit[2]),a=exp(est.fit[3]),Inver=FALSE)/Sggamma(q=tp,p=exp(est.fit[1]),b=exp(est.fit[2]),a=exp(est.fit[3]),Inver=FALSE)
#
#
varFu <- 2*mcas[-length(mcas)]*log(1/(1-hazard))
#
y1.4 <- mcas[-c(length(mcas)-2,length(mcas)-1,length(mcas))]
y2.4 <- mcas[-c(1,length(mcas)-1,length(mcas))]
y3.4 <- mcas[-c(1,2,length(mcas))]
y4.4 <- mcas[-(1:3)]
tiet4 <- tijd[-c(1,2,3)]
A4 <- cbind(y1.4,y2.4,y3.4,y4.4)
stde4 <- NULL
vt4 <- NULL
for (i in 1:length(tiet4)) {
  vt4[i] <- 100*sd(A4[i,])/mean(A4[i,])
  stde4[i] <- sd(A4[i,])
}
#
####
pdf("King2.pdf",width=7,height=10)
par(mfrow= c(2,1))
barplot(mcas,names.arg=0:39,xlab="Quarter",space=0,ylab="Number of detected prevalent cases",main=name.k,bty="n")
plot(tijd[-c(1,2,length(tijd))],stde4+2,ylim=c(1,10),pch=" ",xlab="Quarter",ylab="Standard deviation",bty="n")
lines(tijd[-1],sqrt(varFu),col="blue",lwd=2)
lines(tijd[-c(1,2,length(tijd))],stde4,lwd=2,lty=2,col="red")
dev.off()
#
#
#
#
##################################################################
##################################################################
#    PLOTS
# Birth death model with different gen.gamma's
# a=1:gamma; p=1:weibull; a=1&p=1: exponential
# lp1,lb1,la1= birth part ; lp2,lb2,la2= death part
##################################################################
fit.bd <- bd.e.g
est.bd <- coef(fit.bd)
#
#deathrate
#
d.haz <- 1-(Sggamma(q=tn,p=exp(est.bd[4]),b=exp(est.bd[5]),a=exp(est.bd[6]),Inver=FALSE)/ Sggamma(q=tp,p=exp(est.bd[4]),b=exp(est.bd[5]),a=exp(est.bd[6]),Inver=FALSE))
#
#
#birthrate
#
b.haz <- 1-(Sggamma(q=tn,p=exp(est.bd[1]),b=exp(est.bd[2]),a=exp(est.bd[3]),Inver=FALSE)/ Sggamma(q=tp,p=exp(est.bd[1]),b=exp(est.bd[2]),a=exp(est.bd[3]),Inver=FALSE))
#
rate <- (1-d.haz)/(1-b.haz)
fitval <- c(mcas[1],mcas[-length(mcas)]*(1-d.haz)/(1-b.haz))
#
#
plot(c(0,40),c(0,930),pch=" ")
lines(tijd,cumsum(mcas),type="s")
lines(tijd,cumsum(fitval),col="red")
#
plot(c(0,50),c(0,50),pch=" ")
plot(tijd,mcas,pch=20)
lines(tijd,(mcas),col="blue")
lines(tijd,(fitval),col="red")
#
plot(c(1,40),c(.4,1.7),pch=" ")
lines(tijd[-1],b.haz,col="red")
lines(tijd[-1],d.haz,col="blue")
lines(tijd[-1],(1-d.haz)*(1/(1-b.haz)))
abline(1,0)
#
#
#
###################################################################
###################################################################
#
coef.mat <- matrix(nrow=250,ncol=6)
for (k in 1:250){
aisim <- NULL
yprev <- mcas[1]
for (j in 1:40){
#deathrate
  th<- 1-(Sggamma(q=j,p=exp(est.bd[4]),b=exp(est.bd[5]),a=exp(est.bd[6]),Inver=FALSE)/ Sggamma(q=j-1,p=exp(est.bd[4]),b=exp(est.bd[5]),a=exp(est.bd[6]),Inver=FALSE))
#
#birthrate
  pi <- 1-(Sggamma(q=j,p=exp(est.bd[1]),b=exp(est.bd[2]),a=exp(est.bd[3]),Inver=FALSE)/ Sggamma(q=j-1,p=exp(est.bd[1]),b=exp(est.bd[2]),a=exp(est.bd[3]),Inver=FALSE))
  ysim <- 1:90
  yp <- rep(yprev,90)
  pr <- NULL
  for (i in 1:90) {
    pr[i] <- dDoubleBinom(thea=th,piet=pi,ynul=yp[i],y=ysim[i],Log=FALSE)
  }
  a <- (1:90)[as.integer(pr*500000+.5)>0]
 # print(a)
  b <- as.integer(pr*500000+.5)[a]
  c <- rep(a,times=b)
  yprev <- sample(c,1)
  aisim[j] <- yprev
}
simcas <- c(mcas[1],aisim)
#
coef.mat[k,] <- coef(mle2(minuslogl=min.ll, start=list(lp1=1,lb1=-1,la1=-.5,lp2=1,lb2=1,la2=-.5), data=list(ynul=simcas[-length(simcas)],y=simcas[-1],time=tijd),fixed=list(INV=FALSE),method="Nelder-Mead",control=list(maxit=50000,type=1,trace=1,reltol=10^(-8)*.Machine$double.eps)))[1:6]
}
#####################################
####################################
#
eff.mat <- matrix(nrow=250,,ncol=39)
for (i in 1:250){
   eff.mat[i,] <- eff.r(coef.mat[i,])
}
quant <- apply(eff.mat,MARGIN=2,quantile,probs=c(.025,.975))
sd.time <- apply(eff.mat,MARGIN=2,sd)
#
pdf(file="king-eff-r.pdf",width=7,height=5)
#
plot(c(1,40),c(.45,1.3),pch=" ",xlab="quarter",ylab=" ",bty="n")
for (i in 1:250){
lines(tijd[-1],eff.r(coef.mat[i,]),col="grey")
}
lines(tijd[-1],(1-d.haz)*(1/(1-b.haz)),lwd=2)
lines(tijd[-1],quant[1,],lwd=2,lty="dashed",col="blue")
lines(tijd[-1],quant[2,],lwd=2,lty="dashed",col="blue")
abline(1,0,col="red",lwd=2)
#
dev.off()
#
#
###################################################################
#
#
###################################################################
###################################################################
##                 FUNCTIONS                                     ##
###################################################################
###################################################################
#              minus log-likelihood                               #
###################################################################
#
#
mll.gg <- function(lp,lb,la,ynul,y,time,INV){
tn <- time[-1]
tp <- time[-length(time)]
#rate
haz <- 1-Sggamma(q=tn,p=exp(lp),b=exp(lb),a=exp(la),Inver=INV)/Sggamma(q=tp,p=exp(lp),b=exp(lb),a=exp(la),Inver=INV)
#
del <- log(1/(1-haz))/(1+log(1/(1-haz)))
#
n <- length(tp)
pr <- vector(length=n)
for (i in 1:n) {
  pr[i] <- dDBinomDel(del=del[i],ynul=ynul[i],y=y[i],Log=TRUE)
}
-sum(pr)
#
}
#
###################################################################
###################################################################
#
min.ll <- function(lp1,lb1,la1,lp2,lb2,la2,ynul,y,time,INV){
tn <- time[-1]
tp <- time[-length(time)]
#deathrate
thea <- 1-Sggamma(q=tn,p=exp(lp2),b=exp(lb2),a=exp(la2),Inver=INV)/Sggamma(q=tp,p=exp(lp2),b=exp(lb2),a=exp(la2),Inver=INV)
#birthrate
piet <- 1-Sggamma(q=tn,p=exp(lp1),b=exp(lb1),a=exp(la1),Inver=INV)/Sggamma(q=tp,p=exp(lp1),b=exp(lb1),a=exp(la1),Inver=INV)
n <- length(tp)
pr <- vector(length=n)
for (i in 1:n) {
  pr[i] <- dDoubleBinom(thea=thea[i],piet=piet[i],ynul=ynul[i],y=y[i],Log=TRUE)
}
-sum(pr)
}
#
###################################################################
###################################################################
#
eff.r <- function(x){
  print(x)
 d.haz<- 1-(Sggamma(q=tijd[-1],p=exp(x[4]),b=exp(x[5]),a=exp(x[6]),Inver=FALSE)/ Sggamma(q=tijd[-length(tijd)],p=exp(x[4]),b=exp(x[5]),a=exp(x[6]),Inver=FALSE))
#
#birthrate
  b.haz<- 1-(Sggamma(q=tijd[-1],p=exp(x[1]),b=exp(x[2]),a=exp(x[3]),Inver=FALSE)/ Sggamma(q=tijd[-length(tijd)],p=exp(x[1]),b=exp(x[2]),a=exp(x[3]),Inver=FALSE))
#print(d.haz)
#print(b.haz)
effrep<- (1-d.haz)/(1-b.haz)
effrep
}
#
###################################################################
###################################################################
#
###################################################################
#                 Distribution stuff                              #
###################################################################
#
#
dDoubleBinom <- function(thea,piet,ynul,y,Log=FALSE){
if (any(ynul<=0) | any(y<=0)) stop( "Ynul and Y should be larger then zero")
#
#
#     
     m<-min(ynul-1,y-1)
     prob <- 0
     for (k in 0:m){
	prob <- prob+(ynul/y)*choose(ynul-1,k)*choose(y,y-k-1)*(thea^ynul)*(piet^y)*(((1-piet)*(1-thea))/(thea*piet))^(k+1)
	}
if(Log) prob=log(prob)
prob
}
#
###################################################################
#
dDBinomDel <- function(del,ynul,y,Log=FALSE){
if (any(ynul<=0) | any(y<=0)) stop( "Ynul and Y should be larger then zero")
#
#
#     
     m<-min(ynul-1,y-1)
     prob <- 0
     for (k in 0:m){
	prob <- prob+(ynul/y)*choose(ynul-1,k)*choose(y,y-k-1)*(del^ynul)*(del^y)*(((1-del)*(1-del))/(del*del))^(k+1)
	}
if(Log) prob=log(prob)
prob
}
#
###################################################################
#
Sggamma <- function(q, p, b, a,Inver) {
    if (any(q < 0)) 
        stop("q must be non-negative")
    if (any(b <= 0)) 
        stop("b must be positive")
    if (any(a <= 0)) 
        stop("a must be positive")
    if (any(p <= 0)) 
        stop("p must be positive")
    if (!Inver) prob <- pgamma(q^a, shape=p, scale = b^a,lower.tail=FALSE)
    if (Inver) prob <- pgamma(q^-a, shape=p, scale = b^-a,lower.tail=TRUE)
    prob
}
####################################################################
#
