###############################################################################################################
# author: Jona Cederbaum
# date: 08.04.2015
###############################################################################################################
# description: function that calls all subfunctions used for the estimation of the FLMM and returns the result.
###############################################################################################################
call_functions<-function(use_RI=FALSE,method="REML",bs="ps",d_grid=100,bf_mean=8,bf_covariates=8,m_mean=c(2,3),covariate=TRUE,
                         num_covariates=4,covariate_form=rep("by",num_covariates),
                         interaction=TRUE,
                         which_interaction=matrix(c(FALSE,TRUE,TRUE,TRUE,TRUE,FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,TRUE,FALSE,
                                                    FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE),
                                                  byrow=TRUE,nrow=num_covariates,ncol=num_covariates),plot_gam_mean=FALSE,
                         save_gam_mean=FALSE,bf_covs=c(5,5,5),m_covs=list(c(2,3),c(2,3)),use_bam=TRUE,
                         mp=FALSE,para_estim=TRUE,para_estim_nc=10,var_level=0.95,N_B=NA,N_C=NA,N_U=NA,use_pffr=TRUE,
                         use_bam_pffr=TRUE,plot_pffr=TRUE,
                         bs_int_pffr=list(bs="ps", k=8, m=c(2, 3)),bs_y_pffr=list(bs="ps", k=8, m=c(2, 3)),curve_info=curve_info,I=I,J=J){
  
  ################################################################################################################ 
  # Preparations
  ################################################################################################################ 
  res<-list()   # initialize output
  
  ###########################################
  # extract  observation points of curve_info
  ###########################################
  t<-curve_info$t        # long vector of observation points
  
  ##############################
  # specify important parameters
  ##############################
  n<-length(unique(curve_info$n_long)) # number of curves
  res[["nums_subject"]]<-create_nums_subject_fun(I=I,curve_info=curve_info)  # number of points per subject/level of first grouping variable
  if(!use_RI)
    res[["nums_word"]]<-create_nums_word_fun(J=J,curve_info=curve_info) # number of points per word/level of second grouping variable
  
  ####################
  # specify grid
  ####################  
  # specify grid on which the covariance estimator will later be evaluated
  res[["my_grid"]]<-seq(from=0,to=1,length=d_grid)  
  
  ###############################################################################################################
  # Estimations
  ###############################################################################################################
  ####################
  # estimate mean
  #################### 
  cat("mean_estimation","\n")
  time_start_mean<-proc.time()
  res[["mean_hat"]]<-smooth_mean(bf=bf_mean,bf_covariates=bf_covariates,ylab="",method=method,plot=plot_gam_mean,
                                 cols=colors,title="",num_covariates=num_covariates,
                                 covariate_form=covariate_form,save_gam=save_gam_mean,n=n,
                                 my_grid=res[["my_grid"]],bs=bs,m=m_mean,use_bam,curve_info=curve_info,
                                 interaction=interaction,which_interaction=which_interaction,covariate=covariate) 
  res[["time_mean"]]<-proc.time()-time_start_mean
  ###############################################################################################################
  ########################################
  # Preparations for covariance estimation
  ########################################
  if(any(!is.na(res[["mean_hat"]][["y_tilde"]]))){  # only continue if the mean estimation succeeded, else give warning
    y_tilde<-res[["mean_hat"]][["y_tilde"]]
    
    #########################
    # take out y_tilde 
    # from res[["mean_hat]]
    #########################
    res[["mean_hat"]][["y_tilde"]]<-NULL
    
    ################
    # add y_tilde to
    # curve_info
    ################
    curve_info[,y_tilde:=y_tilde]
    cat("prep_covariance","\n")
    curve_info[,id:=1:nrow(curve_info)]  # add id variable      
    preps<-prep_cov_fun(y_tilde=y_tilde,curve_info=curve_info,
                        my_grid=res[["my_grid"]],d_grid=d_grid,use_RI=use_RI,I=I,J=J,t=t)
    
    set(curve_info,i=NULL,"id",NULL) # remove id variable
    
    index<-preps$index
    set(index,i=NULL,"id2",NULL)
    
    grid_row<-preps$grid_row
    grid_col<-preps$grid_col
    
    same_subject_grid<-preps$same_subject_grid
    if(!use_RI)
      same_word_grid<-preps$same_word_grid
    same_curve_grid<-preps$same_curve_grid
    same_point_grid<-preps$same_point_grid
    
    preps<-NULL
    gc()
    
    cat("cov_estimation ","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
    
    if(use_RI)
      same_word_grid<-NA 
    
    time_start_cov<-proc.time()
    res[["cov_hat"]]<-smooth_cov(index=index,bf=bf_covs,method=method,
                                 grid_col=grid_col,grid_row=grid_row,d_grid=d_grid,
                                 bs=bs,m=m_covs,use_bam=use_bam,t=t,same_subject_grid=same_subject_grid,
                                 same_word_grid=same_word_grid,same_curve_grid=same_curve_grid,
                                 same_point_grid=same_point_grid,
                                 mp=mp,para_estim=para_estim,para_estim_nc=para_estim_nc,use_RI)  
    res[["time_cov"]]<-proc.time()-time_start_cov
    
    ##################
    # remove which is
    # not used anymore
    ##################
    same_subject_grid<-NULL
    same_word_grid<-NULL
    same_curve_grid<-NULL
    same_point_grid<-NULL
    grid_row<-NULL
    grid_col<-NULL
    y_tilde<-NULL
    
    ##############################
    # delete columns of index 
    # which are not needed anymore
    ##############################
    set(index,i=NULL,"row_t_bivariate",NULL)
    set(index,i=NULL,"col_t_bivariate",NULL)
    
    gc()
    
    ##########################################
    # Eigendecomposition for the simulatan case
    ##########################################
    if(use_RI){
      N_C<-0  #set to zero for easy of implementation
    }
    
    cat("fpc estimation ","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
    if(!is.na(res[["cov_hat"]][["sigmasq"]])){
      time_start_fpc<-proc.time()
      res[["fpc_hat"]]<-eigen_decomp(cov_B=res[["cov_hat"]][["grid_mat_B"]],
                                     cov_C=res[["cov_hat"]][["grid_mat_C"]],
                                     cov_U=res[["cov_hat"]][["grid_mat_U"]],
                                     sigmasq_int_hat=res[["cov_hat"]][["sigmasq_int"]],
                                     my_grid=res[["my_grid"]],
                                     var_level=var_level,N_B=N_B,N_C=N_C,N_U=N_U,
                                     curve_info=curve_info,nums_subject=res[["nums_subject"]],
                                     nums_word=res[["nums_word"]],index=index,
                                     I=I,J=J,n=n,sigmasq_hat=res[["cov_hat"]][["sigmasq"]],use_RI=use_RI)
      res[["time_fpc"]]<-proc.time()-time_start_fpc 
      
    }else{
      res[["fpc_hat"]]<-NA
    }
    
    ############################
    # take out elements of
    # curve_info which are not
    # needed anymore
    ############################
    
    res[["cov_hat"]][["grid_mat_B"]]<-NULL
    res[["cov_hat"]][["grid_mat_C"]]<-NULL
    res[["cov_hat"]][["grid_mat_U"]]<-NULL
    res[["cov_hat"]][["sigmasq_int"]]<-NULL
    gc()
    
    if(use_pffr){
      ########################################
      #pffr for score and new mean estimation
      ########################################
      cat("fpc famm estimation ","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
      if(!is.na(res[["cov_hat"]][["sigmasq"]])){
        time_start_fpc_famm<-proc.time()
        res[["fpc_famm_hat"]]<-pffr_fun(curve_info=curve_info,my_grid=res[["my_grid"]],
                                         phiB_hat_grid=res[["fpc_hat"]]$phiB_hat_grid,
                                         phiC_hat_grid=res[["fpc_hat"]]$phiC_hat_grid,
                                         phiU_hat_grid=res[["fpc_hat"]]$phiU_hat_grid,
                                         lamB_hat=res[["fpc_hat"]]$lamB_hat,
                                         lamC_hat=res[["fpc_hat"]]$lamC_hat,
                                         lamU_hat=res[["fpc_hat"]]$lamU_hat,
                                         t=t,N_B=res[["fpc_hat"]]$N_B,
                                         N_C=res[["fpc_hat"]]$N_C,
                                         N_U=res[["fpc_hat"]]$N_U,use_bam_pffr=use_bam_pffr,
                                         plot=plot_pffr,num_covariates=num_covariates,
                                         which_interaction=which_interaction,n=n,interaction=interaction,
                                         use_RI=use_RI,method=method,bs_y_pffr=bs_y_pffr,
                                         bs_int_pffr=bs_int_pffr,sigmasq=res[["cov_hat"]]$sigmasq,
                                         covariate=covariate)
        res[["time_fpc_famm"]]<-proc.time()-time_start_fpc_famm
        
      }else{
        res[["fpc_famm_hat"]]<-NA
      }            
      
    } # over use_pffr
    
    ############################################################################################################
    #######################
    # Output of the results
    #######################
  }else{  # if the mean estimation did not succeed
    warning("mean estimation did not succeed")
  }
  
  return(res)
}
###############################################################################################################
