##################################################################################################################
# author: Jona Cederbaum
# date: 08.04.2015
##################################################################################################################
# description: function to estimate smooth auto-covariance operators. Gives out auto-covariances evaluated
## on a pre-specified grid.
##################################################################################################################
smooth_cov<-function(index,bf,method,d_grid,grid_row,grid_col,same_subject_grid,same_word_grid,
                     same_curve_grid,same_point_grid,bs,m,use_bam,t,mp,para_estim,para_estim_nc,use_RI){
  out<-list()  
  
  cat("begin: bam","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
  
  if(use_bam==TRUE){
    #############
    # set cluster
    # if parallel
    #############
    if(para_estim){
      if(detectCores()>1){
        nc_use<-min(detectCores(),para_estim_nc)
        if(.Platform$OS.type=="unix"){
          cl_estim<-makeForkCluster(nnodes=nc_use) # only runs on linux
        }else{
          cl_estim<-makeCluster(nc_use) # runs also on windows
        }
      }else{
        cl_estim<-NULL  # if only one core available
      }
    }else{
      cl_estim<-NULL  # if no parallelization desired
    }
    
    if(bs=="tp"){
      ##########
      # TP basis
      ##########
      
      # define knots manually
      knot_help<-seq(min(index$row_t_bivariate),max(index$row_t_bivariate),length.out=bf[1])
      
      
      if(!use_RI){        
        #############
        # for crossed
        #############
        gam1<-try(bam(cross_vec_bivariate~ - 1+
                        s(row_t_bivariate,col_t_bivariate,by=same_subject,k=bf[1],bs="tp",m=m)+
                        s(row_t_bivariate,col_t_bivariate,by=same_word,k=bf[2],bs="tp",m=m)+
                        s(row_t_bivariate,col_t_bivariate,by=same_curve,k=bf[3],bs="tp",m=m)+
                        same_point,method=method,data=index,cluster=cl_estim,knots=list(knot_help,knot_help,knot_help)))
        
        ############
        # for RI
        ############
      }else{
        gam1<-try(bam(cross_vec_bivariate~ 1+ s(row_t_bivariate,col_t_bivariate,
                                                k=bf[1],bs="tp",m=m)+
                        s(row_t_bivariate,col_t_bivariate,by=same_curve,k=bf[3],bs="tp",m=m)+
                        same_point,method=method,data=index,cluster=cl_estim,knots=list(knot_help,knot_help,knot_help)))
      }
      
      
    }else{      
      ################
      # other bases
      # e.g. B-splines
      ################
      
      if(!use_RI){
        
        #############
        # for crossed
        #############      
        gam1<-try(bam(cross_vec_bivariate~ - 1+
                        te(row_t_bivariate,col_t_bivariate,by=same_subject,k=bf[1],bs=c(bs,bs),m=m,mp=mp)+
                        te(row_t_bivariate,col_t_bivariate,by=same_word,k=bf[2],bs=c(bs,bs),m=m,mp=mp)+
                        te(row_t_bivariate,col_t_bivariate,by=same_curve,k=bf[3],bs=c(bs,bs),m=m,mp=mp)+
                        same_point,method=method,data=index,cluster=cl_estim))
        
      }else{        
        ########
        # for RI
        ########
        gam1<-try(bam(cross_vec_bivariate~ 1+te(row_t_bivariate,
                                                col_t_bivariate,k=bf[1],bs=c(bs,bs),m=m,mp=mp)+
                        te(row_t_bivariate,col_t_bivariate,by=same_curve,k=bf[3],bs=c(bs,bs),m=m,mp=mp)+
                        same_point,method=method,data=index,cluster=cl_estim))
      }
    }
    if(!is.null(cl_estim)) stopCluster(cl_estim) # stop cluster if existing
    
    
  }else{      
    #########
    # use gam
    #########
    
    if(!use_RI){
      #############
      # for crossed
      #############
      gam1<-try(gam(cross_vec_bivariate~ - 1+
                      te(row_t_bivariate,col_t_bivariate,by=same_subject,k=bf[1],bs=c(bs,bs),m=m,mp=mp)+
                      te(row_t_bivariate,col_t_bivariate,by=same_word,k=bf[2],bs=c(bs,bs),m=m,mp=mp)+
                      te(row_t_bivariate,col_t_bivariate,by=same_curve,k=bf[3],bs=c(bs,bs),m=m,mp=mp)+
                      same_point,method=method,data=index))
    }else{      
      ########
      # for RI
      ########
      gam1<-try(gam(cross_vec_bivariate~ 1+te(row_t_bivariate,
                                              col_t_bivariate,k=bf[1],bs=c(bs,bs),m=m,mp=mp)+
                      te(row_t_bivariate,col_t_bivariate,by=same_curve,k=bf[3],bs=c(bs,bs),m=m,mp=mp)+
                      same_point,method=method,data=index))
    }
  }
  
  cat("end: bam","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
  
  if(class(gam1)[1]!="try-error"){    
    ##############################
    # extract smoothing parameters
    ##############################
    sp<-gam1$sp
    
    if(use_RI){
      ###################
      # extract intercept
      ###################
      intercept<-as.numeric(coefficients(gam1)[1])
    }
    
    #################
    # extract sigmasq
    #################
    sigmasq<-as.numeric(max(coefficients(gam1)["same_point"],0)) # check whether sigmasq is negative
    
    #################################
    # compute the integral of sigmasq
    #################################
    sigmasq_int<-(max(unlist(t))-min(unlist(t)))*sigmasq

    #########################
    # prediction on grid data
    #########################
    
    cat("begin: predict on grid data","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
    ###########################
    # construction of grid data
    ###########################
    if(!use_RI){
      #############
      # for crossed
      #############
      grid_data<-data.table(row_t_bivariate=grid_row,col_t_bivariate=grid_col,same_subject=same_subject_grid,
                            same_word=same_word_grid,same_curve=same_curve_grid,same_point=same_point_grid)
      
      # remove unnecessary stuff
      grid_row<-NULL
      grid_col<-NULL
      same_subject_grid<-NULL
      same_word_grid<-NULL
      same_curve_grid<-NULL
      same_point_grid<-NULL
      
    }else{
      ############
      #for RI
      ############
      grid_data<-data.table(row_t_bivariate=grid_row,col_t_bivariate=grid_col,same_subject=same_subject_grid,
                            same_curve=same_curve_grid,same_point=same_point_grid)
      
      # remove unnecessary stuff
      grid_row<-NULL
      grid_col<-NULL
      same_subject_grid<-NULL
      same_curve_grid<-NULL
      same_point_grid<-NULL
    }
    
    ###################
    #evaluation on grid
    ###################    
    time_start_cov_pred_grid<-Sys.time()
    grid_smooth<-predict(gam1,newdata=grid_data,na.omit=TRUE,type="terms")

    time_cov_pred_grid<-Sys.time()-time_start_cov_pred_grid
    cat("end: predict on grid data","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
    
    # remove grid_data
    grid_data<-NULL
    
    
    ########################
    # extract components
    # and construct matrices
    ########################
    if(!use_RI){
      #############
      # for crossed
      #############
      grid_mat_B<-matrix(grid_smooth[,2],ncol=d_grid,nrow=d_grid,byrow=TRUE)  
      grid_mat_C<-matrix(grid_smooth[,3],ncol=d_grid,nrow=d_grid,byrow=TRUE)  
      grid_mat_U<-matrix(grid_smooth[,4],ncol=d_grid,nrow=d_grid,byrow=TRUE)
    }else{
      ########
      # for RI
      ########
      grid_mat_B<-matrix(grid_smooth[,2],ncol=d_grid,nrow=d_grid,byrow=TRUE)+intercept
      grid_mat_C<-matrix(rep(0,length=d_grid^2),ncol=d_grid,nrow=d_grid,byrow=TRUE)  
      grid_mat_U<-matrix(grid_smooth[,3],ncol=d_grid,nrow=d_grid,byrow=TRUE)
    }
 
    grid_smooth<-NULL    
    
  }else{      # if try-error, give out NAs    
    sigmasq<-NA
    sigmasq_int<-NA
    grid_mat_B<-NA
    grid_mat_C<-NA
    grid_mat_U<-NA
    sp<-NA
  } 
  
  # remove model object
  gam1<-NULL
  gc()
  
  
  ########
  # Output
  ########
  out<-list(sigmasq=sigmasq,sigmasq_int=sigmasq_int,grid_mat_B=grid_mat_B,
            grid_mat_C=grid_mat_C,grid_mat_U=grid_mat_U)
  return(out)
}

####################################################################################









