##################################################################################################################
# author: Jona Cederbaum
# date: 08.04.2015
##################################################################################################################
# description: FPCA-FAMM function which predicts FPC weights and B, C, U and re-estimates the  mean function
## including covariates as functional additive mixed model.
##################################################################################################################
pffr_fun<-function(curve_info,my_grid,phiB_hat_grid,phiC_hat_grid,phiU_hat_grid,lamB_hat,lamC_hat,lamU_hat,t,
                   N_B,N_C,N_U,use_bam_pffr,plot_pffr,num_covariates,interaction,
                   which_interaction,n,use_RI,method,bs_y_pffr,bs_int_pffr,sigmasq,covariate){
  
  results<-list() 
  y_vec<-curve_info$y_vec
  
  ################
  # construct data
  # and ydata
  ################
  if(!use_RI){
    data<-data.table(id_subject=as.factor(curve_info$subject_long),id_word=as.factor(curve_info$word_long),
                     id_n=as.factor(curve_info$n_long))
    
  }else{
    data<-data.table(id_subject=as.factor(curve_info$subject_long),
                     id_n=as.factor(curve_info$n_long))
  }
  
  if(covariate){
    for(i in 1:num_covariates){
      data[,paste0("covariate.",i):=curve_info[[paste0("covariate.",i)]]]      
      if(interaction){
        for(k in 1:num_covariates){
          if(which_interaction[i,k]&(i<k)){
            prod_help<-curve_info[[paste0("covariate.",i)]]*curve_info[[paste0("covariate.",k)]]
            data[,paste0("inter_",i,"_",k):=prod_help]              
          }
        }  
      }
    }
  }
  data<-data[!duplicated(data$id_n),]  # only need one row per CURVE not per observation in data
  ydata<-data.frame(.obs=curve_info$n_long,.index=t,.value=y_vec)
  rownames(data)<-1:n
  
  ################
  # construct pcre
  # terms for pffr
  ################
  names<-vector()
  N_vec<-c(N_B,N_C,N_U)
  funs_names<-c("B","C","U")
  for(i in seq_along(funs_names)){
    if(i==1){
      id="id_subject"
    }
    if(i==2){
      id="id_word"
    }
    if(i==3){
      id="id_n"
    }
    
    if(N_vec[i]>0){
      names<-cbind(names,paste("pcre(id=",id,",efunctions=phi",funs_names[i],
                               "_hat_grid,evalues=lam",funs_names[i],"_hat,yind=my_grid)",
                               sep=""))
    }
  }
  listofbys_pc<-c(as.vector(names))
  
  if(covariate){
    #####################
    # construct covariate
    # effects for ppfr
    #####################
    if(interaction==FALSE){
      names<-vector()
      for(i in 1:num_covariates){
        names<-cbind(names,paste("covariate.",i,"",sep=""))
      }
      listofbys_cov<-as.vector(names)
      
    }else{
      names<-vector()
      inter_names<-vector()
      inter_by<-numeric()
      for(i in 1:num_covariates){
        names<-cbind(names,paste("covariate.",i,"",sep=""))
        for(k in 1:num_covariates){
          if(which_interaction[i,k]&(i<k)){
            inter_names<-cbind(inter_names,paste("inter_",i,"_",k,"",sep=""))
          }
        }
      }
      listofbys_cov<-c(as.vector(names),c(inter_names))
    }   
    
    listofbys<-c(listofbys_pc,listofbys_cov)
  }else{
    listofbys<-listofbys_pc
  }
  
  pred<-as.formula(paste("y_vec~ 1+ ",paste(listofbys,collapse="+"),sep=""))
  
  ####################################
  # get design matrices to get S.scale
  ####################################
  cat("begin: get design matrices pffr","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
  if(use_bam_pffr){
    pffr_setup_get_scale<-pffr(pred,yind=my_grid,data=data,ydata=ydata,
                               algorithm="bam",control=gam.control(trace=TRUE),method=method,
                               bs.yindex=bs_y_pffr,bs.int=bs_int_pffr,fit=FALSE)
  }else{
    pffr_setup_get_scale<-pffr(pred,yind=my_grid,data=data,ydata=ydata,
                               algorithm="gam",control=gam.control(trace=TRUE),method=method,
                               bs.yindex=bs_y_pffr,bs.int=bs_int_pffr,fit=FALSE)
  } 
  cat("end: get design matrices pffr","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
  cat("begin: extract S.scale","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
  # extract S.scale
  if(N_B>0){
    scale_B<-pffr_setup_get_scale$smooth[[2]]$S.scale    
    if(N_C>0){
      scale_C<-pffr_setup_get_scale$smooth[[3]]$S.scale    
      if(N_U>0){
        scale_U<-pffr_setup_get_scale$smooth[[4]]$S.scale    
        scale_res<-c(scale_B,scale_C,scale_U)
      }
    }else{
      scale_U<-pffr_setup_get_scale$smooth[[3]]$S.scale    
      scale_res<-c(scale_B,scale_U)
    }  
  }else{
    if(N_C>0){
      scale_C<-pffr_setup_get_scale$smooth[[2]]$S.scale  
      if(N_U>0){
        scale_U<-pffr_setup_get_scale$smooth[[3]]$S.scale  
        scale_res<-c(scale_C,scale_U)
      }
    }else{
      scale_U<-pffr_setup_get_scale$smooth[[2]]$S.scale  
      scale_res<-c(scale_U)
    }
  }
  cat("end: extract S.scale","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
  
  #################
  # specify sp_fix
  #################
  if(covariate){
    sp_fix<-c(-1,scale_res*sigmasq,rep(-1,(length(listofbys_cov))))  
  }else{
    sp_fix<-c(-1,scale_res*sigmasq)  
  }
  
  ###############
  # estimate pffr
  ###############
  cat("begin: pffr estimation","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
   
  if(use_bam_pffr){
    pffr_estim<-pffr(pred,sp=sp_fix,yind=my_grid,data=data,ydata=ydata,
                     algorithm="bam",control=gam.control(trace=TRUE),method=method,
                     bs.yindex=bs_y_pffr,bs.int=bs_int_pffr)
    
  }else{
    pffr_estim<-pffr(pred,sp=sp_fix,yind=my_grid,data=data,ydata=ydata,
                     algorithm="gam",control=gam.control(trace=TRUE),method=method,
                     bs.yindex=bs_y_pffr,bs.int=bs_int_pffr)
  }
  
  cat("end: pffr estimation","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
  
  results[["intercept"]]<-pffr_estim$coefficients[1]
  results[["scores"]]<-pffr_estim$coefficients
  results[["sig2"]]<-pffr_estim$sig2
  
  ###############
  # get residuals
  ###############
  results[["residuals"]]<-pffr_estim$residuals
  
  ###################
  # predict in parts
  # to avoid many
  # doubles
  # for all dummies=1
  # interactions=1
  ###################  
  cat("begin: pffr prediction","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")  
  if(N_B>0){
    newdata1<-data.table(id_subject=unique(data$id_subject),
                         id_word=as.factor(rep(1,length=length(unique(data$id_subject)))),
                         id_n=as.factor(rep(1,length=length(unique(data$id_subject)))))
    if(covariate){
      for(i in 1:num_covariates){
        newdata1[,paste0("covariate.",i):=rep(1,length(unique(data$id_subject)))]
        if(interaction){
          for(k in 1:num_covariates){
            if(which_interaction[i,k]&(i<k)){
              newdata1[,paste0("inter_",i,"_",k):=rep(1,length(unique(data$id_subject)))]
            }
          }  
        } 
      }
    }
    pred1<-predict(pffr_estim,type="terms",newdata=newdata1)
    pred1_partuse<-pred1[[2]]
    results[["pffr_predict1"]]<-pred1_partuse
  }else{
    results[["pffr_predict1"]]<-NA
  }
  if(N_C>0){
    newdata2<-data.table(id_subject=rep(1,length=length(unique(data$id_word))),id_word=unique(data$id_word),
                         id_n=rep(1,length=length(unique(data$id_word))))
    if(covariate){
      for(i in 1:num_covariates){
        newdata2[,paste0("covariate.",i):=rep(1,length(unique(data$id_word)))]
        if(interaction){
          for(k in 1:num_covariates){
            if(which_interaction[i,k]&(i<k)){
              newdata2[,paste0("inter_",i,"_",k):=rep(1,length(unique(data$id_word)))]
            }
          }    
        }
      }
    }
    pred2<-predict(pffr_estim,type="terms",newdata=newdata2)
    if(N_B>0){
      pred2_partuse<-pred2[[3]]
    }else{
      pred2_partuse<-pred2[[2]]
    }
    results[["pffr_predict2"]]<-pred2_partuse
  }else{
    results[["pffr_predict2"]]<-NA
  }
  if(N_U>0){
    newdata3<-data.table(id_subject=rep(1,length=length(unique(data$id_n))),
                         id_word=rep(1,length=length(unique(data$id_n))),id_n=unique(data$id_n))
    
    if(covariate){
      for(i in 1:num_covariates){
        newdata3[,paste0("covariate.",i):=rep(1,length(unique(data$id_n)))]
        if(interaction){
          for(k in 1:num_covariates){
            if(which_interaction[i,k]&(i<k)){
              newdata3[,paste0("inter_",i,"_",k):=rep(1,length(unique(data$id_n)))]
            }
          }  
        }
      }
    }
    pred3<-predict(pffr_estim,type="terms",newdata=newdata3)
    if(N_B>0){
      if(N_C>0){
        pred3_partuse<-pred3[[4]]
      }else{
        pred3_partuse<-pred3[[3]]
      }
    }else{
      pred3_partuse<-pred3[[2]]
    }
    results[["pffr_predict3"]]<-pred3_partuse
    
  }else{
    results[["pffr_predict3"]]<-NA
  }
  
  cat("end: pffr prediction","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
 
  ##################
  # predict for 
  # confidence bands
  ##################
  coef_use<-coef(pffr_estim)  # extract coefficients
  coef_use_sm<-coef_use$smterms
  results[["pffr_cb_mean"]]<-coef_use_sm[[1]]$coef
  
  if(covariate){
    for(i in 1:num_covariates){
      results[[paste0("pffr_cb_cov.",i)]]<-coef_use_sm[[paste0("covariate.",i,"(yindex)")]][["coef"]]
      if(interaction){
        for(k in 1:num_covariates){
          if(which_interaction[i,k]&(i<k)){
            results[[paste0("pffr_cb_inter_",i,"_",k)]]<-coef_use_sm[[paste0("inter_",i,"_",k,"(yindex)")]][["coef"]]
          }
        }
      }
    }
  }
  #################
  # plot condifence
  # bands if needed
  #################
  if(plot_pffr){
    results[["pffr_estim"]]<-pffr_estim
  }
  
  pffr_estim<-NULL
  
  return(results)
}

###################################################################################################
