##################################################################################################################
# author: Jona Cederbaum
# date: 08.04.2015
##################################################################################################################
# description: Preparing functions that are used in call_all_functions.R and prep_covariance.R.
##################################################################################################################
############################
# create nums_subject object
############################
create_nums_subject_fun<-function(I,curve_info){
  nums_subject<-list()  # compute number of measurement points per curve per subject
  for(i in 1:I){
    select<-vector()
    help<-subset(curve_info,subset=subject_long==i)
    for(j in unique(help$n_long)){
      select[j]<-unique(subset(help,subset=n_long==j,select="number_long")$number_long)
    }
    nums_subject[[i]]<-unlist(select[which(!is.na(select))])
  }
  return(nums_subject)
}

###########################
# create nums_word object
###########################
create_nums_word_fun<-function(J,curve_info){
  nums_word<-list()  # compute number of measurement points per curve per subject
  for(i in 1:J){
    select<-vector()
    help<-subset(curve_info,subset=word_long==i)
    for(j in unique(help$n_long)){
      select[j]<-unique(subset(help,subset=n_long==j,select="number_long")$number_long)
    }
    nums_word[[i]]<-unlist(select[which(!is.na(select))])
  }
  return(nums_word)
}

###############################################
# compute matrix of cross products (all combis)
###############################################
compute_cross_mat_fun<-function(curve_info,use_RI){
  cross_mat<-tcrossprod(curve_info$y_tilde)
}

##############################
# create matrix of time points
##############################
create_t_mat_fun<-function(t){
  t_mat<-c(replicate(t,n=length(t)))
  return(t_mat)  
}

##############################
# create matrix of time points
# transposed
##############################
create_t_mat_transposed_fun<-function(t){
  t_mat<-c(matrix(replicate(t,n=length(t)),nrow=length(t),byrow=TRUE))
  return(t_mat)  
}

#######################
# indices for subject
#######################
create_ind_subject_fun<-function(curve_info){
  ind_subject_help<-curve_info$subject_long
  ind_subject<-c(matrix(replicate(length(ind_subject_help),ind_subject_help),nrow=length(ind_subject_help)))
  return(ind_subject)
}

#######################
# indices for subject
# transposed
#######################
create_ind_subject_transposed_fun<-function(curve_info){
  ind_subject_help<-curve_info$subject_long
  ind_subject<-c(matrix(replicate(length(ind_subject_help),ind_subject_help),nrow=length(ind_subject_help),byrow=TRUE))
  return(ind_subject)
}

#######################
# indices for word
#######################
create_ind_word_fun<-function(curve_info){
  ind_word_help<-curve_info$word_long
  ind_word<-c(matrix(replicate(length(ind_word_help),ind_word_help),nrow=length(ind_word_help)))
  return(ind_word)
}

#######################
# indices for word
# transposed
#######################
create_ind_word_transposed_fun<-function(curve_info){
  ind_word_help<-curve_info$word_long
  ind_word<-c(matrix(replicate(length(ind_word_help),ind_word_help),nrow=length(ind_word_help),byrow=TRUE))
  return(ind_word)
}

########################
# indices for curve
#######################
create_ind_curve_fun<-function(curve_info){
  ind_curve_help<-curve_info$n_long
  ind_curve<-c(matrix(replicate(length(ind_curve_help),ind_curve_help),nrow=length(ind_curve_help)))
  return(ind_curve)
}

#######################
# indices for curve
# transposed
#######################
create_ind_curve_transposed_fun<-function(curve_info){
  ind_curve_help<-curve_info$n_long
  ind_curve<-c(matrix(replicate(length(ind_curve_help),ind_curve_help),nrow=length(ind_curve_help),byrow=TRUE))
  return(ind_curve)
}

###############################
# long data frame for bivariate
###############################
create_data_frame_bivariate_fun<-function(index){
  index[,same_subject:=as.numeric(row_subject_bivariate==col_subject_bivariate)]
  index[,same_word:=as.numeric(row_word_bivariate==col_word_bivariate)]
  index[,same_curve:=as.numeric(row_word_bivariate==col_word_bivariate & 
                                  row_subject_bivariate==col_subject_bivariate & row_combi_bivariate==col_combi_bivariate)]
  index[,same_point:=as.numeric(same_curve==1 & row_t_bivariate==col_t_bivariate)]
  
  set(index,i=NULL,"row_subject_bivariate",NULL)
  set(index,i=NULL,"col_subject_bivariate",NULL)
  set(index,i=NULL,"row_word_bivariate",NULL)
  set(index,i=NULL,"col_word_bivariate",NULL)
  set(index,i=NULL,"row_combi_bivariate",NULL)
  set(index,i=NULL,"col_combi_bivariate",NULL)
  return(index)
}

###############################
# long data frame for bivariate
# for case of RI
###############################
create_data_frame_bivariate_RI_fun<-function(index){
  index[,same_subject:=as.numeric(row_subject_bivariate==col_subject_bivariate)]
  index[,same_curve:=as.numeric(row_curve_bivariate==col_curve_bivariate)]
  
  index[,row_subject_bivariate:=NULL]
  index[,col_subject_bivariate:=NULL]
  index[,col_curve_bivariate:=NULL] 
  index[,row_curve_bivariate:=NULL] 
  
  index[,same_point:=as.numeric(same_curve==1 & row_t_bivariate==col_t_bivariate)]
  return(index)
}


###############################
# long data frame for bivariate
# on grid
###############################
create_grid_data_fun<-function(my_grid,d_grid){
  out<-list()
  out[["grid_row"]]<-rep(my_grid,each=d_grid)
  out[["grid_col"]]<-rep(my_grid,d_grid)
  out[["same_subject_grid"]]<-rep(1,length(out[["grid_row"]]))
  out[["same_word_grid"]]<-rep(1,length(out[["grid_row"]]))
  out[["same_curve_grid"]]<-rep(1,length=length(out[["grid_row"]]))
  out[["same_point_grid"]]<-rep(0,length=length(out[["grid_row"]]))
  return(out)  
}

##########################
# create matrix of indices
# for time points 
##########################
create_t_mat_ind_fun<-function(t, t_ind_long){
  t_mat_ind<-c(replicate(t_ind_long,n=length(t)))
  return(t_mat_ind)  
}

##########################
# create matrix of indices
# for time points 
##########################
create_t_mat_ind_transposed_fun<-function(t, t_ind_long){
  t_mat_ind<-c(matrix(replicate(t_ind_long,n=length(t)),nrow=length(t_ind_long),byrow=TRUE))
  return(t_mat_ind)  
}


########################
# compute cross products
########################
make_crossprod_dt <- function(curve_info, preselection=c("none", "subject", "word")){
  
  preselection <- match.arg(preselection)
  # generate alle combinations of rows
  
  setkey(curve_info, id)
  
  combinations <- with(curve_info, CJ(id=id, id2=id))
  
  # add indicators for id1
  if(!use_RI){
    tmp1 <- curve_info[combinations, list(id1=id, subj1=subject_long, word1=word_long, 
                                          rep1=combi_long)]  
    
  }else{
    tmp1 <- curve_info[combinations, list(id1=id, subj1=subject_long,n1=n_long)]  
  }
  
  # add indicators for id2
  if(!use_RI){
    tmp2 <- curve_info[combinations[,list(id=id2)], 
                       list(id2=id, subj2=subject_long, word2=word_long, rep2=combi_long)]
    
  }else{
    tmp2 <- curve_info[combinations[,list(id=id2)], 
                       list(id2=id, subj2=subject_long,n2=n_long)]
  } 
  
  # combine tmp1 and tmp1 without usin cbind (as slow)
  if(!use_RI){
    crosstable <- tmp1[, `:=`(id2=tmp2$id2, subj2=tmp2$subj2, word2=tmp2$word2,  rep2=tmp2$rep2)]
  }else{
    crosstable <- tmp1[, `:=`(id2=tmp2$id2, subj2=tmp2$subj2,n2=tmp2$n2)]
  }
  
  # remove irrelevant combis:
  if(preselection == "none") {
  }
  if(preselection == "subject") {
    crosstable <- crosstable[word1!=word2, ]
  }    
  if(preselection == "word") {
    crosstable <- crosstable[subj1!=subj2, ]  
  }
  
  
  # merge t and y
  crosstable[, id:=id1]
  setkey(crosstable, "id")
  crosstable <- crosstable[curve_info[, list(id, y_tilde, t)], ]
  setnames(crosstable, old=c("id1", "y_tilde", "t"), 
           new=c("id1", "y1", "t1"))
  
  # join id with what we set up as id2
  crosstable[, id:=id2]
  setkey(crosstable, "id")
  crosstable <- crosstable[curve_info[, list(id, y_tilde, t)], ]
  if(!use_RI){
    setnames(crosstable, old=c("id","y_tilde", "t","subj1","subj2","word1","word2","rep1","rep2"),
             new=c("id2", "y2", "t2","row_subject_bivariate",
                   "col_subject_bivariate","row_word_bivariate","col_word_bivariate","row_combi_bivariate","col_combi_bivariate"))
  }else{
    setnames(crosstable, old=c("id","y_tilde", "t","subj1","subj2","n1","n2"), 
             new=c("id2", "y2", "t2","row_subject_bivariate",
                   "col_subject_bivariate", "row_curve_bivariate",
                   "col_curve_bivariate"))
  }
  setkey(crosstable, "id1") # redo sort
  
  # compute crossprods:
  (crosstable[, cross_vec_bivariate:=y1*y2])
  
  setkey(crosstable, id1, id2)
  crosstable
}


###################################################################################################



