###################################################################################################################
# author: Jona Cederbaum
# date: 08.04.2015
##################################################################################################################
# description: generate data that can be analyzed using the proposed FLMM.
##################################################################################################################

################
# load packages
################
require("mgcv")          
require(MASS)
require(mvtnorm)           # for drawing the scores out of a mvn distribution
require(data.table)
require(orthopolynom)
require(expm)

###################################
# load the file for data generation
###################################
source("gen_function.R")

###########################
#load function to construct
#eigenfunctions
###########################
source("ortho_functions.R")


#################
# Input variables
#################
# I: number of levels for first grouping variable 
# J: number of levels for second grouping variable (set to NA for random intercept design)
# lamB_fun: eigenvalues for first grouping variable as a function of k (k=1,...,N_B)
# lamC_fun: eigenvalues for second grouping variable as a function of k (k=1,...,N_C) (set to NA for random intercept design)
# lamU_fun: eigenvalues for curves-specific deviations as a function of k (k=1,...,N_U)
# sigmasq: error variance
# normal: TRUE: FPC weights are drawn from a normal distribution. FALSE: they are drawn from a mixture of normals
# mu: mean function 
# N_B: number of FPCs for first grouping variable
# N_C: number of FPCs for second grouping variable
# N_U: number of FPCs for curves-specific deviations
# phiB_fun: eigenfunctions of the first grouping variable as a function of k and t (k=1,...,N_B)
# phiC_fun: eigenfunctions of the second grouping variable as a function of k and t (k=1,...,N_C)
# phiU_fun: eigenfunctions of the curve-specific deviations as a function of k and t (k=1,...,N_U)
# minsize: minimal number of observations
# maxsize: maximal number of observations
# min_grid: minimal value of grid range
# max_grid: maximal value of grid range
# min_visit: minimal number of repetitions of each subject-word (first-and second grouping variable) combination
## (in case of random intercept design: minimal number of repetitions for first grouping variable)
# max_visit: maximal number of repetitions of each subject-word (first-and second grouping variable) combination
## (in case of random intercept design: maximal number of repetitions for first grouping variable)
# use_RI_true<- FALSE  # TRUE: data with a random intercept are generated.
## FALSE: data with crossed random intercepts are generated
# covariate: if covariates shall be generated (TRUE: we generate two binary covariates exemplariliy)
# center_scores: TRUE: FPC weights are centered
# decor_scores: TRUE: FPC weights are decorrelated

##################
# Output variables
##################
# gen is a list containing the input parameters and additionally:
## curve_info_true a data.table containing the important information for each observation point (row).
## xiB_true: true scores for B
## xiC_true: true scores for C (if crossed design)
## xiU_true: true scores for curve-specific deviations
## phiB_true: the eigenfunctions of B evaluated on the observation points
## phiC_true: the eigenfunctions of C evaluated on the observation points (if crossed design)
## phiU_true: the eigenfunctions of curve-specific deviations evaluated on the observation points

#######################################
#now generate data for normal and 
#non_normal case and save the data sets
#######################################

set.seed(123)
gen<-gendata(I=10,J=10,lamB_fun=function(k){2/k},lamC_fun=function(k){2/k},
             lamU_fun=function(k){2/k},sigmasq=0.05,normal=TRUE,mu=function(t){t+sin(t)},N_B=1,N_C=1,
             N_U=1,phiB_fun=phiB,phiC_fun=phiC,phiU_fun=phiU,minsize=10,
             maxsize=20,min_grid=0,max_grid=1,min_visit=2,max_visit=3,use_RI_true=FALSE,
             covariate=FALSE,center_scores=TRUE,decor_scores=TRUE)

########################################################################################################################
