##################################################################################################################
# author: Jona Cederbaum
# date: 08.04.2015
##################################################################################################################
# description: function to estimate smooth mean function and smooth covariate and interaction effects
## and gives out centerd data.
## Note: so far all covariates need to enter the mean in the same way.
##################################################################################################################
smooth_mean<-function(bf,bf_covariates,ylab,method,plot,cols,title,save_gam,n,my_grid,bs,m,use_bam,curve_info,num_covariates,
                      covariate_form,interaction,which_interaction,covariate){
  results<-list() 
  dat_help<-copy(curve_info)
  
  ###############
  # estimate mean
  ###############
  if(covariate){
    ##############
    # linear model
    ##############
    if(all(covariate_form=="linear")){
      names<-vector()
      
      for(i in 1:num_covariates){
        names<-cbind(names,paste0("covariate.",i))
      }
      listofcovs<-as.vector(names)
      pred<-as.formula(paste("y_vec~t+",paste(listofcovs,collapse="+")))
      
      gam1<-lm(pred,data=dat_help)
      dat_help<-NULL
      gc()
    }
    
    ###############
    # gam with semi
    ############### 
    if(all(covariate_form=="semi")){
      names<-vector()
      for(i in 1:num_covariates){
        names<-cbind(names,paste0("covariate.",i))
      }
      listofcovs<-as.vector(names)
      pred<-as.formula(paste("y_vec~",paste(listofcovs,collapse="+"),"+s(t,k=bf,bs=bs,m=m)",sep=""))
      
      if(use_bam==TRUE){
        gam1<-try(bam(pred,data=dat_help,method=method))
      }else{
        gam1<-try(gam(pred,data=dat_help,method=method))
      }
      dat_help<-NULL
      gc()
    } 
    
    ######################
    # gam with by
    # varying coefficients
    ######################
    if(all(covariate_form=="by")){
      if(interaction==FALSE){
        names<-vector()
        
        for(i in 1:num_covariates){
          names<-cbind(names,paste0("s(t,k=bf_covariates,bs=bs,m=m,by=covariate.",i,")"))
        }
        listofbys<-as.vector(names)
        
        pred<-as.formula(paste("y_vec~",paste(listofbys,collapse="+"),"+s(t,k=bf,bs=bs,m=m)",sep=""))
        
        if(use_bam==TRUE){
          gam1<-try(bam(pred,data=dat_help,method=method))
        }else{
          gam1<-try(gam(pred,data=dat_help,method=method))
        } 
        dat_help<-NULL
        gc()
        
      }else{      
        names<-vector()
        dat_help<-copy(curve_info)
        inter_names<-vector(mode="character")
        inter_by<-numeric()
        for(i in 1:num_covariates){
          names<-cbind(names,paste0("s(t,k=bf_covariates,bs=bs,m=m,by=covariate.",i,")"))
          for(k in 1:num_covariates){
            if(which_interaction[i,k]&(i<k)){
              prod_help<-curve_info[[paste0("covariate.",i)]]*curve_info[[paste0("covariate.",k)]]
              dat_help[,paste0("inter_",i,"_",k):=prod_help]
              inter_names<-cbind(inter_names,paste("s(t,k=bf_covariates,bs=bs,m=m,by=inter_",i,"_",k,")",sep=""))
            }
          }
        }
        listofbys<-c(as.vector(names),c(inter_names))
        pred<-as.formula(paste("y_vec~",paste(listofbys,collapse="+"),"+s(t,k=bf,bs=bs,m=m)",sep=""))
        
      }
    }
  }else{
    ys<-curve_info$y_vec
    t<-curve_info$t
    pred<-ys~s(t,k=bf,bs=bs,m=m)
  }
  if(use_bam==TRUE){
    gam1<-try(bam(pred,data=dat_help,method=method))
  }else{
    gam1<-try(gam(pred,data=dat_help,method=method))
  } 
 
  dat_help<-NULL
  gc()
  
  
  
  ########################
  # estimation successfull
  ########################
  
  if(class(gam1)[1]!="try-error"){
    
    ###################
    ##extract intercept
    ###################
    intercept<-coefficients(gam1)[1]
    
    ###########
    # Make plot
    ###########
    # cols e.g. <-rainbow(n)
    if(plot==TRUE){
      t<-curve_info$t
      ys<-curve_info$y_vec
      plot(range(t[!is.na(t)]), range(ys[!is.na(ys)]), type = "n",xlab="time",ylab=ylab)
      for (i in 1:n){
        curve_info_use<-subset(curve_info,subset=n_long==i)
        t_use<-curve_info_use$t
        ys_use<-curve_info_use$y_vec
        lines(t_use, ys_use, col = cols[i]) 
      }
      par(new=T)
      plot(gam1,shift=intercept,seWithMean=TRUE, xlim=range(t[!is.na(t)]),
           ylim=range(ys[!is.na(ys)])-intercept,xlab="",main=title)
    }
    
    
    #######################
    # Evaluate mean on grid
    #######################
    # make data frame for prediction
    if(covariate){
      newdata<-data.table(t=my_grid)
      if(interaction){
        for(i in 1:num_covariates){
          newdata[,paste0("covariate.",i):=rep(1,length(my_grid))]
          for(k in 1:num_covariates){
            if(which_interaction[i,k]&(i<k)){
              newdata[,paste0("inter_",i,"_",k):=rep(1,length(my_grid))]
            }    
          }
        }
      }else{
        for(i in 1:num_covariates){
          newdata[,paste0("covariate.",i):=rep(1,length(my_grid))]
        }
      }
      
      # predict all components at once with type=terms
      mean_pred<-predict(gam1,newdata=newdata,type="terms")
      
      
    }else{
      newdat<-data.frame(t=my_grid)
      mean_pred<-predict(gam1,newdata=newdat)
    }
    
    
    # construct estimated mean on original data points 
    eta_hat<-fitted(gam1)
    
    ##########
    # center y
    ##########
    y_tilde<-curve_info$y_vec-eta_hat
    
  }else{ #if gam didnt succeed
    y_tilde<-rep(NA,length=nrow(curve_info))   # give out a vector of NAs. If the vector is full of NAs
    # then the rest (covariance etc. is not computed)
    intercept<-NA
    mean_pred<-NA
  }
  
  ########
  # Output
  ########
  results[["y_tilde"]]<- y_tilde
  results[["intercept"]]<-intercept
  results[["mean_pred"]]<-mean_pred
  if(save_gam==TRUE){
    results[["gam_object"]]<-gam1
  }else{
    gam1<-NULL
    gc()
  }
  
  return(results)
}

##################################################################################################################





