###################################################################################################################
# author: Jona Cederbaum
# date: 08.04.2015
##################################################################################################################
# description: function to generate orthonormal functions for irregualar functional data
##################################################################################################################

phiB<-function(k,t){
  tc<-2*(t-min(t))/(max(t)-min(t))-1    # if values are between -1,1, changes nothing
  if(k==1)
    result<-as.function(legendre.polynomials(k,normalized=TRUE)[[k]])(tc)
  if(k==2)
    result<-as.function(legendre.polynomials((k+1),normalized=TRUE)[[(k+1)]])(tc)
  return(result/sqrt((max(t)-min(t))/2))
}

phiC<-function(k,t){
  tc<-2*(t-min(t))/(max(t)-min(t))-1    # if values are between -1,1, changes nothing
  if(k==1)
    result<-as.function(legendre.polynomials((k+1),normalized=TRUE)[[(k+1)]])(tc)
  if(k==2)
    result<-as.function(legendre.polynomials((k+2),normalized=TRUE)[[(k+2)]])(tc)
  return(result/sqrt((max(t)-min(t))/2))
}

phiU<-function(k,t){
  if((k-1)%%2){
    result1<-function(t){cos(k*pi*t)}
    result2<-function(t){cos(k*pi*t)*cos(k*pi*t)}
  }else{
    result1<-function(t){sin((k+1)*pi*t)}
    result2<-function(t){sin((k+1)*pi*t)*sin((k+1)*pi*t)}
  }
  norm<-integrate(result2,lower=min(t),upper=max(t))$value
  result3<-sapply(t,FUN=result1)
  result<-result3/sqrt(norm)
  return(result)
}

