##################################################################################################################
# author: Jona Cederbaum
# date: 08.04.2015
##################################################################################################################
# description: Preparations for the covariance where only cross products of interest are constructed.
## uses functions in functions.R.
##################################################################################################################

prep_cov_fun<-function(y_tilde,curve_info,t,my_grid,d_grid,use_RI,I,J){
  
  output<-list()  # initialize output
  
  if(!use_RI){
    res <- vector(mode="list", length=I + J)  
  }else{
    res <- vector(mode="list", length=I )  
  }
  
  
  # loop over subjects (first grouping variable): 
  # get all combinations on the same subjects (same words (second grouping variable) or different words)
  for(i in seq_len(I)){
    res[[i]] <-  make_crossprod_dt(curve_info[subject_long==i, ])
  }
  
  if(!use_RI){   # only loop over words if crossed design
    # loop over words:
    # get all combinations on the same words with different subjects
    for(i in seq_len(J)){
      res[[I + i]] <-  make_crossprod_dt(curve_info[word_long==i, ], 
                                         preselection="word")
    }
  }
  
  ret <- do.call(rbind, res)
  setkey(ret, id1, id2)
  
  # take out id, y1, y2
  set(ret,i=NULL,"id1",NULL)
  set(ret,i=NULL,"id2",NULL)
  set(ret,i=NULL,"y1",NULL)
  set(ret,i=NULL,"y2",NULL)
  
  # rename t1 and t2
  setnames(ret, old=c("t1","t2"),new=c("row_t_bivariate","col_t_bivariate"))
  
  ############################################
  # create same_word, same_subject, same_point
  ############################################
  cat("index complete","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
  if(!use_RI){
    output[["index"]]<-create_data_frame_bivariate_fun(index=ret)   
  }else{
    output[["index"]]<-create_data_frame_bivariate_RI_fun(index=ret)   
  }
  
  
  #####################
  # construct grid data
  #####################
  cat("grid_help","; time ",format(Sys.time(),"%a %b %d %X"),"\n",sep="")
  grid_help<-create_grid_data_fun(my_grid=my_grid,d_grid=d_grid)
  
  output[["grid_row"]]<-grid_help$grid_row
  output[["grid_col"]]<-grid_help$grid_col
  
  output[["same_subject_grid"]]<-grid_help$same_subject
  if(!use_RI)
    output[["same_word_grid"]]<-grid_help$same_word
  output[["same_curve_grid"]]<-grid_help$same_curve_grid
  output[["same_point_grid"]]<-grid_help$same_point_grid
  
  rm(grid_help)
  
  output
}  
